/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.Util2;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.junit.Assert;
import org.junit.Test;

public class DistributionPlannerCycleTest {
    @Test
    public void timeJoinNodeTest() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select * from root.sg.d1,root.sg.d2";
        Analysis analysis = Util2.analyze(sql, context);
        PlanNode logicalPlanNode = Util2.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode firstNode = (PlanNode)((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertEquals((long)3L, (long)firstNode.getChildren().size());
        Assert.assertTrue((boolean)(firstNode.getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(firstNode.getChildren().get(1) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(firstNode.getChildren().get(2) instanceof ExchangeNode));
        PlanNode secondNode = (PlanNode)((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertEquals((long)3L, (long)secondNode.getChildren().size());
        Assert.assertTrue((boolean)(secondNode.getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(secondNode.getChildren().get(1) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(secondNode.getChildren().get(2) instanceof SeriesScanNode));
    }
}

