/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.Util;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationMergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.HorizontallyConcatNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.LeftOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.ShuffleSinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesSourceNode;
import org.junit.Assert;
import org.junit.Test;

public class AlignedByDeviceTest {
    @Test
    public void testAggregation2Device2Region() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d333,root.sg.d4444 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)f2Root.getChildren().get(0)).getChildren().get(0) instanceof SeriesAggregationScanNode));
        sql = "select count(s1),count(s2) from root.sg.d333,root.sg.d4444 align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)f2Root.getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)f2Root.getChildren().get(0)).getChildren().get(1) instanceof FullOuterTimeJoinNode));
    }

    @Test
    public void testAggregation2Device2RegionWithValueFilter() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d333,root.sg.d4444 where s1 <= 4 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)f2Root.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)f2Root.getChildren().get(0)).getChildren().get(1) instanceof AggregationNode));
        sql = "select count(s1),count(s2) from root.sg.d333,root.sg.d4444 where s1 <= 4 align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof AggregationNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)f2Root.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)f2Root.getChildren().get(0)).getChildren().get(1) instanceof AggregationNode));
    }

    @Test
    public void testAggregation2Device2RegionOrderByTime() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d333,root.sg.d4444 order by time align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(1) instanceof SeriesSourceNode));
        sql = "select count(s1),count(s2) from root.sg.d333,root.sg.d4444 order by time align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(1) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof HorizontallyConcatNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(1) instanceof HorizontallyConcatNode));
    }

    @Test
    public void testAggregation2Device2RegionWithValueFilterOrderByTime() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d333,root.sg.d4444 where s1 <= 4 order by time align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(1) instanceof SeriesSourceNode));
        sql = "select count(s1),count(s2) from root.sg.d333,root.sg.d4444 where s1 <= 4 order by time align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(1) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(2) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(3) instanceof SeriesScanNode));
    }

    @Test
    public void testAggregation2Device3Region() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d1,root.sg.d333 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        PlanNode f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesAggregationScanNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof SeriesAggregationScanNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f3Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof DeviceViewNode));
        sql = "select count(s1),count(s2) from root.sg.d1,root.sg.d333 align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f3Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof DeviceViewNode));
    }

    @Test
    public void testAggregation2Device3RegionWithValueFilter() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d1,root.sg.d333 where s1 <= 4 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        PlanNode f3Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f3Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof DeviceViewNode));
        sql = "select count(s1),count(s2) from root.sg.d1,root.sg.d333 where s1 <= 4 align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f3Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof DeviceViewNode));
    }

    @Test
    public void testAggregation2Device3RegionOrderByTime() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d1,root.sg.d333 order by time align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        PlanNode f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(f3Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof SeriesSourceNode));
        sql = "select count(s1),count(s2) from root.sg.d1,root.sg.d333 order by time align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(1) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof HorizontallyConcatNode));
        Assert.assertTrue((boolean)(f3Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof HorizontallyConcatNode));
    }

    @Test
    public void testAggregation2Device3RegionWithValueFilterOrderByTime() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select count(s1) from root.sg.d1,root.sg.d333 where s1 <= 4 order by time align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        PlanNode f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f3Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof SeriesScanNode));
        sql = "select count(s1),count(s2) from root.sg.d1,root.sg.d333 where s1 <= 4 order by time align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1)).getChildren().get(0) instanceof SeriesSourceNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(1)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(1) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f3Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof SeriesScanNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(1) instanceof SeriesScanNode));
    }

    @Test
    public void testDiffFunction2Device2Region() {
        QueryId queryId = new QueryId("test_special_process_align_by_device_2_device_2_region");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select diff(s1), diff(s2) from root.sg.d333,root.sg.d4444 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof TransformNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
    }

    @Test
    public void testDiffFunctionWithOrderByTime2Device2Region() {
        QueryId queryId = new QueryId("test_special_process_align_by_device_with_order_by_time_2_device_2_region");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select diff(s1), diff(s2) from root.sg.d333,root.sg.d4444 order by time align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
    }

    @Test
    public void testDiffFunction2Device3Region() {
        QueryId queryId = new QueryId("test_special_process_align_by_device_2_device_3_region");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select diff(s1), diff(s2) from root.sg.d1,root.sg.d22 align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        PlanNode f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f3Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof TransformNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof TransformNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)f3Root.getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
    }

    @Test
    public void testDiffFunctionWithOrderByTime2Device3Region() {
        QueryId queryId = new QueryId("test_special_process_align_by_device_with_order_by_time_2_device_3_region");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select diff(s1), diff(s2) from root.sg.d1,root.sg.d22 order by time align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        PlanNode f1Root = ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode f2Root = ((FragmentInstance)plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        PlanNode f3Root = ((FragmentInstance)plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(f1Root instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(f2Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f3Root instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(f1Root.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(f2Root.getChildren().get(0) instanceof FullOuterTimeJoinNode));
        Assert.assertTrue((boolean)(f3Root.getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)f1Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)f3Root.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
    }

    @Test
    public void testOrderByWithoutRedundantMergeSortOperator() {
        QueryId queryId = new QueryId("test");
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        String sql = "select * from root.sg.d1 order by time asc align by device";
        Analysis analysis = Util.analyze(sql, context);
        PlanNode logicalPlanNode = Util.genLogicalPlan(analysis, context);
        Assert.assertTrue((boolean)(logicalPlanNode instanceof DeviceViewNode));
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        sql = "select * from root.sg.d22 order by time asc align by device";
        analysis = Util.analyze(sql, context);
        logicalPlanNode = Util.genLogicalPlan(analysis, context);
        Assert.assertTrue((boolean)(logicalPlanNode instanceof DeviceViewNode));
        planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, logicalPlanNode));
        plan = planner.planFragments();
        Assert.assertEquals((long)1L, (long)plan.getInstances().size());
    }
}

