/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.Util;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FillNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TopKNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.junit.Assert;
import org.junit.Test;

public class AlignByTimeOrderByLimitOffsetTest {
    private static final long LIMIT_VALUE = 10L;
    QueryId queryId = new QueryId("test");
    MPPQueryContext context = new MPPQueryContext("", this.queryId, null, new TEndPoint(), new TEndPoint());
    String sql;
    Analysis analysis;
    PlanNode logicalPlanNode;
    DistributionPlanner planner;
    DistributedQueryPlan plan;
    PlanNode firstFiRoot;
    PlanNode firstFiTopNode;

    @Test
    public void orderByExpressionTest1() {
        int i;
        this.sql = String.format("select * from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY root.sg.d1.s1 DESC LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TopKNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof FullOuterTimeJoinNode));
        for (i = 1; i < 4; ++i) {
            Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof FullOuterTimeJoinNode));
        }
        this.sql = String.format("select * from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY root.sg.d1.s1 DESC OFFSET 5 LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof LimitNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof OffsetNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof TopKNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        for (i = 1; i < 4; ++i) {
            Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof FullOuterTimeJoinNode));
        }
    }

    @Test
    public void orderByExpressionTest2() {
        this.sql = String.format("select s1 from root.sg.d1 ORDER BY root.sg.d22.s2 DESC LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TransformNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof TopKNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        this.sql = String.format("select s1 from root.sg.d1 ORDER BY root.sg.d22.s2 DESC OFFSET 5 LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof LimitNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof OffsetNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof TransformNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof TopKNode));
    }

    @Test
    public void orderByExpressionTest3() {
        this.sql = String.format("select count(s1) from root.sg.d1 ORDER BY count(root.sg.d22.s2) DESC LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TransformNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof TopKNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        this.sql = String.format("select count(s1) from root.sg.d1 ORDER BY count(root.sg.d22.s2) DESC OFFSET 5 LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof LimitNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof OffsetNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof TransformNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof TopKNode));
    }

    @Test
    public void orderByFillTest() {
        int i;
        this.sql = String.format("select * from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY root.sg.d1.s1 DESC fill(previous) LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof FillNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof TopKNode));
        for (i = 1; i < 4; ++i) {
            Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof FullOuterTimeJoinNode));
        }
        this.sql = String.format("select * from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY root.sg.d1.s1 DESC fill(linear) LIMIT %s", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof LimitNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof FillNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof SortNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        for (i = 1; i < 4; ++i) {
            Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof FullOuterTimeJoinNode));
        }
    }
}

