/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.Util;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationMergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TopKNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.LeftOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.junit.Assert;
import org.junit.Test;

public class AlignByDeviceOrderByLimitOffsetTest {
    private static final long LIMIT_VALUE = 10L;
    QueryId queryId = new QueryId("test");
    MPPQueryContext context = new MPPQueryContext("", this.queryId, null, new TEndPoint(), new TEndPoint());
    String sql;
    Analysis analysis;
    PlanNode logicalPlanNode;
    DistributionPlanner planner;
    DistributedQueryPlan plan;
    PlanNode firstFiRoot;
    PlanNode firstFiTopNode;
    PlanNode mergeSortNode;

    @Test
    public void orderByDeviceTest1() {
        this.sql = "select * from root.sg.d1, root.sg.d22 LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.firstFiRoot.getChildren().get(0) instanceof LimitNode));
        this.mergeSortNode = ((LimitNode)this.firstFiRoot.getChildren().get(0)).getChild();
        Assert.assertTrue((boolean)(this.mergeSortNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.mergeSortNode.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.mergeSortNode.getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        this.sql = "select * from root.sg.d1, root.sg.d22 order by device asc, time desc LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.firstFiRoot.getChildren().get(0) instanceof LimitNode));
        this.mergeSortNode = ((LimitNode)this.firstFiRoot.getChildren().get(0)).getChild();
        Assert.assertTrue((boolean)(this.mergeSortNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.mergeSortNode.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.mergeSortNode.getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree(), 10L);
    }

    @Test
    public void orderByDeviceTest2() {
        this.sql = "select * from root.sg.d1, root.sg.d22 order by device asc, s1 desc LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.firstFiRoot.getChildren().get(0) instanceof LimitNode));
        this.mergeSortNode = ((LimitNode)this.firstFiRoot.getChildren().get(0)).getChild();
        Assert.assertTrue((boolean)(this.mergeSortNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.mergeSortNode.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.mergeSortNode.getChildren().get(0)).getChildren().get(0) instanceof SortNode));
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree(), 10L);
    }

    @Test
    public void orderByDeviceTest3() {
        this.sql = "select s1 from root.sg.d1, root.sg.d22 WHERE s2=1 order by device asc, s2 desc LIMIT 5 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.firstFiRoot.getChildren().get(0) instanceof LimitNode));
        PlanNode transformNode = ((LimitNode)this.firstFiRoot.getChildren().get(0)).getChild();
        Assert.assertTrue((boolean)(transformNode instanceof TransformNode));
        Assert.assertTrue((boolean)(transformNode.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)transformNode.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)transformNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SortNode));
    }

    @Test
    public void orderByDeviceTest4() {
        this.sql = "select count(s1) from root.sg.d1, root.sg.d22 WHERE s2=1 having(count(s1)>1) LIMIT 5 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)3L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.firstFiRoot.getChildren().get(0) instanceof LimitNode));
        PlanNode filterNode = ((LimitNode)this.firstFiRoot.getChildren().get(0)).getChild();
        Assert.assertTrue((boolean)(filterNode instanceof FilterNode));
        Assert.assertTrue((boolean)(filterNode.getChildren().get(0) instanceof AggregationMergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)filterNode.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)filterNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        PlanNode thirdFiRoot = ((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(thirdFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(thirdFiRoot.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)thirdFiRoot.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
    }

    @Test
    public void orderByTimeTest1() {
        this.sql = String.format("select * from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY TIME DESC LIMIT %s align by device", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        Assert.assertEquals((long)4L, (long)((PlanNode)this.firstFiRoot.getChildren().get(0)).getChildren().size());
        PlanNode firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(firstFiTopNode instanceof TopKNode));
        for (PlanNode node : ((PlanNode)firstFiTopNode.getChildren().get(0)).getChildren()) {
            Assert.assertTrue((boolean)(node instanceof SingleDeviceViewNode));
        }
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(3) instanceof ExchangeNode));
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree(), 10L);
    }

    @Test
    public void orderByTimeTest2() {
        this.sql = String.format("select s1 from root.sg.d1,root.sg.d22,root.sg.d333 where s2>1 ORDER BY TIME DESC LIMIT %s align by device", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(firstFiTopNode instanceof TopKNode));
        for (PlanNode node : ((PlanNode)firstFiTopNode.getChildren().get(0)).getChildren()) {
            Assert.assertTrue((boolean)(node instanceof SingleDeviceViewNode));
            Assert.assertTrue((boolean)(node.getChildren().get(0) instanceof LimitNode));
            Assert.assertTrue((boolean)(((PlanNode)node.getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        }
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(3) instanceof ExchangeNode));
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree(), 0L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree(), 0L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree(), 0L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree(), 0L);
    }

    @Test
    public void orderByTimeTest3() {
        this.sql = String.format("select s1 from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY TIME DESC, s2 DESC LIMIT %s align by device", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TopKNode));
        for (PlanNode node : ((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren()) {
            Assert.assertTrue((boolean)(node instanceof DeviceViewNode));
        }
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(3) instanceof ExchangeNode));
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree(), 10L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree(), 10L);
        this.sql = String.format("select s1 from root.sg.d1,root.sg.d22,root.sg.d333 where s2>1 ORDER BY TIME DESC, s2 DESC LIMIT %s align by device", 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TopKNode));
        for (PlanNode node : ((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren()) {
            Assert.assertTrue((boolean)(node instanceof DeviceViewNode));
            Assert.assertTrue((boolean)(node.getChildren().get(0) instanceof LimitNode));
            Assert.assertTrue((boolean)(((PlanNode)node.getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
            Assert.assertTrue((boolean)(((PlanNode)((PlanNode)node.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        }
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(3) instanceof ExchangeNode));
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree(), 0L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree(), 0L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree(), 0L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree(), 0L);
    }

    @Test
    public void orderByTimeTest4() {
        this.sql = "select count(s1) from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY TIME DESC align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertEquals((long)3L, (long)this.firstFiTopNode.getChildren().size());
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(2) instanceof SingleDeviceViewNode));
        this.sql = "select count(s1) from root.sg.d1,root.sg.d22,root.sg.d333 group by ((1,10], 1ms) ORDER BY TIME DESC align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertEquals((long)3L, (long)this.firstFiTopNode.getChildren().size());
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(2) instanceof SingleDeviceViewNode));
    }

    @Test
    public void orderByTimeTest5() {
        this.sql = "select count(s1) from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY TIME DESC LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TopKNode));
        Assert.assertEquals((long)2L, (long)this.firstFiTopNode.getChildren().size());
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof TopKNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SeriesAggregationScanNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SeriesAggregationScanNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof TopKNode));
        this.sql = "select count(s1) from root.sg.d1,root.sg.d22,root.sg.d333 group by ((1,10], 1ms) ORDER BY TIME DESC LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TopKNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof TopKNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SeriesAggregationScanNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SeriesAggregationScanNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof TopKNode));
    }

    @Test
    public void orderByTimeTest6() {
        this.sql = "select count(s1) from root.sg.d1,root.sg.d22,root.sg.d333 having(count(s1)>1) ORDER BY TIME DESC  LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof LimitNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof FilterNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof MergeSortNode));
        Assert.assertEquals((long)3L, (long)((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().size());
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(2) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SeriesAggregationScanNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SeriesAggregationScanNode));
    }

    @Test
    public void orderByTimeWithOffsetTest() {
        this.sql = String.format("select * from root.sg.** ORDER BY time DESC OFFSET %s LIMIT %s align by device", 10L, 10L);
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        PlanNode firstFIFirstNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(firstFIFirstNode instanceof LimitNode));
        PlanNode firstFiTopNode = (PlanNode)((LimitNode)firstFIFirstNode).getChild().getChildren().get(0);
        for (PlanNode node : ((PlanNode)firstFiTopNode.getChildren().get(0)).getChildren()) {
            Assert.assertTrue((boolean)(node instanceof SingleDeviceViewNode));
        }
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(firstFiTopNode.getChildren().get(3) instanceof ExchangeNode));
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree(), 20L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree(), 20L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree(), 20L);
        this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(3)).getFragment().getPlanNodeTree(), 20L);
    }

    @Test
    public void orderByExpressionTest1() {
        int i;
        this.sql = "select s1 from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY s2 DESC align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TransformNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof SortNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(3) instanceof ExchangeNode));
        for (i = 1; i < 4; ++i) {
            Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SortNode));
            Assert.assertTrue((boolean)(((PlanNode)((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        }
        for (i = 0; i < 4; ++i) {
            this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree(), 0L);
        }
    }

    @Test
    public void orderByExpressionTest2() {
        this.sql = "select s1 from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY s2 DESC LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TopKNode));
        for (PlanNode node : ((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren()) {
            Assert.assertTrue((boolean)(node instanceof DeviceViewNode));
            Assert.assertTrue((boolean)(node.getChildren().get(0) instanceof FullOuterTimeJoinNode));
        }
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(1) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(2) instanceof ExchangeNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(3) instanceof ExchangeNode));
        for (int i = 0; i < 4; ++i) {
            this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree(), 0L);
        }
    }

    @Test
    public void orderByExpressionTest3() {
        this.sql = "select count(s1) from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY count(s2) DESC align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TransformNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof SortNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SortNode));
        Assert.assertTrue((boolean)(((FragmentInstance)this.plan.getInstances().get(2)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof SortNode));
        for (int i = 0; i < 4; ++i) {
            this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree(), 0L);
        }
    }

    @Test
    public void orderByExpressionTest4() {
        int i;
        this.sql = "select count(s1) from root.sg.d1,root.sg.d22,root.sg.d333 ORDER BY count(s2) DESC LIMIT 10 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)4L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TopKNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof TopKNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof FullOuterTimeJoinNode));
        for (i = 1; i < 4; ++i) {
            Assert.assertTrue((boolean)(((PlanNode)((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        }
        for (i = 0; i < 4; ++i) {
            this.assertScanNodeLimitValue(((FragmentInstance)this.plan.getInstances().get(i)).getFragment().getPlanNodeTree(), 0L);
        }
    }

    private void assertScanNodeLimitValue(PlanNode root, long limitValue) {
        for (PlanNode node : root.getChildren()) {
            if (node instanceof SeriesScanNode) {
                Assert.assertEquals((long)limitValue, (long)((SeriesScanNode)node).getPushDownLimit());
                continue;
            }
            if (node instanceof AlignedSeriesScanNode) {
                Assert.assertEquals((long)limitValue, (long)((AlignedSeriesScanNode)node).getPushDownLimit());
                continue;
            }
            this.assertScanNodeLimitValue(node, limitValue);
        }
    }
}

