/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.Util;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.HorizontallyConcatNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.LeftOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.ShuffleSinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.junit.Assert;
import org.junit.Test;

public class AggregationAlignByDeviceTest {
    private static final long LIMIT_VALUE = 10L;
    QueryId queryId = new QueryId("test");
    MPPQueryContext context = new MPPQueryContext("", this.queryId, null, new TEndPoint(), new TEndPoint());
    String sql;
    Analysis analysis;
    PlanNode logicalPlanNode;
    DistributionPlanner planner;
    DistributedQueryPlan plan;
    PlanNode firstFiRoot;
    PlanNode secondFiRoot;
    PlanNode firstFiTopNode;

    @Test
    public void orderByDeviceTest1() {
        this.sql = "select first_value(s1) from root.sg.d22, root.sg.d55555 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)2L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof SeriesAggregationScanNode));
        this.secondFiRoot = ((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.secondFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.secondFiRoot.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0) instanceof SeriesAggregationScanNode));
        this.sql = "select first_value(s1) from root.sg.d22 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)1L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof SeriesAggregationScanNode));
        this.sql = "select first_value(s1), count(s2) from root.sg.d22, root.sg.d55555 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)2L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof HorizontallyConcatNode));
        this.secondFiRoot = ((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.secondFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.secondFiRoot.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0) instanceof HorizontallyConcatNode));
        this.sql = "select first_value(s1), count(s2) from root.sg.d22 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)1L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof HorizontallyConcatNode));
    }

    @Test
    public void orderByDeviceTest2() {
        this.sql = "select first_value(s1) from root.sg.d22, root.sg.d55555 where s2>1 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)2L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        this.secondFiRoot = ((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.secondFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.secondFiRoot.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        this.sql = "select first_value(s1), count(s2) from root.sg.d22, root.sg.d55555 where s2>1 align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)2L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
        this.secondFiRoot = ((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.secondFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.secondFiRoot.getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0) instanceof AggregationNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof ProjectNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof LeftOuterTimeJoinNode));
    }

    @Test
    public void orderByExpressionTest() {
        this.sql = "select avg(s1)+avg(s2) from root.sg.d22, root.sg.d55555 order by max_value(s2) align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)2L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof TransformNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof MergeSortNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof SortNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof TransformNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof HorizontallyConcatNode));
        this.secondFiRoot = ((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.secondFiRoot instanceof IdentitySinkNode));
        Assert.assertTrue((boolean)(this.secondFiRoot.getChildren().get(0) instanceof SortNode));
        Assert.assertTrue((boolean)(((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0) instanceof TransformNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)((PlanNode)((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getChildren().get(0) instanceof HorizontallyConcatNode));
    }

    @Test
    public void orderByTimeTest1() {
        this.sql = "select first_value(s1) from root.sg.d22, root.sg.d55555 order by time desc align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)2L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof SeriesAggregationScanNode));
        this.secondFiRoot = ((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.secondFiRoot instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(this.secondFiRoot.getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0) instanceof SeriesAggregationScanNode));
        this.sql = "select first_value(s1) from root.sg.d22 order by time desc align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)1L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof SeriesAggregationScanNode));
        this.sql = "select first_value(s1), count(s2) from root.sg.d22, root.sg.d55555 order by time desc align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)2L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof MergeSortNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.firstFiTopNode.getChildren().get(0)).getChildren().get(0) instanceof HorizontallyConcatNode));
        this.secondFiRoot = ((FragmentInstance)this.plan.getInstances().get(1)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.secondFiRoot instanceof ShuffleSinkNode));
        Assert.assertTrue((boolean)(this.secondFiRoot.getChildren().get(0) instanceof SingleDeviceViewNode));
        Assert.assertTrue((boolean)(((PlanNode)this.secondFiRoot.getChildren().get(0)).getChildren().get(0) instanceof HorizontallyConcatNode));
        this.sql = "select first_value(s1), count(s2) from root.sg.d22 order by time desc align by device";
        this.analysis = Util.analyze(this.sql, this.context);
        this.logicalPlanNode = Util.genLogicalPlan(this.analysis, this.context);
        this.planner = new DistributionPlanner(this.analysis, new LogicalQueryPlan(this.context, this.logicalPlanNode));
        this.plan = this.planner.planFragments();
        Assert.assertEquals((long)1L, (long)this.plan.getInstances().size());
        this.firstFiRoot = ((FragmentInstance)this.plan.getInstances().get(0)).getFragment().getPlanNodeTree();
        Assert.assertTrue((boolean)(this.firstFiRoot instanceof IdentitySinkNode));
        this.firstFiTopNode = (PlanNode)this.firstFiRoot.getChildren().get(0);
        Assert.assertTrue((boolean)(this.firstFiTopNode instanceof DeviceViewNode));
        Assert.assertTrue((boolean)(this.firstFiTopNode.getChildren().get(0) instanceof HorizontallyConcatNode));
    }
}

