/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.process.SingleDeviceViewOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.ExchangeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanContext;
import org.apache.iotdb.db.queryengine.plan.planner.OperatorTreeGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.PipelineDriverFactory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TopKNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.LeftOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PipelineBuilderTest {
    OperatorTreeGenerator operatorTreeGenerator = new OperatorTreeGenerator();

    @Test
    public void testConsumeAllChildrenPipelineBuilder1() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        FullOuterTimeJoinNode fullOuterTimeJoinNode = this.initFullOuterTimeJoinNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(1);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)fullOuterTimeJoinNode, context);
        Assert.assertEquals((long)0L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        Assert.assertEquals((long)4L, (long)fullOuterTimeJoinNode.getChildren().size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(i)).getClass());
            Assert.assertEquals(SeriesScanNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getClass());
            Assert.assertEquals((Object)String.format("root.sg.d%d.s1", i), ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getOutputColumnNames().get(0));
        }
        Assert.assertEquals((long)0L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeAllChildrenPipelineBuilder2() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        FullOuterTimeJoinNode fullOuterTimeJoinNode = this.initFullOuterTimeJoinNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(2);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)fullOuterTimeJoinNode, context);
        Assert.assertEquals((long)1L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)3L, (long)childrenOperator.size());
        Assert.assertEquals((long)3L, (long)fullOuterTimeJoinNode.getChildren().size());
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(i)).getClass());
            Assert.assertEquals(SeriesScanNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getClass());
        }
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(2)).getClass());
        Assert.assertEquals((Object)"root.sg.d0.s1", ((PlanNode)fullOuterTimeJoinNode.getChildren().get(0)).getOutputColumnNames().get(0));
        Assert.assertEquals((Object)"root.sg.d1.s1", ((PlanNode)fullOuterTimeJoinNode.getChildren().get(1)).getOutputColumnNames().get(0));
        Assert.assertEquals(FullOuterTimeJoinNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(2)).getClass());
        FullOuterTimeJoinNode subFullOuterTimeJoinNode = (FullOuterTimeJoinNode)fullOuterTimeJoinNode.getChildren().get(2);
        Assert.assertEquals((long)2L, (long)subFullOuterTimeJoinNode.getChildren().size());
        Assert.assertEquals((Object)"root.sg.d2.s1", ((PlanNode)subFullOuterTimeJoinNode.getChildren().get(0)).getOutputColumnNames().get(0));
        Assert.assertEquals((Object)"root.sg.d3.s1", ((PlanNode)subFullOuterTimeJoinNode.getChildren().get(1)).getOutputColumnNames().get(0));
        Assert.assertEquals((long)1L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeAllChildrenPipelineBuilder3() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        FullOuterTimeJoinNode fullOuterTimeJoinNode = this.initFullOuterTimeJoinNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(3);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)fullOuterTimeJoinNode, context);
        Assert.assertEquals((long)2L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)3L, (long)childrenOperator.size());
        Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(0)).getClass());
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(1)).getClass());
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(2)).getClass());
        Assert.assertEquals((long)3L, (long)fullOuterTimeJoinNode.getChildren().size());
        Assert.assertEquals((Object)"root.sg.d0.s1", ((PlanNode)fullOuterTimeJoinNode.getChildren().get(0)).getOutputColumnNames().get(0));
        Assert.assertEquals((Object)"root.sg.d1.s1", ((PlanNode)fullOuterTimeJoinNode.getChildren().get(1)).getOutputColumnNames().get(0));
        Assert.assertEquals(FullOuterTimeJoinNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(2)).getClass());
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SeriesScanNode1", (Object)exchangeOperator1.getSourceId().getId());
        FullOuterTimeJoinNode subFullOuterTimeJoinNode = (FullOuterTimeJoinNode)fullOuterTimeJoinNode.getChildren().get(2);
        Assert.assertEquals((long)2L, (long)subFullOuterTimeJoinNode.getChildren().size());
        Assert.assertEquals((Object)"root.sg.d2.s1", ((PlanNode)subFullOuterTimeJoinNode.getChildren().get(0)).getOutputColumnNames().get(0));
        Assert.assertEquals((Object)"root.sg.d3.s1", ((PlanNode)subFullOuterTimeJoinNode.getChildren().get(1)).getOutputColumnNames().get(0));
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)exchangeOperator2.getSourceId(), (Object)subFullOuterTimeJoinNode.getPlanNodeId());
        Assert.assertEquals((long)2L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeAllChildrenPipelineBuilder4() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        FullOuterTimeJoinNode fullOuterTimeJoinNode = this.initFullOuterTimeJoinNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(4);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)fullOuterTimeJoinNode, context);
        Assert.assertEquals((long)3L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(0)).getClass());
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(1)).getClass());
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(2)).getClass());
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(3)).getClass());
        Assert.assertEquals((long)4L, (long)fullOuterTimeJoinNode.getChildren().size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(SeriesScanNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getClass());
            Assert.assertEquals((Object)String.format("root.sg.d%d.s1", i), ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getOutputColumnNames().get(0));
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SeriesScanNode1", (Object)exchangeOperator1.getSourceId().getId());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"SeriesScanNode2", (Object)exchangeOperator2.getSourceId().getId());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"SeriesScanNode3", (Object)exchangeOperator3.getSourceId().getId());
        Assert.assertEquals((long)3L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeAllChildrenPipelineBuilder5() throws IllegalPathException {
        int i;
        TypeProvider typeProvider = new TypeProvider();
        FullOuterTimeJoinNode fullOuterTimeJoinNode = this.initFullOuterTimeJoinNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(5);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)fullOuterTimeJoinNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        Assert.assertEquals((long)4L, (long)fullOuterTimeJoinNode.getChildren().size());
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals(SeriesScanNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getClass());
            Assert.assertEquals((Object)String.format("root.sg.d%d.s1", i), ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getOutputColumnNames().get(0));
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"SeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"SeriesScanNode2", (Object)exchangeOperator3.getSourceId().getId());
        ExchangeOperator exchangeOperator4 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"SeriesScanNode3", (Object)exchangeOperator4.getSourceId().getId());
        Assert.assertEquals((long)4L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeAllChildrenPipelineBuilder6() throws IllegalPathException {
        int i;
        TypeProvider typeProvider = new TypeProvider();
        FullOuterTimeJoinNode fullOuterTimeJoinNode = this.initFullOuterTimeJoinNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(6);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)fullOuterTimeJoinNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        Assert.assertEquals((long)4L, (long)fullOuterTimeJoinNode.getChildren().size());
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals(SeriesScanNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getClass());
            Assert.assertEquals((Object)String.format("root.sg.d%d.s1", i), ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getOutputColumnNames().get(0));
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"SeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"SeriesScanNode2", (Object)exchangeOperator3.getSourceId().getId());
        ExchangeOperator exchangeOperator4 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"SeriesScanNode3", (Object)exchangeOperator4.getSourceId().getId());
        Assert.assertEquals((long)4L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testTopKConsumeAllChildrenPipelineBuilder3() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        TopKNode topKNode = this.initTopKNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(3);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)topKNode, context);
        Assert.assertEquals((long)2L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)3L, (long)childrenOperator.size());
        Assert.assertEquals(SingleDeviceViewOperator.class, ((Operator)childrenOperator.get(0)).getClass());
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(1)).getClass());
        Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(2)).getClass());
        Assert.assertEquals((long)3L, (long)topKNode.getChildren().size());
        Assert.assertEquals((Object)"Time", ((PlanNode)topKNode.getChildren().get(0)).getOutputColumnNames().get(0));
        Assert.assertEquals((Object)"Time", ((PlanNode)topKNode.getChildren().get(1)).getOutputColumnNames().get(0));
        Assert.assertEquals((Object)"Time", ((PlanNode)topKNode.getChildren().get(2)).getOutputColumnNames().get(0));
        Assert.assertEquals(TopKNode.class, ((PlanNode)topKNode.getChildren().get(2)).getClass());
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SingleDeviceViewNode1", (Object)exchangeOperator1.getSourceId().getId());
        TopKNode subTimeJoinNode = (TopKNode)topKNode.getChildren().get(2);
        Assert.assertEquals((long)2L, (long)subTimeJoinNode.getChildren().size());
        Assert.assertEquals((Object)"Time", ((PlanNode)subTimeJoinNode.getChildren().get(0)).getOutputColumnNames().get(0));
        Assert.assertEquals((Object)"Time", ((PlanNode)subTimeJoinNode.getChildren().get(1)).getOutputColumnNames().get(0));
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)exchangeOperator2.getSourceId(), (Object)subTimeJoinNode.getPlanNodeId());
        Assert.assertEquals((long)2L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeOneByOneChildrenPipelineBuilder1() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        DeviceViewNode deviceViewNode = this.initDeviceViewNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(1);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeChildrenOneByOneNode((PlanNode)deviceViewNode, context);
        Assert.assertEquals((long)0L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(AlignedSeriesScanOperator.class, ((Operator)childrenOperator.get(i)).getClass());
            Assert.assertEquals((Object)String.format("root.sg.d%d.s1", i), ((PlanNode)deviceViewNode.getChildren().get(i)).getOutputColumnNames().get(0));
        }
        Assert.assertEquals((long)0L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeOneByOneChildrenPipelineBuilder2() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        DeviceViewNode deviceViewNode = this.initDeviceViewNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(2);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeChildrenOneByOneNode((PlanNode)deviceViewNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"AlignedSeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"AlignedSeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        Assert.assertEquals((long)0L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"AlignedSeriesScanNode2", (Object)exchangeOperator3.getSourceId().getId());
        Assert.assertEquals((long)1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(2)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator4 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"AlignedSeriesScanNode3", (Object)exchangeOperator4.getSourceId().getId());
        Assert.assertEquals((long)2L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(3)).getDependencyPipelineIndex());
        Assert.assertEquals((long)1L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeOneByOneChildrenPipelineBuilder3() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        DeviceViewNode deviceViewNode = this.initDeviceViewNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(3);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeChildrenOneByOneNode((PlanNode)deviceViewNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"AlignedSeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"AlignedSeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"AlignedSeriesScanNode2", (Object)exchangeOperator3.getSourceId().getId());
        Assert.assertEquals((long)0L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(2)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator4 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"AlignedSeriesScanNode3", (Object)exchangeOperator4.getSourceId().getId());
        Assert.assertEquals((long)1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(3)).getDependencyPipelineIndex());
        Assert.assertEquals((long)2L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeOneByOneChildrenPipelineBuilder4() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        DeviceViewNode deviceViewNode = this.initDeviceViewNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(4);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeChildrenOneByOneNode((PlanNode)deviceViewNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"AlignedSeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"AlignedSeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"AlignedSeriesScanNode2", (Object)exchangeOperator3.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(2)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator4 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"AlignedSeriesScanNode3", (Object)exchangeOperator4.getSourceId().getId());
        Assert.assertEquals((long)0L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(3)).getDependencyPipelineIndex());
        Assert.assertEquals((long)3L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeOneByOneChildrenPipelineBuilder5() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        DeviceViewNode deviceViewNode = this.initDeviceViewNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(5);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeChildrenOneByOneNode((PlanNode)deviceViewNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"AlignedSeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"AlignedSeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"AlignedSeriesScanNode2", (Object)exchangeOperator3.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(2)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator4 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"AlignedSeriesScanNode3", (Object)exchangeOperator4.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(3)).getDependencyPipelineIndex());
        Assert.assertEquals((long)4L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeOneByOneChildrenPipelineBuilder6() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        DeviceViewNode deviceViewNode = this.initDeviceViewNode(typeProvider, 4);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(5);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeChildrenOneByOneNode((PlanNode)deviceViewNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)4L, (long)childrenOperator.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"AlignedSeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"AlignedSeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator3 = (ExchangeOperator)childrenOperator.get(2);
        Assert.assertEquals((Object)"AlignedSeriesScanNode2", (Object)exchangeOperator3.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(2)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator4 = (ExchangeOperator)childrenOperator.get(3);
        Assert.assertEquals((Object)"AlignedSeriesScanNode3", (Object)exchangeOperator4.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(3)).getDependencyPipelineIndex());
        Assert.assertEquals((long)4L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeOneByOneChildrenPipelineBuilderDependency() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        typeProvider.setType("root.sg.d0.s1", TSDataType.INT64);
        typeProvider.setType("root.sg.d1.s1", TSDataType.INT64);
        typeProvider.setType("count(root.sg.d0.s1)", TSDataType.INT64);
        typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
        DeviceViewNode deviceViewNode = new DeviceViewNode(new PlanNodeId("DeviceViewNode"), null, null, null);
        for (int i = 0; i < 2; ++i) {
            MeasurementPath path = new MeasurementPath(String.format("root.sg.d%d.s1", i), TSDataType.INT64);
            AggregationNode aggregationNode = new AggregationNode(new PlanNodeId(String.format("AggregationOperator%d", i)), Collections.singletonList(new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)path)))), null, Ordering.ASC);
            SeriesAggregationScanNode seriesAggregationScanNode = new SeriesAggregationScanNode(new PlanNodeId(String.format("seriesAggregationScanNode%d", i)), path, Collections.singletonList(new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)path)))));
            ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId(String.format("ExchangeNode%d", i)));
            exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
            aggregationNode.addChild((PlanNode)seriesAggregationScanNode);
            aggregationNode.addChild((PlanNode)exchangeNode);
            deviceViewNode.addChild((PlanNode)aggregationNode);
        }
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(3);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeChildrenOneByOneNode((PlanNode)deviceViewNode, context);
        Assert.assertEquals((long)4L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)2L, (long)childrenOperator.size());
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
        }
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        Assert.assertEquals((long)1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(2)).getDependencyPipelineIndex());
        Assert.assertEquals((long)1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(2)).getDependencyPipelineIndex());
    }

    @Test
    public void testGetChildNumInEachPipeline() {
        ArrayList<Object> allChildren = new ArrayList<Object>();
        allChildren.add(new ExchangeNode(new PlanNodeId("remoteNode1")));
        allChildren.add(new SeriesScanNode(new PlanNodeId("localNode1"), null));
        allChildren.add(new ExchangeNode(new PlanNodeId("remoteNode2")));
        allChildren.add(new SeriesScanNode(new PlanNodeId("localNode2"), null));
        int[] childNumInEachPipeline = this.operatorTreeGenerator.getChildNumInEachPipeline(allChildren, 2, 2);
        Assert.assertEquals((long)2L, (long)childNumInEachPipeline.length);
        Assert.assertEquals((long)2L, (long)childNumInEachPipeline[0]);
        Assert.assertEquals((long)1L, (long)childNumInEachPipeline[1]);
        allChildren.add(new SeriesScanNode(new PlanNodeId("localNode3"), null));
        allChildren.add(new SeriesScanNode(new PlanNodeId("localNode4"), null));
        allChildren.add(new ExchangeNode(new PlanNodeId("remoteNode3")));
        allChildren.add(new ExchangeNode(new PlanNodeId("remoteNode4")));
        allChildren.add(new SeriesScanNode(new PlanNodeId("localNode5"), null));
        allChildren.add(new ExchangeNode(new PlanNodeId("remoteNode5")));
        childNumInEachPipeline = this.operatorTreeGenerator.getChildNumInEachPipeline(allChildren, 5, 3);
        Assert.assertEquals((long)3L, (long)childNumInEachPipeline.length);
        Assert.assertEquals((long)2L, (long)childNumInEachPipeline[0]);
        Assert.assertEquals((long)2L, (long)childNumInEachPipeline[1]);
        Assert.assertEquals((long)5L, (long)childNumInEachPipeline[2]);
    }

    @Test
    public void testLeftOuterTimeJoinPipelineBuilder1() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        LeftOuterTimeJoinNode leftOuterTimeJoinNode = this.initLeftOuterTimeJoinNode(typeProvider);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(1);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)leftOuterTimeJoinNode, context);
        Assert.assertEquals((long)0L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)2L, (long)childrenOperator.size());
        Assert.assertEquals((long)2L, (long)leftOuterTimeJoinNode.getChildren().size());
        Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(0)).getClass());
        Assert.assertEquals(SeriesScanNode.class, leftOuterTimeJoinNode.getLeftChild().getClass());
        Assert.assertEquals((Object)"root.sg.d0.s1", leftOuterTimeJoinNode.getLeftChild().getOutputColumnNames().get(0));
        Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(1)).getClass());
        Assert.assertEquals(SeriesScanNode.class, leftOuterTimeJoinNode.getRightChild().getClass());
        Assert.assertEquals((Object)"root.sg.d1.s1", leftOuterTimeJoinNode.getRightChild().getOutputColumnNames().get(0));
        Assert.assertEquals((long)0L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testLeftOuterTimeJoinPipelineBuilder2() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        LeftOuterTimeJoinNode leftOuterTimeJoinNode = this.initLeftOuterTimeJoinNode(typeProvider);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(2);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)leftOuterTimeJoinNode, context);
        Assert.assertEquals((long)1L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)2L, (long)childrenOperator.size());
        Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(0)).getClass());
        Assert.assertEquals((Object)"root.sg.d0.s1", leftOuterTimeJoinNode.getLeftChild().getOutputColumnNames().get(0));
        ExchangeOperator exchangeOperator = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SeriesScanNode1", (Object)exchangeOperator.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        Assert.assertEquals((long)1L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testLeftOuterTimeJoinPipelineBuilder3() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        LeftOuterTimeJoinNode leftOuterTimeJoinNode = this.initLeftOuterTimeJoinNode(typeProvider);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(3);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)leftOuterTimeJoinNode, context);
        Assert.assertEquals((long)2L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)2L, (long)childrenOperator.size());
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"SeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        Assert.assertEquals((long)2L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testLeftOuterTimeJoinPipelineBuilder4() throws IllegalPathException {
        TypeProvider typeProvider = new TypeProvider();
        LeftOuterTimeJoinNode leftOuterTimeJoinNode = this.initLeftOuterTimeJoinNode(typeProvider);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(4);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)leftOuterTimeJoinNode, context);
        Assert.assertEquals((long)2L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)2L, (long)childrenOperator.size());
        ExchangeOperator exchangeOperator1 = (ExchangeOperator)childrenOperator.get(0);
        Assert.assertEquals((Object)"SeriesScanNode0", (Object)exchangeOperator1.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(0)).getDependencyPipelineIndex());
        ExchangeOperator exchangeOperator2 = (ExchangeOperator)childrenOperator.get(1);
        Assert.assertEquals((Object)"SeriesScanNode1", (Object)exchangeOperator2.getSourceId().getId());
        Assert.assertEquals((long)-1L, (long)((PipelineDriverFactory)context.getPipelineDriverFactories().get(1)).getDependencyPipelineIndex());
        Assert.assertEquals((long)2L, (long)context.getExchangeSumNum());
    }

    @Test
    public void testConsumeAllChildrenPipelineBuilderWithExchange() throws IllegalPathException {
        int i;
        TypeProvider typeProvider = new TypeProvider();
        FullOuterTimeJoinNode fullOuterTimeJoinNode = this.initFullOuterTimeJoinNodeWithExchangeNode(typeProvider, 3, 3);
        LocalExecutionPlanContext context = this.createLocalExecutionPlanContext(typeProvider);
        context.setDegreeOfParallelism(1);
        List childrenOperator = this.operatorTreeGenerator.dealWithConsumeAllChildrenPipelineBreaker((PlanNode)fullOuterTimeJoinNode, context);
        Assert.assertEquals((long)0L, (long)context.getPipelineNumber());
        Assert.assertEquals((long)6L, (long)childrenOperator.size());
        Assert.assertEquals((long)6L, (long)fullOuterTimeJoinNode.getChildren().size());
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals(ExchangeOperator.class, ((Operator)childrenOperator.get(i)).getClass());
            Assert.assertEquals(ExchangeNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getClass());
        }
        for (i = 3; i < 6; ++i) {
            Assert.assertEquals(SeriesScanOperator.class, ((Operator)childrenOperator.get(i)).getClass());
            Assert.assertEquals(SeriesScanNode.class, ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getClass());
            Assert.assertEquals((Object)String.format("root.sg.d%d.s1", i - 3), ((PlanNode)fullOuterTimeJoinNode.getChildren().get(i)).getOutputColumnNames().get(0));
        }
        Assert.assertEquals((long)3L, (long)context.getExchangeSumNum());
    }

    private LocalExecutionPlanContext createLocalExecutionPlanContext(TypeProvider typeProvider) {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
        DataRegion dataRegion = (DataRegion)Mockito.mock(DataRegion.class);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        fragmentInstanceContext.setDataRegion((IDataRegionForQuery)dataRegion);
        return new LocalExecutionPlanContext(typeProvider, fragmentInstanceContext, new DataNodeQueryContext(1));
    }

    private FullOuterTimeJoinNode initFullOuterTimeJoinNode(TypeProvider typeProvider, int childNum) throws IllegalPathException {
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(new PlanNodeId("TimeJoinNode"), Ordering.ASC);
        for (int i = 0; i < childNum; ++i) {
            SeriesScanNode seriesScanNode = new SeriesScanNode(new PlanNodeId(String.format("SeriesScanNode%d", i)), new MeasurementPath(String.format("root.sg.d%d.s1", i), TSDataType.INT32));
            typeProvider.setType(seriesScanNode.getSeriesPath().toString(), TSDataType.INT32);
            fullOuterTimeJoinNode.addChild((PlanNode)seriesScanNode);
        }
        return fullOuterTimeJoinNode;
    }

    private FullOuterTimeJoinNode initFullOuterTimeJoinNodeWithExchangeNode(TypeProvider typeProvider, int exchangeNum, int scanNum) throws IllegalPathException {
        int i;
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(new PlanNodeId("TimeJoinNode"), Ordering.ASC);
        for (i = 0; i < exchangeNum; ++i) {
            ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId(String.format("FullOuterTimeJoinWithExchangeNode%d", i)));
            exchangeNode.setUpstream(new TEndPoint("127.0.0.2", 6667), new FragmentInstanceId(new PlanFragmentId("q", i), "ds"), new PlanNodeId("test"));
            fullOuterTimeJoinNode.addChild((PlanNode)exchangeNode);
        }
        for (i = 0; i < scanNum; ++i) {
            SeriesScanNode seriesScanNode = new SeriesScanNode(new PlanNodeId(String.format("SeriesScanNode%d", i)), new MeasurementPath(String.format("root.sg.d%d.s1", i), TSDataType.INT32));
            typeProvider.setType(seriesScanNode.getSeriesPath().toString(), TSDataType.INT32);
            fullOuterTimeJoinNode.addChild((PlanNode)seriesScanNode);
        }
        return fullOuterTimeJoinNode;
    }

    private LeftOuterTimeJoinNode initLeftOuterTimeJoinNode(TypeProvider typeProvider) throws IllegalPathException {
        LeftOuterTimeJoinNode leftOuterTimeJoinNode = new LeftOuterTimeJoinNode(new PlanNodeId("TimeJoinNode"), Ordering.ASC);
        for (int i = 0; i < 2; ++i) {
            SeriesScanNode seriesScanNode = new SeriesScanNode(new PlanNodeId(String.format("SeriesScanNode%d", i)), new MeasurementPath(String.format("root.sg.d%d.s1", i), TSDataType.INT32));
            typeProvider.setType(seriesScanNode.getSeriesPath().toString(), TSDataType.INT32);
            leftOuterTimeJoinNode.addChild((PlanNode)seriesScanNode);
        }
        return leftOuterTimeJoinNode;
    }

    private DeviceViewNode initDeviceViewNode(TypeProvider typeProvider, int childNum) throws IllegalPathException {
        DeviceViewNode deviceViewNode = new DeviceViewNode(new PlanNodeId("DeviceViewNode"), null, null, null);
        for (int i = 0; i < childNum; ++i) {
            AlignedSeriesScanNode alignedSeriesScanNode = new AlignedSeriesScanNode(new PlanNodeId(String.format("AlignedSeriesScanNode%d", i)), new AlignedPath(String.format("root.sg.d%d", i), "s1"));
            deviceViewNode.addChild((PlanNode)alignedSeriesScanNode);
        }
        return deviceViewNode;
    }

    private TopKNode initTopKNode(TypeProvider typeProvider, int childNum) throws IllegalPathException {
        TopKNode topKNode = new TopKNode(new PlanNodeId("TopKNode"), 10, new OrderByParameter(Arrays.asList(new SortItem("TIME", Ordering.ASC), new SortItem("DEVICE", Ordering.ASC))), Arrays.asList("Time", "Device", "s1"));
        for (int i = 0; i < childNum; ++i) {
            SingleDeviceViewNode singleDeviceViewNode = new SingleDeviceViewNode(new PlanNodeId(String.format("SingleDeviceViewNode%d", i)), Arrays.asList("Time", "Device", "s1"), "root.sg.d" + i, Arrays.asList(0, 1, 2));
            singleDeviceViewNode.setCacheOutputColumnNames(true);
            SeriesScanNode seriesScanNode = new SeriesScanNode(new PlanNodeId(String.format("SeriesScanNode%d", i)), new MeasurementPath(String.format("root.sg.d%d.s1", i), TSDataType.INT32));
            typeProvider.setType(seriesScanNode.getSeriesPath().toString(), TSDataType.INT32);
            singleDeviceViewNode.addChild((PlanNode)seriesScanNode);
            typeProvider.setType("Time", TSDataType.INT64);
            typeProvider.setType("Device", TSDataType.TEXT);
            typeProvider.setType("s1", TSDataType.INT32);
            topKNode.addChild((PlanNode)singleDeviceViewNode);
        }
        return topKNode;
    }
}

