/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.QueryExecutor;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TimePredicate;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TreeModelTimePredicate;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.junit.Assert;
import org.junit.Test;

public class FragmentInstanceSerdeTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final SessionInfo sessionInfo = new SessionInfo(1L, "test", ZoneId.systemDefault());

    @Test
    public void testSerializeAndDeserializeForTree1() throws IllegalPathException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        PlanFragmentId planFragmentId = new PlanFragmentId("test", -1);
        FragmentInstance fragmentInstance = new FragmentInstance(new PlanFragment(planFragmentId, this.constructPlanNodeTree()), planFragmentId.genFragmentInstanceId(), (TimePredicate)new TreeModelTimePredicate((Expression)ExpressionFactory.groupByTime((long)1L, (long)2L, (long)3L, (long)4L)), QueryType.READ, config.getQueryTimeoutThreshold(), sessionInfo);
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), (List)ImmutableList.of((Object)dataNodeLocation));
        fragmentInstance.setExecutorAndHost((ExecutorType)new StorageExecutor(regionReplicaSet));
        ByteBuffer byteBuffer = fragmentInstance.serializeToByteBuffer();
        FragmentInstance deserializeFragmentInstance = FragmentInstance.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertNull((Object)deserializeFragmentInstance.getExecutorType());
        deserializeFragmentInstance.setExecutorType(fragmentInstance.getExecutorType());
        Assert.assertEquals((Object)deserializeFragmentInstance, (Object)fragmentInstance);
        fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(dataNodeLocation));
        byteBuffer = fragmentInstance.serializeToByteBuffer();
        deserializeFragmentInstance = FragmentInstance.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertNull((Object)deserializeFragmentInstance.getExecutorType());
        deserializeFragmentInstance.setExecutorType(fragmentInstance.getExecutorType());
        Assert.assertEquals((Object)deserializeFragmentInstance, (Object)fragmentInstance);
    }

    @Test
    public void testSerializeAndDeserializeWithNullFilter() throws IllegalPathException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        PlanFragmentId planFragmentId = new PlanFragmentId("test2", 1);
        FragmentInstance fragmentInstance = new FragmentInstance(new PlanFragment(planFragmentId, this.constructPlanNodeTree()), planFragmentId.genFragmentInstanceId(), null, QueryType.READ, config.getQueryTimeoutThreshold(), sessionInfo);
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), (List)ImmutableList.of((Object)dataNodeLocation));
        fragmentInstance.setExecutorAndHost((ExecutorType)new StorageExecutor(regionReplicaSet));
        ByteBuffer byteBuffer = fragmentInstance.serializeToByteBuffer();
        FragmentInstance deserializeFragmentInstance = FragmentInstance.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertNull((Object)deserializeFragmentInstance.getExecutorType());
        deserializeFragmentInstance.setExecutorType(fragmentInstance.getExecutorType());
        Assert.assertEquals((Object)deserializeFragmentInstance, (Object)fragmentInstance);
    }

    private PlanNode constructPlanNodeTree() throws IllegalPathException {
        OffsetNode offsetNode = new OffsetNode(new PlanNodeId("OffsetNode"), 100L);
        LimitNode limitNode = new LimitNode(new PlanNodeId("LimitNode"), 100L);
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(new PlanNodeId("TimeJoinNode"), Ordering.DESC);
        SeriesScanNode seriesScanNode1 = new SeriesScanNode(new PlanNodeId("SeriesScanNode1"), new MeasurementPath("root.sg.d1.s2"));
        seriesScanNode1.setScanOrder(Ordering.DESC);
        SeriesScanNode seriesScanNode2 = new SeriesScanNode(new PlanNodeId("SeriesScanNode2"), new MeasurementPath("root.sg.d2.s1"));
        seriesScanNode2.setScanOrder(Ordering.DESC);
        SeriesScanNode seriesScanNode3 = new SeriesScanNode(new PlanNodeId("SeriesScanNode3"), new MeasurementPath("root.sg.d2.s2"));
        seriesScanNode3.setScanOrder(Ordering.DESC);
        fullOuterTimeJoinNode.addChild((PlanNode)seriesScanNode1);
        fullOuterTimeJoinNode.addChild((PlanNode)seriesScanNode2);
        fullOuterTimeJoinNode.addChild((PlanNode)seriesScanNode3);
        limitNode.addChild((PlanNode)fullOuterTimeJoinNode);
        offsetNode.addChild((PlanNode)limitNode);
        return offsetNode;
    }
}

