/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionTest {
    @Test
    public void testIsMappable() {
        try {
            TimeSeriesOperand input = new TimeSeriesOperand(new PartialPath("root.sg.a"));
            FunctionExpression masterRepair = new FunctionExpression("Master_Repair", new LinkedHashMap(), Collections.singletonList(input));
            FunctionExpression abs = new FunctionExpression("abs", new LinkedHashMap(), Collections.singletonList(masterRepair));
            FunctionExpression rawAbs = new FunctionExpression("abs", new LinkedHashMap(), Collections.singletonList(input));
            FunctionExpression masterRepairAbs = new FunctionExpression("Master_Repair", new LinkedHashMap(), Collections.singletonList(rawAbs));
            HashMap<NodeRef, TSDataType> expressionTypes = new HashMap<NodeRef, TSDataType>();
            expressionTypes.put(NodeRef.of((Object)input), TSDataType.INT32);
            expressionTypes.put(NodeRef.of((Object)masterRepair), TSDataType.INT32);
            expressionTypes.put(NodeRef.of((Object)rawAbs), TSDataType.INT32);
            Assert.assertTrue((boolean)input.isMappable(expressionTypes));
            Assert.assertFalse((boolean)masterRepair.isMappable(expressionTypes));
            Assert.assertFalse((boolean)abs.isMappable(expressionTypes));
            Assert.assertFalse((boolean)masterRepairAbs.isMappable(expressionTypes));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

