/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.db.schemaengine.template.TemplateQueryType;
import org.apache.iotdb.isession.template.Template;
import org.apache.iotdb.isession.template.TemplateNode;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSAggregationQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.session.template.MeasurementNode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class StatementGeneratorTest {
    @Test
    public void testRawDataQuery() throws IllegalPathException {
        TSRawDataQueryReq req = new TSRawDataQueryReq(101L, Arrays.asList("root.sg.d1.s1", "root.sg.d1.s2"), 100L, 200L, 102L);
        Statement statement = StatementGenerator.createStatement((TSRawDataQueryReq)req);
        QueryStatement queryStatement = (QueryStatement)statement;
        Assert.assertEquals(Arrays.asList(new PartialPath("root.sg.d1.s2"), new PartialPath("root.sg.d1.s1")), (Object)queryStatement.getPaths());
        Assert.assertEquals((Object)new LogicAndExpression((Expression)new GreaterEqualExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "100")), (Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "200"))), (Object)queryStatement.getWhereCondition().getPredicate());
    }

    @Test
    public void testLastDataQuery() throws IllegalPathException {
        TSLastDataQueryReq req = new TSLastDataQueryReq(101L, Arrays.asList("root.sg.d1.s1", "root.sg.d1.s2"), 200L, 102L);
        Statement statement = StatementGenerator.createStatement((TSLastDataQueryReq)req);
        QueryStatement queryStatement = (QueryStatement)statement;
        Assert.assertEquals(Arrays.asList(new PartialPath("root.sg.d1.s2"), new PartialPath("root.sg.d1.s1")), (Object)queryStatement.getPaths());
        Assert.assertEquals((Object)new GreaterEqualExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "200")), (Object)queryStatement.getWhereCondition().getPredicate());
    }

    @Test
    public void testAggregationQuery() throws IllegalPathException {
        TSAggregationQueryReq req = new TSAggregationQueryReq(101L, 102L, Arrays.asList("root.sg.d1.s1", "root.sg.d1.s2"), Arrays.asList(TAggregationType.AVG, TAggregationType.COUNT));
        Statement statement = StatementGenerator.createStatement((TSAggregationQueryReq)req);
        QueryStatement queryStatement = (QueryStatement)statement;
        Assert.assertEquals(Arrays.asList(new PartialPath("root.sg.d1.s2"), new PartialPath("root.sg.d1.s1")), (Object)queryStatement.getPaths());
        Assert.assertEquals((Object)new ResultColumn((Expression)new FunctionExpression("AVG", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")))), ResultColumn.ColumnType.AGGREGATION), queryStatement.getSelectComponent().getResultColumns().get(0));
        Assert.assertEquals((Object)new ResultColumn((Expression)new FunctionExpression("COUNT", new LinkedHashMap(), Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s2")))), ResultColumn.ColumnType.AGGREGATION), queryStatement.getSelectComponent().getResultColumns().get(1));
    }

    @Test
    public void testInsertRecord() throws QueryProcessException, IllegalPathException {
        TSInsertRecordReq req = new TSInsertRecordReq(101L, "root.sg.d1", Arrays.asList("s1", "s2"), ByteBuffer.wrap(new byte[]{0, 0, 0, 0}), 1000L);
        InsertRowStatement statement = StatementGenerator.createStatement((TSInsertRecordReq)req);
        Assert.assertEquals((long)1000L, (long)statement.getTime());
    }

    @Test
    public void testInsertTablet() throws IllegalPathException {
        TSInsertTabletReq req = new TSInsertTabletReq(101L, "root.sg.d1", Collections.singletonList("s1"), ByteBuffer.wrap(new byte[]{0, 0, 0, 0}), ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}), Collections.singletonList(1), 1);
        InsertTabletStatement statement = StatementGenerator.createStatement((TSInsertTabletReq)req);
        Assert.assertEquals((long)0L, (long)statement.getMinTime());
    }

    @Test
    public void testInsertTablets() throws IllegalPathException {
        TSInsertTabletsReq req = new TSInsertTabletsReq(101L, Collections.singletonList("root.sg.d1"), Collections.singletonList(Collections.singletonList("s1")), Collections.singletonList(ByteBuffer.wrap(new byte[]{0, 0, 0, 0})), Collections.singletonList(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0, 0, 0, 0})), Collections.singletonList(Collections.singletonList(1)), Collections.singletonList(1));
        InsertMultiTabletsStatement statement = StatementGenerator.createStatement((TSInsertTabletsReq)req);
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.sg.d1.s1")), (Object)statement.getPaths());
    }

    @Test
    public void testInsertRecords() throws QueryProcessException, IllegalPathException {
        TSInsertRecordsReq req = new TSInsertRecordsReq(101L, Collections.singletonList("root.sg.d1"), Collections.singletonList(Collections.singletonList("s1")), Collections.singletonList(ByteBuffer.wrap(new byte[]{0, 0, 0, 0})), Collections.singletonList(1L));
        InsertRowsStatement statement = StatementGenerator.createStatement((TSInsertRecordsReq)req);
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.sg.d1.s1")), (Object)statement.getPaths());
    }

    @Test
    public void testInsertStringRecords() throws IllegalPathException {
        TSInsertStringRecordsReq req = new TSInsertStringRecordsReq(101L, Collections.singletonList("root.sg.d1"), Collections.singletonList(Collections.singletonList("s1")), Collections.singletonList(Collections.singletonList("1")), Collections.singletonList(1L));
        InsertRowsStatement statement = StatementGenerator.createStatement((TSInsertStringRecordsReq)req);
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.sg.d1.s1")), (Object)statement.getPaths());
    }

    @Test
    public void testInsertRecordsOfOneDevice() throws IllegalPathException, QueryProcessException {
        TSInsertRecordsOfOneDeviceReq req = new TSInsertRecordsOfOneDeviceReq(101L, "root.sg.d1", Collections.singletonList(Collections.singletonList("s1")), Collections.singletonList(ByteBuffer.wrap(new byte[]{0, 0, 0, 0})), Collections.singletonList(1L));
        InsertRowsOfOneDeviceStatement statement = StatementGenerator.createStatement((TSInsertRecordsOfOneDeviceReq)req);
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.sg.d1.s1")), (Object)statement.getPaths());
    }

    @Test
    public void testInsertStringRecordsOfOneDevice() throws IllegalPathException {
        TSInsertStringRecordsOfOneDeviceReq req = new TSInsertStringRecordsOfOneDeviceReq(101L, "root.sg.d1", Collections.singletonList(Collections.singletonList("s1")), Collections.singletonList(Collections.singletonList("1")), Collections.singletonList(1L));
        InsertRowsOfOneDeviceStatement statement = StatementGenerator.createStatement((TSInsertStringRecordsOfOneDeviceReq)req);
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.sg.d1.s1")), (Object)statement.getPaths());
    }

    @Test
    public void testCreateDatabaseSchema() throws IllegalPathException {
        DatabaseSchemaStatement statement = StatementGenerator.createStatement((String)"root.db");
        Assert.assertEquals((Object)new PartialPath("root.db"), (Object)statement.getDatabasePath());
    }

    @Test
    public void testCreateTimeSeries() throws IllegalPathException {
        TSCreateTimeseriesReq req = new TSCreateTimeseriesReq(1L, "root.db.d1.s1", (int)TSDataType.INT64.getType(), TSEncoding.PLAIN.ordinal(), CompressionType.SNAPPY.ordinal());
        CreateTimeSeriesStatement statement = StatementGenerator.createStatement((TSCreateTimeseriesReq)req);
        Assert.assertEquals((Object)new PartialPath("root.db.d1.s1"), (Object)statement.getPath());
        Assert.assertEquals((Object)TSDataType.INT64, (Object)statement.getDataType());
        Assert.assertEquals((Object)TSEncoding.PLAIN, (Object)statement.getEncoding());
        Assert.assertEquals((Object)CompressionType.SNAPPY, (Object)statement.getCompressor());
    }

    @Test
    public void testCreateAlignedTimeSeries() throws IllegalPathException {
        TSCreateAlignedTimeseriesReq req = new TSCreateAlignedTimeseriesReq(1L, "root.db.d1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.INT64.ordinal(), TSDataType.INT32.ordinal()), Arrays.asList(TSEncoding.PLAIN.ordinal(), TSEncoding.RLE.ordinal()), Arrays.asList(CompressionType.SNAPPY.ordinal(), CompressionType.SNAPPY.ordinal()));
        CreateAlignedTimeSeriesStatement statement = StatementGenerator.createStatement((TSCreateAlignedTimeseriesReq)req);
        Assert.assertEquals(Arrays.asList(new PartialPath("root.db.d1.s1"), new PartialPath("root.db.d1.s2")), (Object)statement.getPaths());
        Assert.assertEquals(Arrays.asList(TSDataType.INT64, TSDataType.INT32), (Object)statement.getDataTypes());
        Assert.assertEquals(Arrays.asList(TSEncoding.PLAIN, TSEncoding.RLE), (Object)statement.getEncodings());
        Assert.assertEquals(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY), (Object)statement.getCompressors());
    }

    @Test
    public void testCreateMultiTimeSeries() throws IllegalPathException {
        TSCreateMultiTimeseriesReq req = new TSCreateMultiTimeseriesReq(1L, Arrays.asList("root.db.d1.s1", "root.db.d1.s2"), Arrays.asList(TSDataType.INT64.ordinal(), TSDataType.INT32.ordinal()), Arrays.asList(TSEncoding.PLAIN.ordinal(), TSEncoding.RLE.ordinal()), Arrays.asList(CompressionType.SNAPPY.ordinal(), CompressionType.SNAPPY.ordinal()));
        CreateMultiTimeSeriesStatement statement = StatementGenerator.createStatement((TSCreateMultiTimeseriesReq)req);
        Assert.assertEquals(Arrays.asList(new PartialPath("root.db.d1.s1"), new PartialPath("root.db.d1.s2")), (Object)statement.getPaths());
        Assert.assertEquals(Arrays.asList(TSDataType.INT64, TSDataType.INT32), (Object)statement.getDataTypes());
        Assert.assertEquals(Arrays.asList(TSEncoding.PLAIN, TSEncoding.RLE), (Object)statement.getEncodings());
        Assert.assertEquals(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY), (Object)statement.getCompressors());
    }

    @Test
    public void testDeleteDatabase() throws IllegalPathException {
        DeleteDatabaseStatement statement = StatementGenerator.createStatement(Collections.singletonList("root.db"));
        Assert.assertEquals(Collections.singletonList("root.db"), (Object)statement.getPrefixPath());
    }

    @Test
    public void testDeleteData() throws IllegalPathException {
        TSDeleteDataReq req = new TSDeleteDataReq(1L, Arrays.asList("root.sg.d1.s1", "root.sg.d1.s2"), 1L, 100L);
        DeleteDataStatement statement = StatementGenerator.createStatement((TSDeleteDataReq)req);
        Assert.assertEquals(Arrays.asList(new PartialPath("root.sg.d1.s1"), new PartialPath("root.sg.d1.s2")), (Object)statement.getPaths());
        Assert.assertEquals((long)1L, (long)statement.getDeleteStartTime());
        Assert.assertEquals((long)100L, (long)statement.getDeleteEndTime());
    }

    @Test
    public void testCreateSchemaTemplate() throws MetadataException, IOException, StatementExecutionException {
        Template template = this.getTemplate();
        TSCreateSchemaTemplateReq req = new TSCreateSchemaTemplateReq();
        req.setName(template.getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        template.serialize((OutputStream)baos);
        req.setSerializedTemplate(baos.toByteArray());
        baos.close();
        CreateSchemaTemplateStatement statement = StatementGenerator.createStatement((TSCreateSchemaTemplateReq)req);
        Assert.assertEquals((Object)"test-template", (Object)statement.getName());
        Assert.assertEquals(Arrays.asList("y", "x"), (Object)statement.getMeasurements());
    }

    @Test
    public void testQueryTemplate() {
        TSQueryTemplateReq req = new TSQueryTemplateReq(1L, "test", TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
        ShowNodesInSchemaTemplateStatement statement = (ShowNodesInSchemaTemplateStatement)StatementGenerator.createStatement((TSQueryTemplateReq)req);
        Assert.assertEquals((Object)"test", (Object)statement.getTemplateName());
    }

    @Test
    public void testUnsetSchemaTemplate() throws IllegalPathException {
        TSUnsetSchemaTemplateReq req = new TSUnsetSchemaTemplateReq(1L, "root.sg.d1", "test");
        UnsetSchemaTemplateStatement statement = StatementGenerator.createStatement((TSUnsetSchemaTemplateReq)req);
        Assert.assertEquals((Object)"test", (Object)statement.getTemplateName());
    }

    @Test
    public void testDropSchemaTemplate() {
        TSDropSchemaTemplateReq req = new TSDropSchemaTemplateReq(1L, "test-template");
        DropSchemaTemplateStatement statement = StatementGenerator.createStatement((TSDropSchemaTemplateReq)req);
        Assert.assertEquals((Object)"test-template", (Object)statement.getTemplateName());
    }

    @Test
    public void testBatchActivateTemplate() throws IllegalPathException {
        BatchActivateTemplateStatement statement = StatementGenerator.createBatchActivateTemplateStatement(Collections.singletonList("root.sg.d1"));
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.sg.d1")), (Object)statement.getDevicePathList());
    }

    @Test
    public void testDeleteTimeSeries() throws IllegalPathException {
        DeleteTimeSeriesStatement statement = StatementGenerator.createDeleteTimeSeriesStatement(Collections.singletonList("root.sg.d1"));
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.sg.d1")), (Object)statement.getPaths());
    }

    private Template getTemplate() throws StatementExecutionException {
        Template sessionTemplate = new Template("test-template", false);
        MeasurementNode mNodeX = new MeasurementNode("x", TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY);
        MeasurementNode mNodeY = new MeasurementNode("y", TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY);
        sessionTemplate.addToTemplate((TemplateNode)mNodeX);
        sessionTemplate.addToTemplate((TemplateNode)mNodeY);
        return sessionTemplate;
    }

    @Test
    public void rawDataQueryTest() {
        String sql = "SELECT s1, s2 FROM root.sg1.d1 WHERE time > 1 and s3 > 2 LIMIT 10 OFFSET 11";
        this.checkQueryStatement(sql, Arrays.asList("s1", "s2"), Collections.singletonList("root.sg1.d1"), "Time > 1 & s3 > 2", 10, 11);
    }

    @Test
    public void groupByTagWithDuplicatedKeysTest() {
        try {
            this.checkQueryStatement("SELECT avg(*) FROM root.sg.** GROUP BY TAGS(k1, k2, k1)", Collections.emptyList(), Collections.emptyList(), "", 10, 10);
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)"duplicated key in GROUP BY TAGS: k1", (Object)e.getMessage());
        }
    }

    private AuthorStatement createAuthDclStmt(String sql) {
        Statement stmt = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        AuthorStatement roleDcl = (AuthorStatement)stmt;
        return roleDcl;
    }

    @Test
    public void testDCLUserOperation() {
        AuthorStatement userDcl = this.createAuthDclStmt("create user `user1` 'password1';");
        Assert.assertEquals((Object)"user1", (Object)userDcl.getUserName());
        Assert.assertEquals(Collections.emptyList(), (Object)userDcl.getPaths());
        Assert.assertEquals((Object)"password1", (Object)userDcl.getPassWord());
        Assert.assertEquals((Object)StatementType.CREATE_USER, (Object)userDcl.getType());
        userDcl = this.createAuthDclStmt("drop user `user1`;");
        Assert.assertEquals((Object)"user1", (Object)userDcl.getUserName());
        Assert.assertEquals(Collections.emptyList(), (Object)userDcl.getPaths());
        Assert.assertEquals((Object)StatementType.DELETE_USER, (Object)userDcl.getType());
        userDcl = this.createAuthDclStmt("alter user `user1` set password 'password2';");
        Assert.assertEquals((Object)"user1", (Object)userDcl.getUserName());
        Assert.assertEquals((Object)"password2", (Object)userDcl.getNewPassword());
        Assert.assertEquals((Object)StatementType.MODIFY_PASSWORD, (Object)userDcl.getType());
    }

    @Test
    public void testDCLROLEOperation() {
        AuthorStatement roleDcl = this.createAuthDclStmt("create role role1;");
        Assert.assertEquals((Object)"role1", (Object)roleDcl.getRoleName());
        Assert.assertEquals((Object)StatementType.CREATE_ROLE, (Object)roleDcl.getType());
        roleDcl = this.createAuthDclStmt("drop role role1;");
        Assert.assertEquals((Object)StatementType.DELETE_ROLE, (Object)roleDcl.getType());
        Assert.assertEquals((Object)"role1", (Object)roleDcl.getRoleName());
        roleDcl = this.createAuthDclStmt("grant role `role1` to `user1`;");
        Assert.assertEquals((Object)StatementType.GRANT_USER_ROLE, (Object)roleDcl.getType());
        Assert.assertEquals((Object)"role1", (Object)roleDcl.getRoleName());
        Assert.assertEquals((Object)"user1", (Object)roleDcl.getUserName());
        roleDcl = this.createAuthDclStmt("revoke role `role1` from `user1`;");
        Assert.assertEquals((Object)StatementType.REVOKE_USER_ROLE, (Object)roleDcl.getType());
        Assert.assertEquals((Object)"role1", (Object)roleDcl.getRoleName());
        Assert.assertEquals((Object)"user1", (Object)roleDcl.getUserName());
    }

    @Test
    public void testNormalGrantRevoke() {
        grantRevokeCheck testGrant = (privilege, name, isuser, path, grantOpt) -> {
            String sql = "grant %s on %s to %s %s %s ;";
            sql = String.format(sql, privilege, path, isuser ? "USER" : "ROLE", name, grantOpt ? "with grant option" : "");
            AuthorStatement aclStmt = this.createAuthDclStmt(sql);
            Assert.assertEquals((Object)(isuser ? StatementType.GRANT_USER_PRIVILEGE : StatementType.GRANT_ROLE_PRIVILEGE), (Object)aclStmt.getType());
            Assert.assertEquals((Object)path, (Object)((PartialPath)aclStmt.getPaths().get(0)).toString());
            Assert.assertEquals((Object)name, (Object)(isuser ? aclStmt.getUserName() : aclStmt.getRoleName()));
            Assert.assertEquals((Object)grantOpt, (Object)aclStmt.getGrantOpt());
            Assert.assertEquals((Object)privilege, (Object)aclStmt.getPrivilegeList()[0]);
        };
        String name2 = "test1";
        String path2 = "root.**";
        String pathErr = "root.t1.**";
        String pathsErr = "root.**, root.t1.**";
        for (PrivilegeType privilege2 : PrivilegeType.values()) {
            testGrant.checkParser(privilege2.toString(), name2, true, path2, true);
            testGrant.checkParser(privilege2.toString(), name2, true, path2, false);
            testGrant.checkParser(privilege2.toString(), name2, false, path2, true);
            testGrant.checkParser(privilege2.toString(), name2, false, path2, false);
            if (privilege2.isPathRelevant()) continue;
            Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt(String.format("GRANT %s on %s to USER `user1`;", privilege2, pathErr)));
            Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt(String.format("GRANT %s on %s to USER `user1`;", privilege2, pathsErr)));
        }
        grantRevokeCheck testRevoke = (privilege, username, isuser, targtePath, grantOpt) -> {
            String sql = "revoke %s on %s from %s %s";
            sql = String.format(sql, privilege, targtePath, isuser ? "USER" : "ROLE", username);
            AuthorStatement aclStmt = this.createAuthDclStmt(sql);
            Assert.assertEquals((Object)(isuser ? StatementType.REVOKE_USER_PRIVILEGE : StatementType.REVOKE_ROLE_PRIVILEGE), (Object)aclStmt.getType());
            Assert.assertEquals((Object)path2, (Object)((PartialPath)aclStmt.getPaths().get(0)).toString());
            Assert.assertEquals((Object)username, (Object)(isuser ? aclStmt.getUserName() : aclStmt.getRoleName()));
            Assert.assertFalse((boolean)aclStmt.getGrantOpt());
            Assert.assertEquals((Object)privilege, (Object)aclStmt.getPrivilegeList()[0]);
        };
        for (PrivilegeType type : PrivilegeType.values()) {
            testRevoke.checkParser(type.toString(), name2, true, path2, false);
            testRevoke.checkParser(type.toString(), name2, false, path2, false);
            if (type.isPathRelevant()) continue;
            Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt(String.format("revoke %s on %s FROM USER `user1`;", type, pathErr)));
            Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt(String.format("revoke %s on %s FROM USER `user1`;", type, pathsErr)));
        }
    }

    @Test
    public void testComplexGrantRevoke() {
        HashSet<String> allPriv = new HashSet<String>();
        for (PrivilegeType type : PrivilegeType.values()) {
            allPriv.add(type.toString());
        }
        for (PrivilegeType type : PrivilegeType.values()) {
            AuthorStatement stmt = this.createAuthDclStmt(String.format("GRANT ALL,%s on root.** to USER `user1` with grant option", type));
            Assert.assertEquals(allPriv, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
            Assert.assertTrue((boolean)stmt.getGrantOpt());
            Assert.assertEquals((Object)StatementType.GRANT_USER_PRIVILEGE, (Object)stmt.getType());
            stmt = this.createAuthDclStmt(String.format("REVOKE ALL,%s on root.** from USER `user1`;", type));
            Assert.assertEquals(allPriv, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
            Assert.assertEquals((Object)StatementType.REVOKE_USER_PRIVILEGE, (Object)stmt.getType());
            stmt = this.createAuthDclStmt(String.format("GRANT ALL,%s on root.** to ROLE `role1`;", type));
            Assert.assertEquals(allPriv, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
            Assert.assertFalse((boolean)stmt.getGrantOpt());
            Assert.assertEquals((Object)StatementType.GRANT_ROLE_PRIVILEGE, (Object)stmt.getType());
        }
        AuthorStatement stmt = this.createAuthDclStmt("GRANT ALL ON root.** to user `user1` with grant option;");
        Assert.assertEquals(allPriv, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        Assert.assertTrue((boolean)stmt.getGrantOpt());
        Assert.assertEquals(allPriv, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all on root.t1.** to USER `user1` with grant option;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all on root.t1.** to ROLE `user1` with grant option;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all,READ_DATA on root.t1.** to USER `user1` with grant option"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all,READ_DATA on root.t1.** to ROLE `user1` with grant option"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all on root.t1.** to USER `user1`;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all on root.t1.** to ROLE `user1`;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all,READ_DATA on root.t1.** to USER `user1`;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all,READ_DATA on root.t1.** to ROLE `user1`;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("revoke all on root.t1.** from USER `user1`;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("revoke all on root.t1.** from ROLE `user1`;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("revoke all,READ_DATA on root.t1.** from USER `user1`;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("revoke all,READ_DATA on root.t1.** from ROLE `user1`;"));
        try {
            this.createAuthDclStmt("grant all on root.t1.**, root.** to USER `user1` with grant option;");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)"[ALL] can only be set on path: root.**", (Object)e.getMessage());
        }
        try {
            this.createAuthDclStmt("grant MANAGE_ROLE on root.t1.** to USER `user1` with grant option;");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)"[MANAGE_ROLE] can only be set on path: root.**", (Object)e.getMessage());
        }
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant all on root.t1.**, root.** to USER `user1` with grant option;"));
        Assert.assertThrows(SemanticException.class, () -> this.createAuthDclStmt("grant MANAGE_ROLE on root.t1.**, root.** to USER `user1` with grant option;"));
        stmt = this.createAuthDclStmt("GRANT READ ON root.** TO USER `user1`;");
        HashSet<String> readSet = new HashSet<String>();
        readSet.add("READ_DATA");
        readSet.add("READ_SCHEMA");
        Assert.assertEquals(readSet, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        stmt = this.createAuthDclStmt("GRANT READ,READ_DATA ON root.** TO USER `user1`;");
        Assert.assertEquals(readSet, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        stmt = this.createAuthDclStmt("GRANT READ,READ_DATA ON root.**,root.t1.t2 TO USER `user1`;");
        Assert.assertEquals(readSet, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        Assert.assertEquals((long)2L, (long)stmt.getPaths().size());
        stmt = this.createAuthDclStmt("GRANT WRITE ON root.** TO USER `user1`;");
        HashSet<String> writeSet = new HashSet<String>();
        writeSet.add("WRITE_DATA");
        writeSet.add("WRITE_SCHEMA");
        Assert.assertEquals(writeSet, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        stmt = this.createAuthDclStmt("GRANT WRITE,WRITE_DATA ON root.** TO USER `user1`;");
        Assert.assertEquals(writeSet, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        stmt = this.createAuthDclStmt("GRANT WRITE,WRITE ON root.**,root.t1.t2 TO USER `user1`;");
        Assert.assertEquals(writeSet, new HashSet<String>(Arrays.asList(stmt.getPrivilegeList())));
        Assert.assertEquals((long)2L, (long)stmt.getPaths().size());
    }

    @Test
    public void testListThings() {
        AuthorStatement stmt = this.createAuthDclStmt("LIST USER;");
        Assert.assertEquals((Object)StatementType.LIST_USER, (Object)stmt.getType());
        Assert.assertEquals(null, (Object)stmt.getRoleName());
        stmt = this.createAuthDclStmt("LIST USER OF ROLE `role1`;");
        Assert.assertEquals((Object)StatementType.LIST_USER, (Object)stmt.getType());
        Assert.assertEquals((Object)"role1", (Object)stmt.getRoleName());
        stmt = this.createAuthDclStmt("LIST ROLE;");
        Assert.assertEquals((Object)StatementType.LIST_ROLE, (Object)stmt.getType());
        Assert.assertEquals(null, (Object)stmt.getUserName());
        stmt = this.createAuthDclStmt("LIST ROLE OF USER `user1`;");
        Assert.assertEquals((Object)StatementType.LIST_ROLE, (Object)stmt.getType());
        Assert.assertEquals((Object)"user1", (Object)stmt.getUserName());
        stmt = this.createAuthDclStmt("LIST PRIVILEGES OF USER `user1`;");
        Assert.assertEquals((Object)StatementType.LIST_USER_PRIVILEGE, (Object)stmt.getType());
        Assert.assertEquals((Object)"user1", (Object)stmt.getUserName());
        stmt = this.createAuthDclStmt("LIST PRIVILEGES OF ROLE `role1`;");
        Assert.assertEquals((Object)StatementType.LIST_ROLE_PRIVILEGE, (Object)stmt.getType());
        Assert.assertEquals((Object)"role1", (Object)stmt.getRoleName());
    }

    private CreateLogicalViewStatement createViewStmt(String sql) {
        Statement stmt = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        CreateLogicalViewStatement viewStmt = (CreateLogicalViewStatement)stmt;
        return viewStmt;
    }

    @Test
    public void testCreateView() throws IllegalPathException {
        CreateLogicalViewStatement stmt = this.createViewStmt("create view root.sg.view_dd as select s1 from root.sg.d1;");
        ArrayList<PartialPath> path = new ArrayList<PartialPath>();
        path.add(new PartialPath("root.sg.d1"));
        Assert.assertEquals(null, (Object)stmt.getSourcePaths().fullPathList);
        Assert.assertEquals(path, (Object)stmt.getQueryStatement().getFromComponent().getPrefixPaths());
        stmt = this.createViewStmt("create view root.sg as root.sg.d2;");
        ArrayList<PartialPath> path2 = new ArrayList<PartialPath>();
        path2.add(new PartialPath("root.sg.d2"));
        Assert.assertEquals(path2, (Object)stmt.getSourcePaths().fullPathList);
        Assert.assertEquals(null, (Object)stmt.getQueryStatement());
    }

    private void checkQueryStatement(String sql, List<String> selectExprList, List<String> fromPrefixPaths, String wherePredicateString, int rowLimit, int rowOffset) {
        QueryStatement statement = (QueryStatement)StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        int cnt = 0;
        for (ResultColumn resultColumn : statement.getSelectComponent().getResultColumns()) {
            String selectExpr = resultColumn.getExpression().toString();
            Assert.assertEquals((Object)selectExprList.get(cnt++), (Object)selectExpr);
        }
        Assert.assertEquals((long)selectExprList.size(), (long)statement.getSelectComponent().getResultColumns().size());
        cnt = 0;
        for (PartialPath path : statement.getFromComponent().getPrefixPaths()) {
            Assert.assertEquals((Object)fromPrefixPaths.get(cnt++), (Object)path.toString());
        }
        Assert.assertEquals((long)fromPrefixPaths.size(), (long)statement.getFromComponent().getPrefixPaths().size());
        Assert.assertEquals((Object)wherePredicateString, (Object)statement.getWhereCondition().getPredicate().getExpressionString());
        Assert.assertEquals((long)rowLimit, (long)statement.getRowLimit());
        Assert.assertEquals((long)rowOffset, (long)statement.getRowOffset());
    }

    @FunctionalInterface
    static interface grantRevokeCheck {
        public void checkParser(String var1, String var2, boolean var3, String var4, boolean var5);
    }
}

