/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.optimization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.optimization.OptimizationTestUtil;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.optimization.PredicatePushDown;
import org.apache.iotdb.db.queryengine.plan.optimization.TestPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.junit.Test;

public class PredicatePushDownTest {
    @Test
    public void testPushDownAlignByTime() {
        this.checkPushDown("select s1, s2 from root.sg.d1 where time > 100 and s1 > 10", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("3", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot(), new TestPlanBuilder().leftOuterTimeJoin("4", Ordering.ASC, new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10"))).getRoot(), new TestPlanBuilder().scan("1", OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")).getRoot()).getRoot());
        this.checkPushDown("select s1 from root.sg.d1 where time > 100 and s2 > 10", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("3", Collections.singletonList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot(), new TestPlanBuilder().leftOuterTimeJoin("4", Ordering.ASC, new TestPlanBuilder().scan("1", OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10"))).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).getRoot()).project("5", Collections.singletonList("root.sg.d1.s1")).getRoot());
        this.checkPushDown("select sin(s1) from root.sg.d1 where time > 100 and s2 > 10", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("3", Collections.singletonList(ExpressionFactory.sin((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot(), new TestPlanBuilder().leftOuterTimeJoin("4", Ordering.ASC, new TestPlanBuilder().scan("1", OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10"))).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).getRoot()).transform("5", Collections.singletonList(ExpressionFactory.sin((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")))), false).getRoot());
        this.checkPushDown("select sin(s1) from root.sg.d1 where time > 100 and s2 > 10 and s1 + s2 > 20", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("3", Collections.singletonList(ExpressionFactory.sin((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")))), (Expression)ExpressionFactory.and((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10")), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.add((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))), (Expression)ExpressionFactory.intValue((String)"20"))), false).getRoot(), new TestPlanBuilder().leftOuterTimeJoin("4", Ordering.ASC, new TestPlanBuilder().scan("1", OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10"))).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).getRoot()).filter("5", Collections.singletonList(ExpressionFactory.sin((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.add((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))), (Expression)ExpressionFactory.intValue((String)"20")), false).getRoot());
        this.checkPushDown("select s1, s2 from root.sg.d1 where time > 100 and s1 > 10 and s2 > 10", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("3", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))), (Expression)ExpressionFactory.and((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10"))), false).getRoot(), new TestPlanBuilder().innerTimeJoin("4", Ordering.ASC, Arrays.asList("0", "1"), Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), Arrays.asList(ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")), ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10")))).getRoot());
        this.checkPushDown("select s1, s2 from root.sg.d2.a where time > 100 and s1 > 10", new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a")).filter("1", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot(), new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), (Expression)ExpressionFactory.intValue((String)"10"))).getRoot());
        this.checkPushDown("select s1 from root.sg.d2.a where time > 100 and s2 > 10", new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a")).filter("1", Collections.singletonList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot(), new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2")), (Expression)ExpressionFactory.intValue((String)"10"))).project("2", Collections.singletonList("root.sg.d2.a.s1")).getRoot());
        this.checkPushDown("select s1, s2 from root.sg.d2.a where time > 100 and (s1 > 10 or s2 > 10)", new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a")).filter("1", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2"))), (Expression)ExpressionFactory.or((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), (Expression)ExpressionFactory.intValue((String)"10")), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2")), (Expression)ExpressionFactory.intValue((String)"10"))), false).getRoot(), new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a"), (Expression)ExpressionFactory.or((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), (Expression)ExpressionFactory.intValue((String)"10")), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2")), (Expression)ExpressionFactory.intValue((String)"10")))).getRoot());
        this.checkPushDown("select s1, s2 from root.sg.* where time > 100 and s1 > 10", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d2.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d2.s2"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("5", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s2")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))), (Expression)ExpressionFactory.and((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")), (Expression)ExpressionFactory.intValue((String)"10"))), false).getRoot(), new TestPlanBuilder().leftOuterTimeJoin("8", Ordering.ASC, new TestPlanBuilder().innerTimeJoin("6", Ordering.ASC, Arrays.asList("0", "1"), Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d2.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), Arrays.asList(ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")), (Expression)ExpressionFactory.intValue((String)"10")), ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")))).getRoot(), new TestPlanBuilder().fullOuterTimeJoin("7", Ordering.ASC, Arrays.asList("2", "3"), Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d2.s2"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).getRoot()).getRoot());
    }

    @Test
    public void testCannotPushDownAlignByTime() {
        this.checkCannotPushDown("select s1, s2 from root.sg.d1 where time > 100 and (s1 > 10 or s2 > 10)", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("3", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))), (Expression)ExpressionFactory.or((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")), (Expression)ExpressionFactory.intValue((String)"10"))), false).getRoot());
        this.checkCannotPushDown("select a.s1, a.s2 from root.sg.d2 where time > 100 and (a.s1 > 10 or s2 > 10)", new TestPlanBuilder().fullOuterTimeJoin("2", Ordering.ASC, Arrays.asList("0", "1"), Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d2.s2"), OptimizationTestUtil.schemaMap.get("root.sg.d2.a"))).filter("3", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2"))), (Expression)ExpressionFactory.or((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), (Expression)ExpressionFactory.intValue((String)"10")), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s2")), (Expression)ExpressionFactory.intValue((String)"10"))), false).getRoot());
    }

    @Test
    public void testPushDownAlignByDevice() {
        List<String> outputColumnNames = Arrays.asList("Device", "s1", "s2");
        List<String> devices = Arrays.asList("root.sg.d1", "root.sg.d2", "root.sg.d2.a");
        HashMap<String, List<Integer>> deviceToMeasurementIndexesMap = new HashMap<String, List<Integer>>();
        deviceToMeasurementIndexesMap.put("root.sg.d1", Arrays.asList(1, 2));
        deviceToMeasurementIndexesMap.put("root.sg.d2", Arrays.asList(1, 2));
        deviceToMeasurementIndexesMap.put("root.sg.d2.a", Arrays.asList(1, 2));
        this.checkPushDown("select s1, s2 from root.sg.** where time > 100 and s1 > 10 align by device", new TestPlanBuilder().deviceView("10", outputColumnNames, devices, deviceToMeasurementIndexesMap, Arrays.asList(new TestPlanBuilder().fullOuterTimeJoin("2", Ordering.ASC, Arrays.asList("0", "1"), Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).filter("3", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot(), new TestPlanBuilder().fullOuterTimeJoin("6", Ordering.ASC, Arrays.asList("4", "5"), Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d2.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d2.s2"))).filter("7", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s2"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot(), new TestPlanBuilder().scanAligned("8", OptimizationTestUtil.schemaMap.get("root.sg.d2.a")).filter("9", Arrays.asList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s2"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), (Expression)ExpressionFactory.intValue((String)"10")), false).getRoot())).getRoot(), new TestPlanBuilder().deviceView("10", outputColumnNames, devices, deviceToMeasurementIndexesMap, Arrays.asList(new TestPlanBuilder().leftOuterTimeJoin("11", Ordering.ASC, new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10"))).getRoot(), new TestPlanBuilder().scan("1", OptimizationTestUtil.schemaMap.get("root.sg.d1.s2")).getRoot()).project("12", Arrays.asList("root.sg.d1.s1", "root.sg.d1.s2")).getRoot(), new TestPlanBuilder().leftOuterTimeJoin("13", Ordering.ASC, new TestPlanBuilder().scan("4", OptimizationTestUtil.schemaMap.get("root.sg.d2.s1"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")), (Expression)ExpressionFactory.intValue((String)"10"))).getRoot(), new TestPlanBuilder().scan("5", OptimizationTestUtil.schemaMap.get("root.sg.d2.s2")).getRoot()).project("14", Arrays.asList("root.sg.d2.s1", "root.sg.d2.s2")).getRoot(), new TestPlanBuilder().scanAligned("8", OptimizationTestUtil.schemaMap.get("root.sg.d2.a"), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d2.a.s1")), (Expression)ExpressionFactory.intValue((String)"10"))).project("15", Arrays.asList("root.sg.d2.a.s1", "root.sg.d2.a.s2")).getRoot())).getRoot());
    }

    private void checkPushDown(String sql, PlanNode rawPlan, PlanNode optPlan) {
        OptimizationTestUtil.checkPushDown((PlanOptimizer)new PredicatePushDown(), sql, rawPlan, optPlan);
    }

    private void checkCannotPushDown(String sql, PlanNode rawPlan) {
        OptimizationTestUtil.checkCannotPushDown((PlanOptimizer)new PredicatePushDown(), sql, rawPlan);
    }
}

