/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.optimization;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;

public class OptimizationTestUtil {
    public static final Map<String, PartialPath> schemaMap = new HashMap<String, PartialPath>();

    private OptimizationTestUtil() {
    }

    public static void checkPushDown(PlanOptimizer optimizer, String sql, PlanNode rawPlan, PlanNode optPlan) {
        Statement statement = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        MPPQueryContext context = new MPPQueryContext(new QueryId("test_query"));
        Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
        Analysis analysis = analyzer.analyze(statement);
        PlanNode actualPlan = (PlanNode)new LogicalPlanVisitor(analysis).process((StatementNode)analysis.getStatement(), (Object)context);
        Assert.assertEquals((Object)rawPlan, (Object)actualPlan);
        PlanNode actualOptPlan = optimizer.optimize(actualPlan, analysis, context);
        Assert.assertEquals((Object)optPlan, (Object)actualOptPlan);
    }

    public static void checkCannotPushDown(PlanOptimizer optimizer, String sql, PlanNode rawPlan) {
        Statement statement = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        MPPQueryContext context = new MPPQueryContext(new QueryId("test_query"));
        Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
        Analysis analysis = analyzer.analyze(statement);
        PlanNode actualPlan = (PlanNode)new LogicalPlanVisitor(analysis).process((StatementNode)analysis.getStatement(), (Object)context);
        Assert.assertEquals((Object)rawPlan, (Object)actualPlan);
        PlanNode actualOptPlan = optimizer.optimize(actualPlan, analysis, context);
        Assert.assertEquals((Object)actualPlan, (Object)actualOptPlan);
    }

    static {
        try {
            schemaMap.put("root.sg.d1.s1", (PartialPath)new MeasurementPath("root.sg.d1.s1", TSDataType.INT32));
            schemaMap.put("root.sg.d1.s2", (PartialPath)new MeasurementPath("root.sg.d1.s2", TSDataType.DOUBLE));
            schemaMap.put("root.sg.d2.s1", (PartialPath)new MeasurementPath("root.sg.d2.s1", TSDataType.INT32));
            schemaMap.put("root.sg.d2.s2", (PartialPath)new MeasurementPath("root.sg.d2.s2", TSDataType.DOUBLE));
            MeasurementPath aS1 = new MeasurementPath("root.sg.d2.a.s1", TSDataType.INT32);
            aS1.setUnderAlignedEntity(Boolean.valueOf(true));
            MeasurementPath aS2 = new MeasurementPath("root.sg.d2.a.s2", TSDataType.DOUBLE);
            aS2.setUnderAlignedEntity(Boolean.valueOf(true));
            schemaMap.put("root.sg.d2.a.s1", (PartialPath)aS1);
            schemaMap.put("root.sg.d2.a.s2", (PartialPath)aS2);
            AlignedPath alignedPath = new AlignedPath("root.sg.d2.a", Arrays.asList("s1", "s2"), Arrays.asList(aS1.getMeasurementSchema(), aS2.getMeasurementSchema()));
            AlignedPath descOrderAlignedPath = new AlignedPath("root.sg.d2.a", Arrays.asList("s2", "s1"), Arrays.asList(aS2.getMeasurementSchema(), aS1.getMeasurementSchema()));
            schemaMap.put("root.sg.d2.a", (PartialPath)alignedPath);
            schemaMap.put("desc_root.sg.d2.a", (PartialPath)descOrderAlignedPath);
            AlignedPath aligned_d2s1 = new AlignedPath("root.sg.d2.a", Collections.singletonList("s1"), Collections.singletonList(aS1.getMeasurementSchema()));
            schemaMap.put("aligned_root.sg.d2.a.s1", (PartialPath)aligned_d2s1);
            AlignedPath aligned_d2s2 = new AlignedPath("root.sg.d2.a", Collections.singletonList("s2"), Collections.singletonList(aS2.getMeasurementSchema()));
            schemaMap.put("aligned_root.sg.d2.a.s2", (PartialPath)aligned_d2s2);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
        }
    }
}

