/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.optimization;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.optimization.LimitOffsetPushDown;
import org.apache.iotdb.db.queryengine.plan.optimization.OptimizationTestUtil;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.optimization.TestPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.junit.Assert;
import org.junit.Test;

public class LimitOffsetPushDownTest {
    @Test
    public void testNonAlignedPushDown() {
        this.checkPushDown("select s1 from root.sg.d1 limit 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).limit("1", 100L).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), 100, 0).getRoot());
        this.checkPushDown("select s1 from root.sg.d1 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).offset("1", 100L).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), 0, 100).getRoot());
        this.checkPushDown("select s1 from root.sg.d1 limit 100 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).offset("1", 100L).limit("2", 100L).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), 100, 100).getRoot());
    }

    @Test
    public void testAlignedPushDown() {
        this.checkPushDown("select s1, s2 from root.sg.d2.a limit 100;", new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a")).limit("1", 100L).getRoot(), new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a"), 100, 0).getRoot());
        this.checkPushDown("select s1, s2 from root.sg.d2.a offset 100;", new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a")).offset("1", 100L).getRoot(), new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a"), 0, 100).getRoot());
        this.checkPushDown("select s1, s2 from root.sg.d2.a limit 100 offset 100;", new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a")).offset("1", 100L).limit("2", 100L).getRoot(), new TestPlanBuilder().scanAligned("0", OptimizationTestUtil.schemaMap.get("root.sg.d2.a"), 100, 100).getRoot());
    }

    @Test
    public void testPushDownWithTransform() {
        List<Expression> expressions = Arrays.asList(ExpressionFactory.add((Expression)ExpressionFactory.function((String)"sin", (Expression[])new Expression[]{ExpressionFactory.add((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"1"))}), (Expression)ExpressionFactory.intValue((String)"1")), ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")));
        this.checkPushDown("select sin(s1 + 1) + 1, s1 > 10 from root.sg.d1 limit 100 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).transform("1", expressions).offset("2", 100L).limit("3", 100L).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), 100, 100).transform("1", expressions).getRoot());
    }

    @Test
    public void testPushDownWithFill() {
        this.checkPushDown("select s1 from root.sg.d1 fill(100) limit 100 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).fill("1", "100").offset("2", 100L).limit("3", 100L).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), 100, 100).fill("1", "100").getRoot());
    }

    @Test
    public void testPushDownAlignByDevice() {
        this.checkPushDown("select s1 from root.sg.d1 limit 100 offset 100 align by device;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).singleDeviceView("1", "root.sg.d1", "s1").offset("2", 100L).limit("3", 100L).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), 100, 100).singleDeviceView("1", "root.sg.d1", "s1").getRoot());
    }

    @Test
    public void testPushDownWithInto() {
        this.checkPushDown("select s1 into root.sg.d2(s1) from root.sg.d1 limit 100 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).offset("1", 100L).limit("2", 100L).into("3", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")).getRoot(), new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), 100, 100).into("3", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d2.s1")).getRoot());
    }

    @Test
    public void testCannotPushDown() {
        this.checkCannotPushDown("select s1, s2 from root.sg.d1 limit 100;", new TestPlanBuilder().fullOuterTimeJoin(Arrays.asList(OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"), OptimizationTestUtil.schemaMap.get("root.sg.d1.s2"))).limit("3", 100L).getRoot());
        this.checkCannotPushDown("select diff(s1 + 1) + 1 from root.sg.d1 limit 100 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).transform("1", Collections.singletonList(ExpressionFactory.add((Expression)ExpressionFactory.function((String)"diff", (Expression[])new Expression[]{ExpressionFactory.add((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"1"))}), (Expression)ExpressionFactory.intValue((String)"1")))).offset("2", 100L).limit("3", 100L).getRoot());
        LinkedHashMap<String, String> functionAttributes = new LinkedHashMap<String, String>();
        functionAttributes.put("windowSize", "10");
        this.checkCannotPushDown("select m4(s1,'windowSize'='10') from root.sg.d1 limit 100 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).transform("1", Collections.singletonList(ExpressionFactory.function((String)"m4", functionAttributes, (Expression[])new Expression[]{ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"))}))).offset("2", 100L).limit("3", 100L).getRoot());
        this.checkCannotPushDown("select s1 from root.sg.d1 fill(linear) limit 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).fill("1", FillPolicy.LINEAR).limit("2", 100L).getRoot());
        this.checkCannotPushDown("select s1 from root.sg.d1 fill(previous) limit 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).fill("1", FillPolicy.PREVIOUS).limit("2", 100L).getRoot());
        this.checkCannotPushDown("select s1 from root.sg.d1 where s1 > 10 limit 100 offset 100;", new TestPlanBuilder().scan("0", OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")).filter("1", Collections.singletonList(ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1"))), (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((PartialPath)OptimizationTestUtil.schemaMap.get("root.sg.d1.s1")), (Expression)ExpressionFactory.intValue((String)"10")), false).offset("2", 100L).limit("3", 100L).getRoot());
    }

    private void checkPushDown(String sql, PlanNode rawPlan, PlanNode optPlan) {
        OptimizationTestUtil.checkPushDown((PlanOptimizer)new LimitOffsetPushDown(), sql, rawPlan, optPlan);
    }

    private void checkCannotPushDown(String sql, PlanNode rawPlan) {
        OptimizationTestUtil.checkCannotPushDown((PlanOptimizer)new LimitOffsetPushDown(), sql, rawPlan);
    }

    @Test
    public void testGroupByTimePushDown() {
        String sql = "select avg(s1),sum(s2) from root.** group by ((1, 899], 200ms) offset 1 limit 2";
        this.checkGroupByTimePushDown(sql, 201L, 601L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown2() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 200ms) offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 404L, 899L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown3() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 88ms) offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 180L, 444L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown4() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 88ms) order by time offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 180L, 444L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown5() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 88ms) order by time desc offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 532L, 796L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown6() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 100ms) order by time desc offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 404L, 704L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown7() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 50ms) order by time desc offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 654L, 804L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown8() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([0, 900), 100ms) order by time desc offset 2 limit 2";
        this.checkGroupByTimePushDown(sql, 500L, 700L, 0L, 0L);
    }

    @Test
    public void testGroupByTimePushDown9() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 50ms) order by s1 offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 4L, 899L, 3L, 2L);
    }

    @Test
    public void testGroupByTimePushDown10() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 50ms, 25ms) offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 54L, 154L, 3L, 0L);
    }

    @Test
    public void testGroupByTimePushDown11() {
        String sql = "select avg(s1),sum(s2) from root.** group by ([4, 899), 50ms, 75ms) offset 2 limit 3";
        this.checkGroupByTimePushDown(sql, 154L, 354L, 0L, 0L);
    }

    private void checkGroupByTimePushDown(String sql, long startTime, long endTime, long rowLimit, long rowOffset) {
        QueryStatement queryStatement = (QueryStatement)StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        Assert.assertEquals((long)rowLimit, (long)queryStatement.getRowLimit());
        Assert.assertEquals((long)rowOffset, (long)queryStatement.getRowOffset());
        GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
        Assert.assertEquals((long)startTime, (long)groupByTimeComponent.getStartTime());
        Assert.assertEquals((long)endTime, (long)groupByTimeComponent.getEndTime());
    }

    private void checkGroupByTimePushDownInAlignByDevice(String sql, List<String> deviceSet, long rowLimit, long rowOffset, long startTime, long endTime) {
        QueryStatement statement = (QueryStatement)StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        MPPQueryContext context = new MPPQueryContext(new QueryId("test_query"));
        Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
        Analysis analysis = analyzer.analyze((Statement)statement);
        Assert.assertEquals((long)rowLimit, (long)statement.getRowLimit());
        Assert.assertEquals((long)rowOffset, (long)statement.getRowOffset());
        int index = 0;
        List deviceSetInAnalysis = analysis.getDeviceList();
        for (PartialPath path : deviceSetInAnalysis) {
            Assert.assertEquals((Object)path.getFullPath(), (Object)deviceSet.get(index));
            ++index;
        }
        GroupByTimeParameter groupByTimeParameter = analysis.getGroupByTimeParameter();
        Assert.assertEquals((long)startTime, (long)groupByTimeParameter.getStartTime());
        Assert.assertEquals((long)endTime, (long)groupByTimeParameter.getEndTime());
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice() {
        String sql = "select avg(s1) from root.** group by ([4, 899), 50ms) offset 16 limit 2 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d1");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 0L, 0L, 804L, 899L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice2() {
        String sql = "select avg(s1) from root.** group by ([4, 899), 50ms) offset 16 limit 10 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d1");
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 10L, 16L, 4L, 899L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice3() {
        String sql = "select avg(s1) from root.** group by ([4, 899), 50ms) offset 20 limit 2 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 0L, 0L, 104L, 204L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice4() {
        String sql = "select avg(s1) from root.** group by ([4, 899), 50ms) offset 33 limit 5 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        deviceSet.add("root.sg.d2.a");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 5L, 15L, 4L, 899L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice5() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) offset 9 limit 5 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 5L, 0L, 29L, 179L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice6() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) offset 9 limit 9 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        deviceSet.add("root.sg.d2.a");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 9L, 1L, 4L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice7() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) offset 9 limit 9 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        deviceSet.add("root.sg.d2.a");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 9L, 1L, 4L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice8() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device offset 9 limit 9 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        deviceSet.add("root.sg.d2.a");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 9L, 1L, 4L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice9() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device desc offset 9 limit 9 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        deviceSet.add("root.sg.d1");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 9L, 1L, 4L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice10() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device, time desc offset 9 limit 5 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 5L, 0L, 54L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice11() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device desc, time desc offset 9 limit 5 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 5L, 0L, 54L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice12() {
        String sql = "select avg(s1) from root.** group by ([4, 899), 50ms) order by device desc offset 16 limit 2 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2.a");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 0L, 0L, 804L, 899L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice13() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device, avg(s1) desc offset 9 limit 5 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 5L, 1L, 4L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice14() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device, avg(s1) desc,time desc offset 9 limit 5 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 5L, 1L, 4L, 199L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice15() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device desc limit 1 offset 8 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 1L, 0L, 4L, 54L);
    }

    @Test
    public void testGroupByTimePushDownInAlignByDevice16() {
        String sql = "select avg(s1) from root.** group by ([4, 199), 50ms, 25ms) order by device desc offset 8 align by device";
        ArrayList<String> deviceSet = new ArrayList<String>();
        deviceSet.add("root.sg.d2");
        deviceSet.add("root.sg.d1");
        this.checkGroupByTimePushDownInAlignByDevice(sql, deviceSet, 0L, 0L, 4L, 199L);
    }
}

