/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.operator.Not;
import org.apache.iotdb.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;

public class QueryTimePartitionTest {
    @Test
    public void testAndTimeFilter() {
        TimeFilterOperators.TimeGt left = TimeFilterApi.gt((long)10L);
        TimeFilterOperators.TimeLt right = TimeFilterApi.lt((long)20L);
        Filter andFilter = FilterFactory.and((Filter)left, (Filter)right);
        List timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)19L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = FilterFactory.and((Filter)left, (Filter)TimeFilterApi.ltEq((long)20L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = FilterFactory.and((Filter)TimeFilterApi.gtEq((long)10L), (Filter)TimeFilterApi.ltEq((long)20L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = FilterFactory.and((Filter)TimeFilterApi.ltEq((long)20L), (Filter)TimeFilterApi.gtEq((long)10L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        andFilter = FilterFactory.and((Filter)TimeFilterApi.gtEq((long)20L), (Filter)TimeFilterApi.ltEq((long)10L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)0L, (long)timeRangeList.size());
        andFilter = FilterFactory.and((Filter)TimeFilterApi.gtEq((long)20L), (Filter)TimeFilterApi.lt((long)20L));
        timeRangeList = andFilter.getTimeRanges();
        Assert.assertEquals((long)0L, (long)timeRangeList.size());
    }

    @Test
    public void testOrTimeFilter() {
        Filter filter = FilterFactory.or((Filter)TimeFilterApi.lt((long)10L), (Filter)TimeFilterApi.gt((long)20L));
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = FilterFactory.or((Filter)TimeFilterApi.lt((long)10L), (Filter)TimeFilterApi.gtEq((long)20L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = FilterFactory.or((Filter)TimeFilterApi.ltEq((long)10L), (Filter)TimeFilterApi.gtEq((long)20L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = FilterFactory.or((Filter)TimeFilterApi.gtEq((long)20L), (Filter)TimeFilterApi.ltEq((long)10L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = FilterFactory.or((Filter)TimeFilterApi.gtEq((long)20L), (Filter)TimeFilterApi.gtEq((long)10L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter = FilterFactory.or((Filter)TimeFilterApi.lt((long)20L), (Filter)TimeFilterApi.ltEq((long)10L));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)19L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testAndOrTimeFilter() {
        Filter filter = FilterFactory.or((Filter)FilterFactory.and((Filter)TimeFilterApi.gtEq((long)10L), (Filter)TimeFilterApi.ltEq((long)20L)), (Filter)TimeFilterApi.gt((long)30L));
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)31L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        Filter filter1 = FilterFactory.and((Filter)FilterFactory.or((Filter)TimeFilterApi.ltEq((long)10L), (Filter)TimeFilterApi.gt((long)20L)), (Filter)TimeFilterApi.gtEq((long)30L));
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)30L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter1 = FilterFactory.and((Filter)FilterFactory.or((Filter)TimeFilterApi.ltEq((long)10L), (Filter)TimeFilterApi.gt((long)20L)), (Filter)TimeFilterApi.ltEq((long)30L));
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)30L, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = FilterFactory.or((Filter)FilterFactory.and((Filter)TimeFilterApi.gtEq((long)10L), (Filter)TimeFilterApi.ltEq((long)20L)), (Filter)FilterFactory.and((Filter)TimeFilterApi.lt((long)100L), (Filter)TimeFilterApi.gt((long)30L)));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)31L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)99L, (long)((TimeRange)timeRangeList.get(1)).getMax());
    }

    @Test
    public void testBetweenTimeFilter() {
        TimeFilterOperators.TimeBetweenAnd filter = TimeFilterApi.between((long)10L, (long)20L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter = TimeFilterApi.notBetween((long)10L, (long)20L);
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = TimeFilterApi.notBetween((long)10L, (long)Long.MAX_VALUE);
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        filter = TimeFilterApi.notBetween((long)Long.MIN_VALUE, (long)20L);
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testNotTimeFilter() {
        Not filter = FilterFactory.not((Filter)FilterFactory.and((Filter)TimeFilterApi.gt((long)10L), (Filter)TimeFilterApi.ltEq((long)20L)));
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)21L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        filter = FilterFactory.not((Filter)FilterFactory.or((Filter)TimeFilterApi.gt((long)20L), (Filter)TimeFilterApi.ltEq((long)10L)));
        timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)20L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeEqFilter() {
        TimeFilterOperators.TimeEq filter = TimeFilterApi.eq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Not filter1 = FilterFactory.not((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
    }

    @Test
    public void testTimeNotEqFilter() {
        TimeFilterOperators.TimeNotEq filter = TimeFilterApi.notEq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)2L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(1)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(1)).getMax());
        Not filter1 = FilterFactory.not((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeGtFilter() {
        TimeFilterOperators.TimeGt filter = TimeFilterApi.gt((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Not filter1 = FilterFactory.not((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeGtEqFilter() {
        TimeFilterOperators.TimeGtEq filter = TimeFilterApi.gtEq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Not filter1 = FilterFactory.not((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeLtFilter() {
        TimeFilterOperators.TimeLt filter = TimeFilterApi.lt((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)9L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Not filter1 = FilterFactory.not((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testTimeLtEqFilter() {
        TimeFilterOperators.TimeLtEq filter = TimeFilterApi.ltEq((long)10L);
        List timeRangeList = filter.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)10L, (long)((TimeRange)timeRangeList.get(0)).getMax());
        Not filter1 = FilterFactory.not((Filter)filter);
        timeRangeList = filter1.getTimeRanges();
        Assert.assertEquals((long)1L, (long)timeRangeList.size());
        Assert.assertEquals((long)11L, (long)((TimeRange)timeRangeList.get(0)).getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((TimeRange)timeRangeList.get(0)).getMax());
    }

    @Test
    public void testGetTimePartitionSlotList() {
        int i;
        Pair res = AnalyzeVisitor.getTimePartitionSlotList((Filter)FilterFactory.and((Filter)TimeFilterApi.gtEq((long)10L), (Filter)TimeFilterApi.ltEq((long)9L)));
        Assert.assertTrue((boolean)((List)res.left).isEmpty());
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilterApi.gtEq((long)10L));
        Assert.assertEquals((long)1L, (long)((List)res.left).size());
        List<TTimePartitionSlot> expected = Collections.singletonList(new TTimePartitionSlot(0L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertTrue((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilterApi.lt((long)20L));
        Assert.assertEquals((long)1L, (long)((List)res.left).size());
        expected = Collections.singletonList(new TTimePartitionSlot(0L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertTrue((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)FilterFactory.and((Filter)TimeFilterApi.gt((long)10L), (Filter)TimeFilterApi.ltEq((long)20L)));
        expected = Collections.singletonList(new TTimePartitionSlot(0L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)FilterFactory.and((Filter)TimeFilterApi.gt((long)0L), (Filter)TimeFilterApi.ltEq((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L + 1L))));
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)FilterFactory.and((Filter)TimeFilterApi.gtEq((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() - 1L)), (Filter)TimeFilterApi.lt((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() + 1L))));
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilterApi.between((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() - 1L), (long)CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)FilterFactory.and((Filter)TimeFilterApi.gtEq((long)CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()), (Filter)TimeFilterApi.ltEq((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() + 1L))));
        expected = Collections.singletonList(new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)TimeFilterApi.between((long)CommonDescriptor.getInstance().getConfig().getTimePartitionInterval(), (long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() + 1L)));
        expected = Collections.singletonList(new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), ((List)res.left).get(i));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
        Filter orFilter1 = FilterFactory.or((Filter)FilterFactory.and((Filter)TimeFilterApi.gtEq((long)10L), (Filter)TimeFilterApi.lt((long)CommonDescriptor.getInstance().getConfig().getTimePartitionInterval())), (Filter)FilterFactory.and((Filter)TimeFilterApi.gt((long)CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()), (Filter)TimeFilterApi.lt((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 100L))));
        Filter orFilter2 = FilterFactory.or((Filter)orFilter1, (Filter)FilterFactory.and((Filter)TimeFilterApi.gt((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 50L)), (Filter)TimeFilterApi.ltEq((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 40L))));
        Filter orFilter3 = FilterFactory.or((Filter)orFilter2, (Filter)FilterFactory.and((Filter)TimeFilterApi.gt((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L - 20L)), (Filter)TimeFilterApi.ltEq((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L + 10L))));
        Filter orFilter4 = FilterFactory.or((Filter)orFilter3, (Filter)FilterFactory.and((Filter)TimeFilterApi.gt((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 5L + 1L)), (Filter)TimeFilterApi.lt((long)(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 5L + 10L))));
        res = AnalyzeVisitor.getTimePartitionSlotList((Filter)orFilter4);
        expected = Arrays.asList(new TTimePartitionSlot(0L), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval()), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 2L), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 3L), new TTimePartitionSlot(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval() * 5L));
        Assert.assertEquals((long)expected.size(), (long)((List)res.left).size());
        for (int i2 = 0; i2 < expected.size(); ++i2) {
            Assert.assertEquals((Object)expected.get(i2), ((List)res.left).get(i2));
        }
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).left));
        Assert.assertFalse((boolean)((Boolean)((Pair)res.right).right));
    }
}

