/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzeFailTest {
    @Test
    public void illegalAggregationTest1() {
        String message = "Raw data and aggregation result hybrid calculation is not supported.";
        this.assertAnalyzeSemanticException("SELECT sum(s1) + s1 FROM root.sg.d1", message);
    }

    @Test
    public void illegalAggregationTest2() {
        String message = "Aggregation results cannot be as input of the aggregation function.";
        this.assertAnalyzeSemanticException("SELECT sum(sum(s1)) FROM root.sg.d1", message);
    }

    @Test
    public void illegalAggregationTest3() {
        String message = "Raw data and aggregation hybrid query is not supported.";
        this.assertAnalyzeSemanticException("SELECT sum(s1), s1 FROM root.sg.d1", message);
    }

    @Test
    public void samePropertyKeyTest() {
        this.assertAnalyzeSemanticException("CREATE TIMESERIES root.sg1.d1.s1 INT32 TAGS('a'='1') ATTRIBUTES('a'='1')", "Tag and attribute shouldn't have the same property key");
    }

    @Test
    public void sameMeasurementsInAlignedTest() {
        this.assertAnalyzeSemanticException("CREATE ALIGNED TIMESERIES root.ln.wf01.GPS(latitude FLOAT, latitude FLOAT)", "Measurement under an aligned device is not allowed to have the same measurement name");
    }

    @Test
    public void selectIntoTest() {
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2) from root.sg.* align by device;", "select into: the number of source devices and the number of target devices should be the same.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2) from root.sg.*;", "select into: the number of source columns and the number of target paths should be the same.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2), root.sg_bk.new_d(t3, t1) from root.sg.* align by device;", "select into: target paths in into clause should be different.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2, t1, t4) from root.sg.*;", "select into: target paths in into clause should be different.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_${1}(t1, t2) from root.sg.* align by device;", "select into: target paths in into clause should be different.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_${1}(t1, t2), root.sg_bk.new_${1}(t1, t2) from root.sg.*;", "select into: target paths in into clause should be different.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(::) from root.sg.*;", "select into: target paths in into clause should be different.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2), aligned root.sg_bk.new_d(t3, t4) from root.sg.* align by device;", "select into: alignment property must be the same for the same device.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d(t1, t2), aligned root.sg_bk.new_d(t3, t4) from root.sg.*;", "select into: alignment property must be the same for the same device.");
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_${2}(::) from root.sg.* align by device;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.* align by device;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.*;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_${2}(t1, t2, t3, t4) from root.sg.*;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select count(s1), last_value(s2) into root.sg_bk.new_${2}(::) from root.sg.*;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_${2}(::) from root.sg.* align by device;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.* align by device;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.*;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_${2}(t1, t2, t3, t4) from root.sg.*;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select s1 + 1, s1 + s2 into root.sg_bk.new_${2}(::) from root.sg.*;", "select into: placeholders can only be used in raw time series data queries.");
        this.assertAnalyzeSemanticException("select * into root.sg_bk.new_d1(::), root.sg_bk.new_d2(::) from root.sg.**;", "select into: the correspondence between the placeholder and the raw time series could not be established.");
        this.assertAnalyzeSemanticException("select s1, s2 into root.sg_bk.new_d1(${3}, s2) from root.sg.d1;", "select into: the correspondence between the placeholder and the raw time series could not be established.");
        this.assertAnalyzeSemanticException("select * into root.sg_bk.new_${2}(::, s1) from root.sg.**;", "select into: the correspondence between the placeholder and the raw time series could not be established.");
        this.assertAnalyzeSemanticException("select d1.s1, d1.s2, d2.s3, d3.s4 into ::(s1_1, s2_2, backup_${4}) from root.sg", "select into: the correspondence between the placeholder and the raw time series could not be established.");
        this.assertAnalyzeSemanticException("select s1, s2 into ::(s1_1, s2_2), root.backup_sg.::(s1, s2) from root.sg.* align by device;", "select into: the correspondence between the placeholder and the raw time series could not be established.");
        this.assertAnalyzeSemanticException("select s1 into root.sg_bk.${2}_$abc(s1) from root.sg.d1;", "is illegal, unquoted node name can only consist of digits, characters and underscore, or start or end with wildcard");
        this.assertAnalyzeSemanticException("select s1 into root.sg_bk.d01(${3}_$abc) from root.sg.d1;", "is illegal, unquoted node name can only consist of digits, characters and underscore, or start or end with wildcard");
    }

    @Test
    public void countTimeTest() {
        this.assertAnalyzeSemanticException("select count_time(*) from root.sg.* group by level=1;", "Count_time aggregation function using with group by level is not supported.");
        this.assertAnalyzeSemanticException("select count_time(*) from root.sg.* group by tags(key);", "Count_time aggregation function using with group by tag is not supported.");
        this.assertAnalyzeSemanticException("select count_time(s1) from root.sg.*;", "The parameter of count_time aggregation can only be '*'.");
        this.assertAnalyzeSemanticException("select count_time(s1) from root.sg.d1;", "The parameter of count_time aggregation can only be '*'.");
        this.assertAnalyzeSemanticException("select count_time(d1.s1) from root.sg.*;", "The parameter of count_time aggregation can only be '*'.");
        this.assertAnalyzeSemanticException("select count_time(d1.*) from root.sg.*;", "The parameter of count_time aggregation can only be '*'.");
        this.assertAnalyzeSemanticException("select count_time(* + *) from root.sg.*;", "The parameter of count_time aggregation can only be '*'.");
        this.assertAnalyzeSemanticException("select count_time(*) / 2 from root.sg.*;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select sum(s1) / count_time(*) from root.sg.*;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select count_time(*), count(*) from root.sg.*;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select count(*), count_time(*) from root.sg.*;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select sum(*), count_time(*), sum(*) from root.sg.*;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select s1, count_time(*), sum(*) from root.sg.*;", "Raw data and aggregation hybrid query is not supported.");
        this.assertAnalyzeSemanticException("select count_time(*),count_time(*) from root.sg.**;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select count_time(*),count_time(*) from root.sg.d1,root.sg.d2;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select COUNT_TIME(*),COUNT_TIME(*) from root.sg.d1,root.sg.d2;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select COUNT_TIME(*),count_time(*) from root.sg.d1,root.sg.d2;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select COUNT_TIME(*),COUNT_time(*) from root.sg.d1,root.sg.d2;", "Count_time aggregation can only exist alone, and cannot used with other queries or aggregations.");
        this.assertAnalyzeSemanticException("select count_time(*) from root.sg.* having count(*) > 1;", "Count_time aggregation function can not be used with having clause.");
        this.assertAnalyzeSemanticException("select count_time(*) from root.sg.* having count_time(s1) > 1;", "Count_time aggregation function can not be used with having clause.");
        this.assertAnalyzeSemanticException("select count_time(*) from root.sg.* having count_time(*) > 1;", "Count_time aggregation function can not be used with having clause.");
    }

    private void assertAnalyzeSemanticException(String sql, String message) {
        try {
            Analyzer analyzer = new Analyzer(new MPPQueryContext(new QueryId("test_query")), (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            analyzer.analyze(StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset()));
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(message));
        }
    }
}

