/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.expression.serde;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.junit.Assert;
import org.junit.Test;

public class CaseWhenThenExpressionTest {
    private void assertSerializeDeserializeEqual(CaseWhenThenExpression caseWhenThenExpression) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
        byteBuffer.mark();
        Expression.serialize((Expression)caseWhenThenExpression, (ByteBuffer)byteBuffer);
        byteBuffer.reset();
        Assert.assertEquals((Object)caseWhenThenExpression, (Object)Expression.deserialize((ByteBuffer)byteBuffer));
    }

    @Test
    public void serializeDeserializeTest() throws IllegalPathException {
        ArrayList<WhenThenExpression> whenThenExpressionList = new ArrayList<WhenThenExpression>();
        whenThenExpressionList.add(ExpressionFactory.whenThen((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.timeSeries((String)"root.f.x"), (Expression)ExpressionFactory.intValue((String)"1")), (Expression)ExpressionFactory.intValue((String)"10")));
        CaseWhenThenExpression case1 = new CaseWhenThenExpression(whenThenExpressionList, (Expression)ExpressionFactory.intValue((String)"20"));
        this.assertSerializeDeserializeEqual(case1);
        whenThenExpressionList.add(ExpressionFactory.whenThen((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.timeSeries((String)"root.f.x"), (Expression)ExpressionFactory.intValue((String)"1")), (Expression)ExpressionFactory.intValue((String)"10")));
        whenThenExpressionList.add(ExpressionFactory.whenThen((Expression)ExpressionFactory.lt((Expression)ExpressionFactory.timeSeries((String)"root.f.y"), (Expression)ExpressionFactory.intValue((String)"2")), (Expression)ExpressionFactory.intValue((String)"20")));
        whenThenExpressionList.add(ExpressionFactory.whenThen((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.timeSeries((String)"root.f.g"), (Expression)ExpressionFactory.intValue((String)"333")), (Expression)ExpressionFactory.intValue((String)"20")));
        CaseWhenThenExpression case2 = new CaseWhenThenExpression(whenThenExpressionList, (Expression)ExpressionFactory.intValue((String)"99999"));
        this.assertSerializeDeserializeEqual(case2);
        CaseWhenThenExpression case3 = new CaseWhenThenExpression(whenThenExpressionList, null);
        this.assertSerializeDeserializeEqual(case3);
    }
}

