/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.expression.predicate;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.junit.Assert;
import org.junit.Test;

public class PredicatePushIntoScanTest {
    private static final TimeSeriesOperand testPath = ExpressionFactory.timeSeries((PartialPath)new PartialPath("s1", false));

    @Test
    public void testCanPushInto() {
        this.testCanPushIntoScan((Expression)ExpressionFactory.lt((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1")));
        this.testCanPushIntoScan((Expression)ExpressionFactory.lt((Expression)ExpressionFactory.intValue((String)"1"), (Expression)testPath));
        this.testCanPushIntoScan((Expression)ExpressionFactory.gte((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)));
        this.testCanPushIntoScan((Expression)ExpressionFactory.gte((Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.time()));
        this.testCanPushIntoScan((Expression)ExpressionFactory.between((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.intValue((String)"2")));
        this.testCanPushIntoScan((Expression)ExpressionFactory.between((Expression)ExpressionFactory.intValue((String)"1"), (Expression)testPath, (Expression)ExpressionFactory.intValue((String)"2")));
        this.testCanPushIntoScan((Expression)ExpressionFactory.between((Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.intValue((String)"2"), (Expression)testPath));
        this.testCanPushIntoScan((Expression)ExpressionFactory.between((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.longValue((long)2L)));
        this.testCanPushIntoScan((Expression)ExpressionFactory.between((Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)2L)));
        this.testCanPushIntoScan((Expression)ExpressionFactory.between((Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.longValue((long)2L), (Expression)ExpressionFactory.time()));
        LinkedHashSet<String> values = new LinkedHashSet<String>(Arrays.asList("1", "2", "3"));
        this.testCanPushIntoScan((Expression)ExpressionFactory.in((Expression)testPath, values));
        this.testCanPushIntoScan((Expression)ExpressionFactory.isNotNull((Expression)testPath));
        this.testCanPushIntoScan((Expression)ExpressionFactory.like((Expression)testPath, (String)"%cc%"));
        this.testCanPushIntoScan((Expression)ExpressionFactory.notRegex((Expression)testPath, (String)"^[A-Za-z]+$"));
    }

    @Test
    public void testCannotPushInto() {
        this.testCannotPushIntoScan((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.add((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1")), (Expression)ExpressionFactory.intValue((String)"1")));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.add((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1"))));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.sin((Expression)testPath), (Expression)ExpressionFactory.intValue((String)"1")));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.sin((Expression)testPath)));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.lt((Expression)testPath, (Expression)ExpressionFactory.add((Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.intValue((String)"1"))));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.lt((Expression)testPath, (Expression)testPath));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.between((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.add((Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.intValue((String)"1"))));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.between((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1"), (Expression)testPath));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.between((Expression)testPath, (Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1")));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.between((Expression)testPath, (Expression)testPath, (Expression)testPath));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.between((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1"), (Expression)ExpressionFactory.sin((Expression)testPath)));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.between((Expression)testPath, (Expression)ExpressionFactory.sin((Expression)testPath), (Expression)ExpressionFactory.intValue((String)"1")));
        LinkedHashSet<String> values = new LinkedHashSet<String>(Arrays.asList("1", "2", "3"));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.in((Expression)ExpressionFactory.sin((Expression)testPath), values));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.in((Expression)ExpressionFactory.add((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1")), values));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.isNotNull((Expression)ExpressionFactory.sin((Expression)testPath)));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.isNotNull((Expression)ExpressionFactory.add((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1"))));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.like((Expression)ExpressionFactory.sin((Expression)testPath), (String)"%cc%"));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.notRegex((Expression)ExpressionFactory.sin((Expression)testPath), (String)"^[A-Za-z]+$"));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.like((Expression)ExpressionFactory.add((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1")), (String)"%cc%"));
        this.testCannotPushIntoScan((Expression)ExpressionFactory.notRegex((Expression)ExpressionFactory.add((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1")), (String)"^[A-Za-z]+$"));
    }

    @Test
    public void testIllegalPredicate() {
        this.testIllegalPredicate((Expression)ExpressionFactory.isNull((Expression)testPath));
        this.testIllegalPredicate((Expression)ExpressionFactory.not((Expression)ExpressionFactory.eq((Expression)testPath, (Expression)ExpressionFactory.intValue((String)"1"))));
        this.testIllegalPredicate((Expression)ExpressionFactory.like((Expression)ExpressionFactory.time(), (String)"%cc%"));
        this.testIllegalPredicate((Expression)ExpressionFactory.notRegex((Expression)ExpressionFactory.time(), (String)"^[A-Za-z]+$"));
        this.testIllegalPredicate((Expression)ExpressionFactory.isNull((Expression)ExpressionFactory.time()));
        this.testIllegalPredicate((Expression)ExpressionFactory.isNotNull((Expression)ExpressionFactory.time()));
    }

    private void testCanPushIntoScan(Expression predicate) {
        Assert.assertTrue((boolean)PredicateUtils.predicateCanPushIntoScan((Expression)predicate));
    }

    private void testCannotPushIntoScan(Expression predicate) {
        Assert.assertFalse((boolean)PredicateUtils.predicateCanPushIntoScan((Expression)predicate));
    }

    private void testIllegalPredicate(Expression predicate) {
        Assert.assertThrows(IllegalArgumentException.class, () -> PredicateUtils.predicateCanPushIntoScan((Expression)predicate));
    }
}

