/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.expression.predicate;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.junit.Assert;
import org.junit.Test;

public class ConvertPredicateToTimeFilterTest {
    @Test
    public void testNormal() {
        this.testConvertToTimeFilter((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.eq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.neq((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.notEq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.gt((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.gt((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.gte((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.gtEq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.lt((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.lt((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.lte((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.ltEq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.between((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.longValue((long)10L)), (Filter)TimeFilterApi.between((long)1L, (long)10L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.notBetween((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.longValue((long)10L)), (Filter)TimeFilterApi.notBetween((long)1L, (long)10L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.between((Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)10L)), (Filter)TimeFilterApi.ltEq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.notBetween((Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)10L)), (Filter)TimeFilterApi.gt((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.between((Expression)ExpressionFactory.longValue((long)10L), (Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.time()), (Filter)TimeFilterApi.gtEq((long)10L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.notBetween((Expression)ExpressionFactory.longValue((long)10L), (Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.time()), (Filter)TimeFilterApi.lt((long)10L));
        LinkedHashSet<String> stringValueSet = new LinkedHashSet<String>(Arrays.asList("1", "2", "3"));
        LinkedHashSet<Long> valueSet = new LinkedHashSet<Long>(Arrays.asList(1L, 2L, 3L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.in((Expression)ExpressionFactory.time(), stringValueSet), (Filter)TimeFilterApi.in(valueSet));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.notIn((Expression)ExpressionFactory.time(), stringValueSet), (Filter)TimeFilterApi.notIn(valueSet));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.and((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Expression)ExpressionFactory.eq((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)2L))), FilterFactory.and((Filter)TimeFilterApi.eq((long)1L), (Filter)TimeFilterApi.eq((long)2L)));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.or((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L)), (Expression)ExpressionFactory.eq((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)2L))), FilterFactory.or((Filter)TimeFilterApi.eq((long)1L), (Filter)TimeFilterApi.eq((long)2L)));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.groupByTime((long)1L, (long)100L, (long)10L, (long)20L), (Filter)TimeFilterApi.groupBy((long)1L, (long)100L, (long)10L, (long)20L));
        GroupByTimeParameter parameter = new GroupByTimeParameter(1L, 1000000000L, new TimeDuration(1, 0L), new TimeDuration(2, 0L), true);
        this.testConvertToTimeFilter((Expression)ExpressionFactory.groupByTime((GroupByTimeParameter)parameter), (Filter)TimeFilterApi.groupByMonth((long)parameter.getStartTime(), (long)parameter.getEndTime(), (TimeDuration)parameter.getInterval(), (TimeDuration)parameter.getSlidingStep(), (TimeZone)TimeZone.getTimeZone("+00:00"), (TimeUnit)TimestampPrecisionUtils.currPrecision));
    }

    @Test
    public void testRewrite() {
        LinkedHashSet<String> stringValueSet = new LinkedHashSet<String>(Collections.singletonList("1"));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.in((Expression)ExpressionFactory.time(), stringValueSet), (Filter)TimeFilterApi.eq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.notIn((Expression)ExpressionFactory.time(), stringValueSet), (Filter)TimeFilterApi.notEq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.between((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.eq((long)1L));
        this.testConvertToTimeFilter((Expression)ExpressionFactory.notBetween((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L), (Expression)ExpressionFactory.longValue((long)1L)), (Filter)TimeFilterApi.notEq((long)1L));
    }

    @Test
    public void testNot() {
        try {
            PredicateUtils.convertPredicateToTimeFilter((Expression)ExpressionFactory.not((Expression)ExpressionFactory.eq((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)1L))));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"This predicate contains a not! Did you forget to run this predicate through PredicateRemoveNotRewriter? ", (Object)e.getMessage());
        }
    }

    private void testConvertToTimeFilter(Expression predicate, Filter expectedFilter) {
        Assert.assertEquals((Object)expectedFilter, (Object)PredicateUtils.convertPredicateToTimeFilter((Expression)predicate));
    }
}

