/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.IDriver;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.DriverTaskHandle;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.MultilevelPriorityQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskId;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskStatus;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MultilevelPriorityQueueTest {
    @Test
    public void testPollBlocked() {
        try {
            MultilevelPriorityQueue queue = new MultilevelPriorityQueue(2.0, 1000, new DriverTask());
            ArrayList res = new ArrayList();
            Thread t1 = new Thread(() -> MultilevelPriorityQueueTest.lambda$testPollBlocked$0((IndexedBlockingQueue)queue, res));
            t1.start();
            Thread.sleep(100L);
            Assert.assertEquals((Object)((Object)Thread.State.WAITING), (Object)((Object)t1.getState()));
            DriverTask e2 = this.mockDriverTask(this.mockDriverTaskId(), false);
            queue.push((IDIndexedAccessible)e2);
            Thread.sleep(100L);
            Assert.assertEquals((Object)((Object)Thread.State.TERMINATED), (Object)((Object)t1.getState()));
            Assert.assertEquals((long)1L, (long)res.size());
            Assert.assertEquals((Object)e2.getDriverTaskId().toString(), (Object)((DriverTask)res.get(0)).getDriverTaskId().toString());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testPushExceedCapacity() {
        MultilevelPriorityQueue queue = new MultilevelPriorityQueue(2.0, 1, new DriverTask());
        DriverTask e1 = this.mockDriverTask(this.mockDriverTaskId(), false);
        queue.push((IDIndexedAccessible)e1);
        DriverTask e2 = this.mockDriverTask(this.mockDriverTaskId(), false);
        Assert.assertThrows(IllegalStateException.class, () -> MultilevelPriorityQueueTest.lambda$testPushExceedCapacity$1((IndexedBlockingQueue)queue, e2));
    }

    @Test
    public void testPushAndPoll() {
        try {
            MultilevelPriorityQueue queue = new MultilevelPriorityQueue(2.0, 1000, new DriverTask());
            DriverTask e1 = this.mockDriverTask(this.mockDriverTaskId(), false);
            queue.push((IDIndexedAccessible)e1);
            Assert.assertEquals((long)1L, (long)queue.size());
            DriverTask e2 = this.mockDriverTask(new DriverTaskId(new FragmentInstanceId(new PlanFragmentId(new QueryId("test"), 0), "inst-1"), 0), false);
            queue.push((IDIndexedAccessible)e2);
            Assert.assertEquals((long)2L, (long)queue.size());
            Assert.assertEquals((Object)e1.getDriverTaskId().toString(), (Object)((DriverTask)queue.poll()).getDriverTaskId().toString());
            Assert.assertEquals((long)1L, (long)queue.size());
            Assert.assertEquals((Object)e2.getDriverTaskId().toString(), (Object)((DriverTask)queue.poll()).getDriverTaskId().toString());
            Assert.assertEquals((long)0L, (long)queue.size());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testClear() {
        MultilevelPriorityQueue queue = new MultilevelPriorityQueue(2.0, 1000, new DriverTask());
        DriverTask e1 = this.mockDriverTask(this.mockDriverTaskId(), false);
        queue.push((IDIndexedAccessible)e1);
        DriverTask e2 = this.mockDriverTask(new DriverTaskId(new FragmentInstanceId(new PlanFragmentId(new QueryId("test"), 0), "inst-1"), 0), false);
        queue.push((IDIndexedAccessible)e2);
        Assert.assertEquals((long)2L, (long)queue.size());
        queue.clear();
        Assert.assertEquals((long)0L, (long)queue.size());
    }

    @Test
    public void testIsEmpty() {
        try {
            MultilevelPriorityQueue queue = new MultilevelPriorityQueue(2.0, 1000, new DriverTask());
            Assert.assertTrue((boolean)queue.isEmpty());
            DriverTask e1 = this.mockDriverTask(this.mockDriverTaskId(), false);
            queue.push((IDIndexedAccessible)e1);
            Assert.assertFalse((boolean)queue.isEmpty());
            queue.poll();
            Assert.assertTrue((boolean)queue.isEmpty());
            DriverTask e2 = this.mockDriverTask(new DriverTaskId(new FragmentInstanceId(new PlanFragmentId(new QueryId("test"), 0), "inst-1"), 0), false);
            queue.push((IDIndexedAccessible)e2);
            Assert.assertFalse((boolean)queue.isEmpty());
            queue.poll();
            Assert.assertTrue((boolean)queue.isEmpty());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testPushAndPollWithHighestLevelPriority() {
        try {
            MultilevelPriorityQueue queue = new MultilevelPriorityQueue(2.0, 1000, new DriverTask());
            DriverTask e1 = this.mockDriverTask(this.mockDriverTaskId(), true);
            queue.push((IDIndexedAccessible)e1);
            Assert.assertEquals((long)1L, (long)queue.size());
            Assert.assertEquals((long)1L, (long)queue.getHighestPriorityLevelQueue().size());
            DriverTask e2 = this.mockDriverTask(new DriverTaskId(new FragmentInstanceId(new PlanFragmentId(new QueryId("test"), 0), "inst-1"), 0), false);
            queue.push((IDIndexedAccessible)e2);
            Assert.assertEquals((long)2L, (long)queue.size());
            Assert.assertEquals((Object)e1.getDriverTaskId().toString(), (Object)((DriverTask)queue.poll()).getDriverTaskId().toString());
            Assert.assertEquals((long)1L, (long)queue.size());
            Assert.assertEquals((long)0L, (long)queue.getHighestPriorityLevelQueue().size());
            Assert.assertEquals((Object)e2.getDriverTaskId().toString(), (Object)((DriverTask)queue.poll()).getDriverTaskId().toString());
            Assert.assertEquals((long)0L, (long)queue.size());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private DriverTask mockDriverTask(DriverTaskId driverTaskID, boolean isHighestPriority) {
        DriverScheduler manager = DriverScheduler.getInstance();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(1, (MultilevelPriorityQueue)manager.getReadyQueue(), OptionalInt.of(Integer.MAX_VALUE));
        Mockito.when((Object)mockDriver.getDriverTaskId()).thenReturn((Object)driverTaskID);
        return new DriverTask(mockDriver, 100L, DriverTaskStatus.READY, driverTaskHandle, 0L, isHighestPriority);
    }

    private DriverTaskId mockDriverTaskId() {
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        return new DriverTaskId(instanceId, 0);
    }

    private static /* synthetic */ void lambda$testPushExceedCapacity$1(IndexedBlockingQueue queue, DriverTask e2) throws Throwable {
        queue.push((IDIndexedAccessible)e2);
    }

    private static /* synthetic */ void lambda$testPollBlocked$0(IndexedBlockingQueue queue, List res) {
        try {
            DriverTask e = (DriverTask)queue.poll();
            res.add(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

