/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.ID;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.L2PriorityQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.QueueElement;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;

public class L2PriorityQueueTest {
    @Test
    public void testPollBlocked() throws InterruptedException {
        L2PriorityQueue queue = new L2PriorityQueue(10, (o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            return Integer.compare(o1.getValue(), o2.getValue());
        }, (IDIndexedAccessible)new QueueElement(new QueueElement.QueueElementID(0), 0));
        ArrayList res = new ArrayList();
        Thread t1 = new Thread(() -> L2PriorityQueueTest.lambda$testPollBlocked$1((IndexedBlockingQueue)queue, res));
        t1.start();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> Assert.assertEquals((Object)((Object)Thread.State.WAITING), (Object)((Object)t1.getState())));
        QueueElement e2 = new QueueElement(new QueueElement.QueueElementID(1), 1);
        queue.push((IDIndexedAccessible)e2);
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> Assert.assertEquals((Object)((Object)Thread.State.TERMINATED), (Object)((Object)t1.getState())));
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((Object)e2.getDriverTaskId().toString(), (Object)((QueueElement)res.get(0)).getDriverTaskId().toString());
    }

    @Test
    public void testPushExceedCapacity() {
        L2PriorityQueue queue = new L2PriorityQueue(1, (o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            return Integer.compare(o1.getValue(), o2.getValue());
        }, (IDIndexedAccessible)new QueueElement(new QueueElement.QueueElementID(0), 0));
        QueueElement e2 = new QueueElement(new QueueElement.QueueElementID(1), 1);
        queue.push((IDIndexedAccessible)e2);
        QueueElement e3 = new QueueElement(new QueueElement.QueueElementID(2), 2);
        try {
            queue.push((IDIndexedAccessible)e3);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testPushAndPoll() throws InterruptedException {
        L2PriorityQueue queue = new L2PriorityQueue(10, (o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            int res = Integer.compare(o1.getValue(), o2.getValue());
            if (res != 0) {
                return res;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getDriverTaskId().toString(), o2.getDriverTaskId().toString());
        }, (IDIndexedAccessible)new QueueElement(new QueueElement.QueueElementID(0), 0));
        QueueElement e1 = new QueueElement(new QueueElement.QueueElementID(1), 10);
        queue.push((IDIndexedAccessible)e1);
        Assert.assertEquals((long)1L, (long)queue.size());
        QueueElement e2 = new QueueElement(new QueueElement.QueueElementID(2), 5);
        queue.push((IDIndexedAccessible)e2);
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertEquals((Object)e2.getDriverTaskId().toString(), (Object)((QueueElement)queue.poll()).getDriverTaskId().toString());
        Assert.assertEquals((long)1L, (long)queue.size());
        QueueElement e3 = new QueueElement(new QueueElement.QueueElementID(3), 10);
        queue.push((IDIndexedAccessible)e3);
        Assert.assertEquals((Object)e1.getDriverTaskId().toString(), (Object)((QueueElement)queue.poll()).getDriverTaskId().toString());
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertEquals((Object)e3.getDriverTaskId().toString(), (Object)((QueueElement)queue.poll()).getDriverTaskId().toString());
        Assert.assertEquals((long)0L, (long)queue.size());
    }

    @Test
    public void testRemoveElement() {
        L2PriorityQueue queue = new L2PriorityQueue(10, (o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            int res = Integer.compare(o1.getValue(), o2.getValue());
            if (res != 0) {
                return res;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getDriverTaskId().toString(), o2.getDriverTaskId().toString());
        }, (IDIndexedAccessible)new QueueElement(new QueueElement.QueueElementID(0), 0));
        QueueElement e1 = new QueueElement(new QueueElement.QueueElementID(1), 5);
        queue.push((IDIndexedAccessible)e1);
        Assert.assertEquals((long)1L, (long)queue.size());
        QueueElement e2 = new QueueElement(new QueueElement.QueueElementID(2), 10);
        queue.push((IDIndexedAccessible)e2);
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertEquals((Object)e2, (Object)queue.remove((ID)new QueueElement.QueueElementID(2)));
        Assert.assertEquals((long)1L, (long)queue.size());
    }

    @Test
    public void testClear() {
        L2PriorityQueue queue = new L2PriorityQueue(10, (o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            return Integer.compare(o1.getValue(), o2.getValue());
        }, (IDIndexedAccessible)new QueueElement(new QueueElement.QueueElementID(0), 0));
        QueueElement.QueueElementID id1 = new QueueElement.QueueElementID(1);
        QueueElement e1 = new QueueElement(id1, 10);
        queue.push((IDIndexedAccessible)e1);
        Assert.assertEquals((long)1L, (long)queue.size());
        QueueElement.QueueElementID id2 = new QueueElement.QueueElementID(2);
        QueueElement e2 = new QueueElement(id2, 5);
        queue.push((IDIndexedAccessible)e2);
        Assert.assertEquals((long)2L, (long)queue.size());
        queue.clear();
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertNull((Object)queue.get((ID)id1));
        Assert.assertNull((Object)queue.get((ID)id2));
    }

    private static /* synthetic */ void lambda$testPollBlocked$1(IndexedBlockingQueue queue, List res) {
        try {
            QueueElement e = (QueueElement)queue.poll();
            res.add(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

