/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.exception.CpuNotEnoughException;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.IDriver;
import org.apache.iotdb.db.queryengine.execution.exchange.IMPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.ID;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskId;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskStatus;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DriverSchedulerTest {
    private final DriverScheduler manager = DriverScheduler.getInstance();
    private static final long QUERY_TIMEOUT_MS = IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold();

    @After
    public void tearDown() {
        this.manager.getQueryMap().clear();
        this.manager.getBlockedTasks().clear();
        this.manager.getReadyQueue().clear();
        this.manager.getTimeoutQueue().clear();
    }

    @Test
    public void testManagingDriver() throws CpuNotEnoughException, MemoryNotEnoughException {
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId1 = new FragmentInstanceId(fragmentId, "inst-0");
        DriverTaskId driverTaskId1 = new DriverTaskId(instanceId1, 0);
        IDriver mockDriver1 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver1.getDriverTaskId()).thenReturn((Object)driverTaskId1);
        Mockito.when((Object)mockDriver1.getDriverContext()).thenReturn((Object)new DriverContext());
        FragmentInstanceId instanceId2 = new FragmentInstanceId(fragmentId, "inst-1");
        DriverTaskId driverTaskId2 = new DriverTaskId(instanceId2, 0);
        IDriver mockDriver2 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver2.getDriverTaskId()).thenReturn((Object)driverTaskId2);
        Mockito.when((Object)mockDriver2.getDriverContext()).thenReturn((Object)new DriverContext());
        List<IDriver> instances = Arrays.asList(mockDriver1, mockDriver2);
        this.manager.submitDrivers(queryId, instances, QUERY_TIMEOUT_MS, null);
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)1L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)2L, (long)((Map)this.manager.getQueryMap().get(queryId)).size());
        Assert.assertEquals((long)1L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)2L, (long)this.manager.getReadyQueue().size());
        Assert.assertNull((Object)this.manager.getTimeoutQueue().get((ID)driverTaskId1));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)driverTaskId2));
        DriverTask task1 = (DriverTask)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId1)).toArray()[0];
        DriverTask task2 = (DriverTask)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId2)).toArray()[0];
        Assert.assertEquals((Object)task1.getDriverTaskId(), (Object)driverTaskId1);
        Assert.assertEquals((Object)task2.getDriverTaskId(), (Object)driverTaskId2);
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task1.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task2.getStatus());
        IDriver mockDriver3 = (IDriver)Mockito.mock(IDriver.class);
        FragmentInstanceId instanceId3 = new FragmentInstanceId(fragmentId, "inst-2");
        DriverTaskId driverTaskId3 = new DriverTaskId(instanceId3, 0);
        Mockito.when((Object)mockDriver3.getDriverTaskId()).thenReturn((Object)driverTaskId3);
        Mockito.when((Object)mockDriver3.getDriverContext()).thenReturn((Object)new DriverContext());
        this.manager.submitDrivers(queryId, Collections.singletonList(mockDriver3), QUERY_TIMEOUT_MS, null);
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)1L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)3L, (long)((Map)this.manager.getQueryMap().get(queryId)).size());
        Assert.assertEquals((long)2L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)3L, (long)this.manager.getReadyQueue().size());
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)driverTaskId3));
        DriverTask task3 = (DriverTask)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId3)).toArray()[0];
        Assert.assertEquals((Object)task3.getDriverTaskId(), (Object)driverTaskId3);
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task3.getStatus());
        QueryId queryId2 = new QueryId("test2");
        PlanFragmentId fragmentId2 = new PlanFragmentId(queryId2, 0);
        FragmentInstanceId instanceId4 = new FragmentInstanceId(fragmentId2, "inst-0");
        DriverTaskId driverTaskId4 = new DriverTaskId(instanceId4, 0);
        IDriver mockDriver4 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver4.getDriverTaskId()).thenReturn((Object)driverTaskId4);
        Mockito.when((Object)mockDriver4.getDriverContext()).thenReturn((Object)new DriverContext());
        this.manager.submitDrivers(queryId2, Collections.singletonList(mockDriver4), QUERY_TIMEOUT_MS, null);
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)2L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId2));
        Assert.assertEquals((long)1L, (long)((Map)this.manager.getQueryMap().get(queryId2)).size());
        Assert.assertEquals((long)3L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)4L, (long)this.manager.getReadyQueue().size());
        DriverTask task4 = (DriverTask)this.manager.getTimeoutQueue().get((ID)driverTaskId4);
        Assert.assertNotNull((Object)task4);
        Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId2)).get(instanceId4)).contains(task4));
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task4.getStatus());
        Mockito.reset((Object[])new IDriver[]{mockDriver1});
        Mockito.when((Object)mockDriver1.getDriverTaskId()).thenReturn((Object)driverTaskId1);
        this.manager.abortFragmentInstance(instanceId1);
        ((IMPPDataExchangeManager)Mockito.verify((Object)mockMPPDataExchangeManager, (VerificationMode)Mockito.times((int)1))).forceDeregisterFragmentInstance((TFragmentInstanceId)Mockito.any());
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)2L, (long)this.manager.getQueryMap().size());
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)3L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)3L, (long)this.manager.getReadyQueue().size());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task1.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task2.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task3.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task4.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
        Assert.assertEquals((Object)" called", (Object)task1.getAbortCause());
        Mockito.reset((Object[])new IMPPDataExchangeManager[]{mockMPPDataExchangeManager});
        Mockito.reset((Object[])new IDriver[]{mockDriver1});
        Mockito.when((Object)mockDriver1.getDriverTaskId()).thenReturn((Object)driverTaskId1);
        Mockito.reset((Object[])new IDriver[]{mockDriver2});
        Mockito.when((Object)mockDriver2.getDriverTaskId()).thenReturn((Object)driverTaskId2);
        Mockito.reset((Object[])new IDriver[]{mockDriver3});
        Mockito.when((Object)mockDriver3.getDriverTaskId()).thenReturn((Object)driverTaskId3);
        this.manager.abortQuery(queryId);
        ((IMPPDataExchangeManager)Mockito.verify((Object)mockMPPDataExchangeManager, (VerificationMode)Mockito.times((int)2))).forceDeregisterFragmentInstance((TFragmentInstanceId)Mockito.any());
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().isEmpty());
        Assert.assertEquals((long)1L, (long)this.manager.getQueryMap().size());
        Assert.assertFalse((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertEquals((long)1L, (long)this.manager.getTimeoutQueue().size());
        Assert.assertEquals((long)1L, (long)this.manager.getReadyQueue().size());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task1.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task2.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)task3.getStatus());
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)task4.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver2, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver3, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver4, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        Assert.assertEquals((Object)"query cascading aborted", (Object)task2.getAbortCause());
        Assert.assertEquals((Object)"query cascading aborted", (Object)task3.getAbortCause());
        Assert.assertNull((Object)task4.getAbortCause());
    }
}

