/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.IDriver;
import org.apache.iotdb.db.queryengine.execution.exchange.IMPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.queryengine.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.ID;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.DriverTaskHandle;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.MultilevelPriorityQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskId;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskStatus;
import org.apache.iotdb.db.utils.stats.CpuTimer;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultDriverSchedulerTest {
    private final DriverScheduler manager = DriverScheduler.getInstance();
    private ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test");

    @After
    public void tearDown() throws IOException {
        this.clear();
    }

    @Test
    public void testBlockedToReady() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(1, (MultilevelPriorityQueue)this.manager.getReadyQueue(), OptionalInt.of(Integer.MAX_VALUE));
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        DriverTaskId driverTaskID = new DriverTaskId(instanceId, 0);
        Mockito.when((Object)mockDriver.getDriverTaskId()).thenReturn((Object)driverTaskID);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.READY, DriverTaskStatus.RUNNING}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status, driverTaskHandle, 0L, false);
            this.manager.getBlockedTasks().add(testTask);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
            fragmentRelatedTask.put(instanceId, taskSet);
            this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.blockedToReady(testTask);
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertTrue((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.BLOCKED, driverTaskHandle, 0L, false);
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        Mockito.when((Object)testTask.getDriver().getDriverContext()).thenReturn((Object)driverContext);
        this.manager.getBlockedTasks().add(testTask);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
        fragmentRelatedTask.put(instanceId, taskSet);
        this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        defaultScheduler.blockedToReady(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testReadyToRunning() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(1, (MultilevelPriorityQueue)this.manager.getReadyQueue(), OptionalInt.of(Integer.MAX_VALUE));
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        DriverTaskId driverTaskID = new DriverTaskId(instanceId, 0);
        Mockito.when((Object)mockDriver.getDriverTaskId()).thenReturn((Object)driverTaskID);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.RUNNING}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status, driverTaskHandle, 0L, false);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
            fragmentRelatedTask.put(instanceId, taskSet);
            this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.readyToRunning(testTask);
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.READY, driverTaskHandle, 0L, false);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
        fragmentRelatedTask.put(instanceId, taskSet);
        this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        Mockito.when((Object)testTask.getDriver().getDriverContext()).thenReturn((Object)driverContext);
        defaultScheduler.readyToRunning(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.RUNNING, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testRunningToReady() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(1, (MultilevelPriorityQueue)this.manager.getReadyQueue(), OptionalInt.of(Integer.MAX_VALUE));
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        DriverTaskId driverTaskID = new DriverTaskId(instanceId, 0);
        Mockito.when((Object)mockDriver.getDriverTaskId()).thenReturn((Object)driverTaskID);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.READY}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status, driverTaskHandle, 0L, false);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
            fragmentRelatedTask.put(instanceId, taskSet);
            this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.runningToReady(testTask, new ExecutionContext());
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.RUNNING, driverTaskHandle, 0L, false);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
        fragmentRelatedTask.put(instanceId, taskSet);
        this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        ExecutionContext context = new ExecutionContext();
        context.setTimeSlice(new Duration(1.0, TimeUnit.SECONDS));
        context.setCpuDuration(new CpuTimer.CpuDuration());
        defaultScheduler.runningToReady(testTask, context);
        Assert.assertEquals((Object)DriverTaskStatus.READY, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testRunningToBlocked() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(1, (MultilevelPriorityQueue)this.manager.getReadyQueue(), OptionalInt.of(Integer.MAX_VALUE));
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        DriverTaskId driverTaskID = new DriverTaskId(instanceId, 0);
        Mockito.when((Object)mockDriver.getDriverTaskId()).thenReturn((Object)driverTaskID);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.READY}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status, driverTaskHandle, 0L, false);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
            fragmentRelatedTask.put(instanceId, taskSet);
            this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.runningToBlocked(testTask, new ExecutionContext());
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.RUNNING, driverTaskHandle, 0L, false);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
        fragmentRelatedTask.put(instanceId, taskSet);
        this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        ExecutionContext context = new ExecutionContext();
        context.setTimeSlice(new Duration(1.0, TimeUnit.SECONDS));
        context.setCpuDuration(new CpuTimer.CpuDuration());
        defaultScheduler.runningToBlocked(testTask, context);
        Assert.assertEquals((Object)DriverTaskStatus.BLOCKED, (Object)testTask.getStatus());
        Assert.assertTrue((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
        Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
        Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testRunningToFinished() {
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(1, (MultilevelPriorityQueue)this.manager.getReadyQueue(), OptionalInt.of(Integer.MAX_VALUE));
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        DriverTaskId driverTaskID = new DriverTaskId(instanceId, 0);
        Mockito.when((Object)mockDriver.getDriverTaskId()).thenReturn((Object)driverTaskID);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED, DriverTaskStatus.BLOCKED, DriverTaskStatus.READY}) {
            DriverTask testTask = new DriverTask(mockDriver, 100L, status, driverTaskHandle, 0L, false);
            HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
            taskSet.add(testTask);
            ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
            fragmentRelatedTask.put(instanceId, taskSet);
            this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
            defaultScheduler.runningToFinished(testTask, new ExecutionContext());
            Assert.assertEquals((Object)status, (Object)testTask.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId)).contains(testTask));
            this.clear();
        }
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.RUNNING, driverTaskHandle, 0L, false);
        HashSet<DriverTask> taskSet = new HashSet<DriverTask>();
        taskSet.add(testTask);
        ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
        fragmentRelatedTask.put(instanceId, taskSet);
        this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
        this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask);
        ExecutionContext context = new ExecutionContext();
        context.setTimeSlice(new Duration(1.0, TimeUnit.SECONDS));
        context.setCpuDuration(new CpuTimer.CpuDuration());
        defaultScheduler.runningToFinished(testTask, context);
        Assert.assertEquals((Object)DriverTaskStatus.FINISHED, (Object)testTask.getStatus());
        Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask));
        Assert.assertNull((Object)this.manager.getTimeoutQueue().get((ID)testTask.getDriverTaskId()));
        Assert.assertFalse((boolean)this.manager.getQueryMap().containsKey(queryId));
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        this.clear();
    }

    @Test
    public void testToAbort() {
        DriverTaskStatus[] validStates;
        DriverTaskStatus[] invalidStates;
        IMPPDataExchangeManager mockMPPDataExchangeManager = (IMPPDataExchangeManager)Mockito.mock(IMPPDataExchangeManager.class);
        this.manager.setBlockManager(mockMPPDataExchangeManager);
        IDataNodeRPCService.Client mockMppServiceClient = (IDataNodeRPCService.Client)Mockito.mock(IDataNodeRPCService.Client.class);
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(1, (MultilevelPriorityQueue)this.manager.getReadyQueue(), OptionalInt.of(Integer.MAX_VALUE));
        ITaskScheduler defaultScheduler = this.manager.getScheduler();
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId1 = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-0");
        DriverTaskId driverTaskId1 = new DriverTaskId(instanceId1, 0);
        IDriver mockDriver1 = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver1.getDriverTaskId()).thenReturn((Object)driverTaskId1);
        IDriver mockDriver2 = (IDriver)Mockito.mock(IDriver.class);
        FragmentInstanceId instanceId2 = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "inst-1");
        DriverTaskId driverTaskId2 = new DriverTaskId(instanceId2, 0);
        Mockito.when((Object)mockDriver2.getDriverTaskId()).thenReturn((Object)driverTaskId2);
        for (DriverTaskStatus status : invalidStates = new DriverTaskStatus[]{DriverTaskStatus.FINISHED, DriverTaskStatus.ABORTED}) {
            DriverTask testTask1 = new DriverTask(mockDriver1, 100L, status, driverTaskHandle, 0L, false);
            DriverTask testTask2 = new DriverTask(mockDriver2, 100L, DriverTaskStatus.BLOCKED, driverTaskHandle, 0L, false);
            HashSet<DriverTask> taskSet1 = new HashSet<DriverTask>();
            taskSet1.add(testTask1);
            HashSet<DriverTask> taskSet2 = new HashSet<DriverTask>();
            taskSet2.add(testTask2);
            ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
            fragmentRelatedTask.put(instanceId1, taskSet1);
            fragmentRelatedTask.put(instanceId2, taskSet2);
            this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask1);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask2);
            this.manager.getBlockedTasks().add(testTask2);
            defaultScheduler.toAborted(testTask1);
            Assert.assertEquals((Object)status, (Object)testTask1.getStatus());
            Assert.assertEquals((Object)DriverTaskStatus.BLOCKED, (Object)testTask2.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask1));
            Assert.assertTrue((boolean)this.manager.getBlockedTasks().contains(testTask2));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask1.getDriverTaskId()));
            Assert.assertNotNull((Object)this.manager.getTimeoutQueue().get((ID)testTask2.getDriverTaskId()));
            Assert.assertTrue((boolean)this.manager.getQueryMap().containsKey(queryId));
            Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId1)).contains(testTask1));
            Assert.assertTrue((boolean)((Set)((Map)this.manager.getQueryMap().get(queryId)).get(instanceId2)).contains(testTask2));
            ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
            ((IDriver)Mockito.verify((Object)mockDriver2, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
            this.clear();
        }
        for (DriverTaskStatus status : validStates = new DriverTaskStatus[]{DriverTaskStatus.RUNNING, DriverTaskStatus.READY, DriverTaskStatus.BLOCKED}) {
            Mockito.reset((Object[])new IDriver[]{mockDriver1});
            Mockito.when((Object)mockDriver1.getDriverTaskId()).thenReturn((Object)driverTaskId1);
            Mockito.reset((Object[])new IDriver[]{mockDriver2});
            Mockito.when((Object)mockDriver2.getDriverTaskId()).thenReturn((Object)driverTaskId2);
            DriverTask testTask1 = new DriverTask(mockDriver1, 100L, status, driverTaskHandle, 0L, false);
            DriverTask testTask2 = new DriverTask(mockDriver2, 100L, DriverTaskStatus.BLOCKED, driverTaskHandle, 0L, false);
            HashSet<DriverTask> taskSet1 = new HashSet<DriverTask>();
            taskSet1.add(testTask1);
            HashSet<DriverTask> taskSet2 = new HashSet<DriverTask>();
            taskSet2.add(testTask2);
            ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>> fragmentRelatedTask = new ConcurrentHashMap<FragmentInstanceId, HashSet<DriverTask>>();
            fragmentRelatedTask.put(instanceId1, taskSet1);
            fragmentRelatedTask.put(instanceId2, taskSet2);
            this.manager.getQueryMap().put(queryId, fragmentRelatedTask);
            this.manager.getTimeoutQueue().push((IDIndexedAccessible)testTask1);
            defaultScheduler.toAborted(testTask1);
            Mockito.reset((Object[])new IDataNodeRPCService.Client[]{mockMppServiceClient});
            ((IMPPDataExchangeManager)Mockito.verify((Object)mockMPPDataExchangeManager, (VerificationMode)Mockito.times((int)2))).forceDeregisterFragmentInstance((TFragmentInstanceId)Mockito.any());
            Mockito.reset((Object[])new IMPPDataExchangeManager[]{mockMPPDataExchangeManager});
            Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)testTask1.getStatus());
            Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)testTask2.getStatus());
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask1));
            Assert.assertFalse((boolean)this.manager.getBlockedTasks().contains(testTask2));
            Assert.assertNull((Object)this.manager.getTimeoutQueue().get((ID)testTask1.getDriverTaskId()));
            Assert.assertNull((Object)this.manager.getTimeoutQueue().get((ID)testTask2.getDriverTaskId()));
            Assert.assertFalse((boolean)this.manager.getQueryMap().containsKey(queryId));
            ((IDriver)Mockito.verify((Object)mockDriver1, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
            ((IDriver)Mockito.verify((Object)mockDriver2, (VerificationMode)Mockito.times((int)1))).failed((Throwable)Mockito.any());
            this.clear();
        }
    }

    private void clear() {
        this.manager.getQueryMap().clear();
        this.manager.getBlockedTasks().clear();
        this.manager.getReadyQueue().clear();
        this.manager.getTimeoutQueue().clear();
    }
}

