/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.sink;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelIndex;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ShuffleSinkHandle;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.sink.IdentitySinkOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class IdentitySinkOperatorTest {
    private static final String IDENTITY_SINK_TEST = "root.identitySinkTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, IDENTITY_SINK_TEST);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            int i;
            TsBlock tsBlock;
            TsBlock identityTsBlock;
            MeasurementPath measurementPath1 = new MeasurementPath("root.identitySinkTest.device0.sensor0", TSDataType.INT32);
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(3, new PlanNodeId("3"), IdentitySinkOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId5, SeriesScanOperator.class.getSimpleName());
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors(allSensors);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(1000.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath2 = new MeasurementPath("root.identitySinkTest.device0.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(1000.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath3 = new MeasurementPath("root.identitySinkTest.device0.sensor0", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(3), planNodeId4, (PartialPath)measurementPath3, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(1000.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath4 = new MeasurementPath("root.identitySinkTest.device0.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator4 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(4), planNodeId5, (PartialPath)measurementPath4, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator4.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator4.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(1000.0, TimeUnit.MILLISECONDS));
            ISinkHandle sinkHandle = (ISinkHandle)Mockito.mock(ShuffleSinkHandle.class);
            Mockito.when((Object)sinkHandle.isChannelClosed(0)).thenReturn((Object)false);
            Mockito.when((Object)sinkHandle.isChannelClosed(1)).thenReturn((Object)false);
            IdentitySinkOperator identitySinkOperator = new IdentitySinkOperator((OperatorContext)driverContext.getOperatorContexts().get(2), Arrays.asList(seriesScanOperator1, seriesScanOperator2), new DownStreamChannelIndex(0), sinkHandle);
            identitySinkOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(1200.0, TimeUnit.MILLISECONDS));
            Assert.assertEquals((long)seriesScanOperator3.calculateMaxPeekMemory(), (long)identitySinkOperator.calculateMaxPeekMemory());
            Assert.assertEquals((long)seriesScanOperator3.calculateMaxReturnSize(), (long)identitySinkOperator.calculateMaxReturnSize());
            while (seriesScanOperator3.hasNext() && identitySinkOperator.isBlocked().isDone() && identitySinkOperator.hasNext()) {
                identityTsBlock = seriesScanOperator3.next();
                tsBlock = identitySinkOperator.next();
                if (tsBlock == null) continue;
                Assert.assertEquals((long)1L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof IntColumn));
                Assert.assertNotNull((Object)identityTsBlock);
                Assert.assertEquals((long)identityTsBlock.getPositionCount(), (long)tsBlock.getPositionCount());
                for (i = 0; i < identityTsBlock.getPositionCount(); ++i) {
                    Assert.assertEquals((long)identityTsBlock.getColumn(0).getInt(i), (long)tsBlock.getColumn(0).getInt(i));
                }
            }
            while (seriesScanOperator4.hasNext() && identitySinkOperator.isBlocked().isDone() && identitySinkOperator.hasNext()) {
                identityTsBlock = seriesScanOperator4.next();
                tsBlock = identitySinkOperator.next();
                if (tsBlock == null) continue;
                Assert.assertEquals((long)1L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof IntColumn));
                Assert.assertNotNull((Object)identityTsBlock);
                Assert.assertEquals((long)identityTsBlock.getPositionCount(), (long)tsBlock.getPositionCount());
                for (i = 0; i < identityTsBlock.getPositionCount(); ++i) {
                    Assert.assertEquals((long)identityTsBlock.getColumn(0).getInt(i), (long)tsBlock.getColumn(0).getInt(i));
                }
            }
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

