/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaOperatorTestUtil;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.SchemaSourceFactory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SchemaQueryScanOperatorTest {
    private static final String META_SCAN_OPERATOR_TEST_SG = "root.MetaScanOperatorTest";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeviceSchemaScan() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = driverContext.addOperatorContext(1, planNodeId, SchemaQueryScanOperator.class.getSimpleName());
            PartialPath partialPath = new PartialPath("root.MetaScanOperatorTest.device0");
            ISchemaRegion schemaRegion = (ISchemaRegion)Mockito.mock(ISchemaRegion.class);
            Mockito.when((Object)schemaRegion.getDatabaseFullPath()).thenReturn((Object)META_SCAN_OPERATOR_TEST_SG);
            IDeviceSchemaInfo deviceSchemaInfo = (IDeviceSchemaInfo)Mockito.mock(IDeviceSchemaInfo.class);
            Mockito.when((Object)deviceSchemaInfo.getFullPath()).thenReturn((Object)"root.MetaScanOperatorTest.device0");
            Mockito.when((Object)deviceSchemaInfo.isAligned()).thenReturn((Object)false);
            Mockito.when((Object)deviceSchemaInfo.getTemplateId()).thenReturn((Object)-1);
            operatorContext.setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion, 0));
            ISchemaSource deviceSchemaSource = SchemaSourceFactory.getDeviceSchemaSource((PartialPath)partialPath, (boolean)false, (long)10L, (long)0L, (boolean)true, null, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE);
            SchemaOperatorTestUtil.mockGetSchemaReader(deviceSchemaSource, Collections.singletonList(deviceSchemaInfo).iterator(), schemaRegion, true);
            List columns = deviceSchemaSource.getInfoQueryColumnHeaders();
            SchemaQueryScanOperator devicesSchemaScanOperator = new SchemaQueryScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), deviceSchemaSource);
            while (devicesSchemaScanOperator.hasNext()) {
                TsBlock tsBlock = devicesSchemaScanOperator.next();
                Assert.assertEquals((long)4L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof BinaryColumn));
                Assert.assertEquals((long)1L, (long)tsBlock.getPositionCount());
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    Assert.assertEquals((long)0L, (long)tsBlock.getTimeByIndex(i));
                    block15: for (int j = 0; j < columns.size(); ++j) {
                        switch (j) {
                            case 0: {
                                Assert.assertEquals((Object)tsBlock.getColumn(j).getBinary(i).toString(), (Object)"root.MetaScanOperatorTest.device0");
                                continue block15;
                            }
                            case 1: {
                                Assert.assertEquals((Object)tsBlock.getColumn(j).getBinary(i).toString(), (Object)META_SCAN_OPERATOR_TEST_SG);
                                continue block15;
                            }
                            case 2: {
                                Assert.assertEquals((Object)"false", (Object)tsBlock.getColumn(j).getBinary(i).toString());
                                continue block15;
                            }
                            case 3: {
                                Assert.assertNull((Object)tsBlock.getColumn(j).getBinary(i));
                                continue block15;
                            }
                        }
                    }
                }
            }
            SchemaOperatorTestUtil.mockGetSchemaReader(deviceSchemaSource, Collections.singletonList(deviceSchemaInfo).iterator(), schemaRegion, false);
            try {
                SchemaQueryScanOperator devicesSchemaScanOperatorFailure = new SchemaQueryScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), deviceSchemaSource);
                while (devicesSchemaScanOperatorFailure.hasNext()) {
                    devicesSchemaScanOperatorFailure.next();
                }
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ExceptionMessage"));
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeSeriesSchemaScan() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = driverContext.addOperatorContext(1, planNodeId, SchemaQueryScanOperator.class.getSimpleName());
            PartialPath partialPath = new PartialPath("root.MetaScanOperatorTest.device0.*");
            ArrayList<ITimeSeriesSchemaInfo> showTimeSeriesResults = new ArrayList<ITimeSeriesSchemaInfo>();
            for (int i = 0; i < 10; ++i) {
                ITimeSeriesSchemaInfo timeSeriesSchemaInfo = (ITimeSeriesSchemaInfo)Mockito.mock(ITimeSeriesSchemaInfo.class);
                Mockito.when((Object)timeSeriesSchemaInfo.getFullPath()).thenReturn((Object)("root.MetaScanOperatorTest.device0.s" + i));
                Mockito.when((Object)timeSeriesSchemaInfo.getAlias()).thenReturn(null);
                Mockito.when((Object)timeSeriesSchemaInfo.getSchema()).thenReturn((Object)new MeasurementSchema("s" + i, TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED));
                Mockito.when((Object)timeSeriesSchemaInfo.getTags()).thenReturn(null);
                Mockito.when((Object)timeSeriesSchemaInfo.getAttributes()).thenReturn(null);
                showTimeSeriesResults.add(timeSeriesSchemaInfo);
            }
            ISchemaRegion schemaRegion = (ISchemaRegion)Mockito.mock(ISchemaRegion.class);
            Mockito.when((Object)schemaRegion.getDatabaseFullPath()).thenReturn((Object)META_SCAN_OPERATOR_TEST_SG);
            operatorContext.setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion, 0));
            ISchemaSource timeSeriesSchemaSource = SchemaSourceFactory.getTimeSeriesSchemaScanSource((PartialPath)partialPath, (boolean)false, (long)10L, (long)0L, null, Collections.emptyMap(), (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE);
            SchemaOperatorTestUtil.mockGetSchemaReader(timeSeriesSchemaSource, showTimeSeriesResults.iterator(), schemaRegion, true);
            SchemaQueryScanOperator timeSeriesMetaScanOperator = new SchemaQueryScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), timeSeriesSchemaSource);
            while (timeSeriesMetaScanOperator.hasNext()) {
                TsBlock tsBlock = timeSeriesMetaScanOperator.next();
                Assert.assertEquals((long)ColumnHeaderConstant.showTimeSeriesColumnHeaders.size(), (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof BinaryColumn));
                Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    Assert.assertEquals((long)0L, (long)tsBlock.getTimeByIndex(i));
                    block19: for (int j = 0; j < ColumnHeaderConstant.showTimeSeriesColumnHeaders.size(); ++j) {
                        Binary binary = tsBlock.getColumn(j).isNull(i) ? null : tsBlock.getColumn(j).getBinary(i);
                        String value = binary == null ? "null" : binary.toString();
                        switch (j) {
                            case 0: {
                                Assert.assertTrue((boolean)value.startsWith("root.MetaScanOperatorTest.device0"));
                                continue block19;
                            }
                            case 1: {
                                Assert.assertEquals((Object)"null", (Object)value);
                                continue block19;
                            }
                            case 2: {
                                Assert.assertEquals((Object)META_SCAN_OPERATOR_TEST_SG, (Object)value);
                                continue block19;
                            }
                            case 3: {
                                Assert.assertEquals((Object)TSDataType.INT32.toString(), (Object)value);
                                continue block19;
                            }
                            case 4: {
                                Assert.assertEquals((Object)TSEncoding.PLAIN.toString(), (Object)value);
                                continue block19;
                            }
                            case 5: {
                                Assert.assertEquals((Object)CompressionType.UNCOMPRESSED.toString(), (Object)value);
                                continue block19;
                            }
                            case 6: 
                            case 7: {
                                Assert.assertEquals((Object)"null", (Object)value);
                            }
                        }
                    }
                }
            }
            SchemaOperatorTestUtil.mockGetSchemaReader(timeSeriesSchemaSource, showTimeSeriesResults.iterator(), schemaRegion, false);
            try {
                SchemaQueryScanOperator timeSeriesMetaScanOperatorFailure = new SchemaQueryScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), timeSeriesSchemaSource);
                while (timeSeriesMetaScanOperatorFailure.hasNext()) {
                    timeSeriesMetaScanOperatorFailure.next();
                }
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ExceptionMessage"));
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

