/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ISchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.mockito.Mockito;

public class SchemaOperatorTestUtil {
    public static final String EXCEPTION_MESSAGE = "ExceptionMessage";

    public static <T extends ISchemaInfo> void mockGetSchemaReader(ISchemaSource<T> schemaSource, final Iterator<T> iterator, ISchemaRegion schemaRegion, final boolean isSuccess) {
        Mockito.when((Object)schemaSource.getSchemaReader(schemaRegion)).thenReturn((Object)new ISchemaReader<T>(){

            public boolean isSuccess() {
                return isSuccess;
            }

            public Throwable getFailure() {
                return isSuccess ? null : new MetadataException(SchemaOperatorTestUtil.EXCEPTION_MESSAGE);
            }

            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public void close() {
            }

            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (ISchemaInfo)iterator.next();
            }
        });
    }
}

