/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaFetchScanOperator;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SchemaFetchScanOperatorTest {
    @Test
    public void testSchemaFetchResult() throws Exception {
        ISchemaRegion schemaRegion = this.mockSchemaRegion();
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.status"));
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        SchemaFetchScanOperator schemaFetchScanOperator = new SchemaFetchScanOperator(null, null, patternTree, Collections.emptyMap(), schemaRegion, false, true);
        Assert.assertTrue((boolean)schemaFetchScanOperator.hasNext());
        TsBlock tsBlock = schemaFetchScanOperator.next();
        Assert.assertFalse((boolean)schemaFetchScanOperator.hasNext());
        Binary binary = tsBlock.getColumn(0).getBinary(0);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(binary.getValues());
        Assert.assertEquals((long)1L, (long)ReadWriteIOUtils.readByte((InputStream)inputStream));
        ClusterSchemaTree schemaTree = ClusterSchemaTree.deserialize((InputStream)inputStream);
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(new PartialPath("root.sg.d2.a"), Arrays.asList("s1", "status"));
        Assert.assertTrue((boolean)deviceSchemaInfo.isAligned());
        List measurementSchemaList = deviceSchemaInfo.getMeasurementSchemaList();
        Assert.assertEquals((long)2L, (long)measurementSchemaList.size());
        Assert.assertEquals(Arrays.asList("s1", "s2"), measurementSchemaList.stream().map(IMeasurementSchema::getMeasurementId).sorted().collect(Collectors.toList()));
        Pair pair = schemaTree.searchMeasurementPaths(new PartialPath("root.sg.**.status"), 0, 0, false);
        Assert.assertEquals((long)3L, (long)((List)pair.left).size());
        Assert.assertEquals(Arrays.asList("root.sg.d1.s2", "root.sg.d2.a.s2", "root.sg.d2.s2"), ((List)pair.left).stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
    }

    private ISchemaRegion mockSchemaRegion() throws Exception {
        ISchemaRegion schemaRegion = (ISchemaRegion)Mockito.mock(ISchemaRegion.class);
        MeasurementPath d1s1 = new MeasurementPath(new PartialPath("root.sg.d1.s1"), (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null), Boolean.valueOf(false));
        MeasurementPath d1s2 = new MeasurementPath(new PartialPath("root.sg.d1.s2"), (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null), Boolean.valueOf(false));
        d1s2.setMeasurementAlias("status");
        MeasurementPath d2s1 = new MeasurementPath(new PartialPath("root.sg.d2.s1"), (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null), Boolean.valueOf(false));
        MeasurementPath d2s2 = new MeasurementPath(new PartialPath("root.sg.d2.s2"), (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null), Boolean.valueOf(false));
        d2s2.setMeasurementAlias("status");
        MeasurementPath d2as1 = new MeasurementPath(new PartialPath("root.sg.d2.a.s1"), (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null), Boolean.valueOf(true));
        MeasurementPath d2as2 = new MeasurementPath(new PartialPath("root.sg.d2.a.s2"), (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null), Boolean.valueOf(true));
        d2as2.setMeasurementAlias("status");
        ClusterSchemaTree clusterSchemaTree = new ClusterSchemaTree();
        clusterSchemaTree.appendSingleMeasurementPath(d1s2);
        clusterSchemaTree.appendSingleMeasurementPath(d2as2);
        clusterSchemaTree.appendSingleMeasurementPath(d2s2);
        clusterSchemaTree.appendSingleMeasurementPath(d1s1);
        clusterSchemaTree.appendSingleMeasurementPath(d2as1);
        clusterSchemaTree.appendSingleMeasurementPath(d2s1);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.status"));
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        Mockito.when((Object)schemaRegion.fetchSchema(patternTree, Collections.emptyMap(), false, true)).thenReturn((Object)clusterSchemaTree);
        return schemaRegion;
    }
}

