/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.schema.CountGroupByLevelScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaCountOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaOperatorTestUtil;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ISchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SchemaCountOperatorTest {
    private static final String SCHEMA_COUNT_OPERATOR_TEST_SG = "root.SchemaCountOperatorTest";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaCountOperator() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            ISchemaRegion schemaRegion = (ISchemaRegion)Mockito.mock(ISchemaRegion.class);
            OperatorContext operatorContext = driverContext.addOperatorContext(1, planNodeId, SchemaCountOperator.class.getSimpleName());
            operatorContext.setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion, 0));
            ISchemaSource schemaSource = (ISchemaSource)Mockito.mock(ISchemaSource.class);
            ArrayList<ISchemaInfo> schemaInfoList = new ArrayList<ISchemaInfo>(10);
            for (int i = 0; i < 10; ++i) {
                schemaInfoList.add((ISchemaInfo)Mockito.mock(ISchemaInfo.class));
            }
            SchemaOperatorTestUtil.mockGetSchemaReader(schemaSource, schemaInfoList.iterator(), schemaRegion, true);
            SchemaCountOperator schemaCountOperator = new SchemaCountOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), schemaSource);
            TsBlock tsBlock = null;
            while (schemaCountOperator.hasNext()) {
                tsBlock = schemaCountOperator.next();
            }
            Assert.assertNotNull(tsBlock);
            Assert.assertEquals((long)10L, (long)tsBlock.getColumn(0).getLong(0));
            SchemaOperatorTestUtil.mockGetSchemaReader(schemaSource, schemaInfoList.iterator(), schemaRegion, false);
            try {
                SchemaCountOperator schemaCountOperatorFailure = new SchemaCountOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), schemaSource);
                while (schemaCountOperatorFailure.hasNext()) {
                    schemaCountOperatorFailure.next();
                }
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ExceptionMessage"));
            }
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLevelTimeSeriesCountOperator() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = driverContext.addOperatorContext(1, planNodeId, CountGroupByLevelScanOperator.class.getSimpleName());
            ISchemaRegion schemaRegion = (ISchemaRegion)Mockito.mock(ISchemaRegion.class);
            operatorContext.setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion, 0));
            CountGroupByLevelScanOperator timeSeriesCountOperator = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 2, this.mockSchemaSource(schemaRegion, true));
            List<TsBlock> tsBlockList = this.collectResult(timeSeriesCountOperator);
            Assert.assertEquals((long)1L, (long)tsBlockList.size());
            TsBlock tsBlock = tsBlockList.get(0);
            for (int i = 0; i < 10; ++i) {
                String path = tsBlock.getColumn(0).getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
                Assert.assertTrue((boolean)path.startsWith("root.SchemaCountOperatorTest.device"));
                Assert.assertEquals((long)10L, (long)tsBlock.getColumn(1).getLong(i));
            }
            CountGroupByLevelScanOperator timeSeriesCountOperator2 = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 1, this.mockSchemaSource(schemaRegion, true));
            tsBlockList = this.collectResult(timeSeriesCountOperator2);
            Assert.assertEquals((long)1L, (long)tsBlockList.size());
            tsBlock = tsBlockList.get(0);
            Assert.assertEquals((long)100L, (long)tsBlock.getColumn(1).getLong(0));
            try {
                CountGroupByLevelScanOperator timeSeriesCountOperatorFailure = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 1, this.mockSchemaSource(schemaRegion, false));
                this.collectResult(timeSeriesCountOperatorFailure);
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ExceptionMessage"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    private List<TsBlock> collectResult(CountGroupByLevelScanOperator<?> operator) throws Exception {
        ArrayList<TsBlock> tsBlocks = new ArrayList<TsBlock>();
        while (operator.hasNext()) {
            TsBlock tsBlock = operator.next();
            if (tsBlock == null || tsBlock.isEmpty()) continue;
            tsBlocks.add(tsBlock);
        }
        return tsBlocks;
    }

    private ISchemaSource<ITimeSeriesSchemaInfo> mockSchemaSource(ISchemaRegion schemaRegion, boolean success) throws Exception {
        ISchemaSource schemaSource = (ISchemaSource)Mockito.mock(ISchemaSource.class);
        ArrayList<ITimeSeriesSchemaInfo> timeSeriesSchemaInfoList = new ArrayList<ITimeSeriesSchemaInfo>(1000);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                ITimeSeriesSchemaInfo timeSeriesSchemaInfo = (ITimeSeriesSchemaInfo)Mockito.mock(ITimeSeriesSchemaInfo.class);
                Mockito.when((Object)timeSeriesSchemaInfo.getPartialPath()).thenReturn((Object)new PartialPath("root.SchemaCountOperatorTest.device" + i + ".s" + j));
                timeSeriesSchemaInfoList.add(timeSeriesSchemaInfo);
            }
        }
        Iterator iterator = timeSeriesSchemaInfoList.iterator();
        SchemaOperatorTestUtil.mockGetSchemaReader(schemaSource, iterator, schemaRegion, success);
        return schemaSource;
    }
}

