/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.schema.CountGroupByLevelMergeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.CountGroupByLevelScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaOperatorTestUtil;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CountGroupByLevelMergeOperatorTest {
    private static final String OPERATOR_TEST_SG = "root.CountGroupByLevelMergeOperatorTest";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountMergeOperator() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = driverContext.addOperatorContext(1, planNodeId, CountGroupByLevelScanOperator.class.getSimpleName());
            ISchemaRegion schemaRegion = (ISchemaRegion)Mockito.mock(ISchemaRegion.class);
            operatorContext.setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion, 0));
            CountGroupByLevelScanOperator timeSeriesCountOperator1 = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 2, this.mockSchemaSource(schemaRegion, new PartialPath("root.CountGroupByLevelMergeOperatorTest.device2"), true));
            CountGroupByLevelScanOperator timeSeriesCountOperator2 = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 2, this.mockSchemaSource(schemaRegion, new PartialPath(OPERATOR_TEST_SG), true));
            CountGroupByLevelMergeOperator mergeOperator = new CountGroupByLevelMergeOperator((OperatorContext)driverContext.getOperatorContexts().get(0), Arrays.asList(timeSeriesCountOperator1, timeSeriesCountOperator2));
            Assert.assertTrue((boolean)mergeOperator.isBlocked().isDone());
            ArrayList<TsBlock> tsBlocks = new ArrayList<TsBlock>();
            while (mergeOperator.hasNext()) {
                TsBlock tsBlock = mergeOperator.next();
                if (tsBlock == null || tsBlock.isEmpty()) continue;
                tsBlocks.add(tsBlock);
            }
            Assert.assertFalse((boolean)tsBlocks.isEmpty());
            HashSet<String> pathSet = new HashSet<String>(2001);
            for (TsBlock tsBlock : tsBlocks) {
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    String path = tsBlock.getColumn(0).getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
                    pathSet.add(path);
                    Assert.assertTrue((boolean)path.startsWith(OPERATOR_TEST_SG));
                    if (path.equals("root.CountGroupByLevelMergeOperatorTest.device2")) {
                        Assert.assertEquals((long)10L, (long)tsBlock.getColumn(1).getLong(i));
                        continue;
                    }
                    Assert.assertEquals((long)1L, (long)tsBlock.getColumn(1).getLong(i));
                }
            }
            Assert.assertEquals((long)2001L, (long)pathSet.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountScanOperator() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = driverContext.addOperatorContext(1, planNodeId, CountGroupByLevelScanOperator.class.getSimpleName());
            ISchemaRegion schemaRegion = (ISchemaRegion)Mockito.mock(ISchemaRegion.class);
            operatorContext.setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion, 0));
            CountGroupByLevelScanOperator timeSeriesCountOperator = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 2, this.mockSchemaSource(schemaRegion, new PartialPath(OPERATOR_TEST_SG), true));
            TsBlock tsBlock = null;
            while (timeSeriesCountOperator.hasNext()) {
                tsBlock = timeSeriesCountOperator.next();
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    Assert.assertEquals((long)1L, (long)tsBlock.getColumn(1).getLong(i));
                }
            }
            Assert.assertNotNull(tsBlock);
            CountGroupByLevelScanOperator timeSeriesCountOperatorFailure = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 2, this.mockSchemaSource(schemaRegion, new PartialPath(OPERATOR_TEST_SG), false));
            try {
                while (timeSeriesCountOperatorFailure.hasNext()) {
                    timeSeriesCountOperatorFailure.next();
                }
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ExceptionMessage"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    private ISchemaSource<ITimeSeriesSchemaInfo> mockSchemaSource(ISchemaRegion schemaRegion, PartialPath path, boolean success) throws Exception {
        ISchemaSource schemaSource = (ISchemaSource)Mockito.mock(ISchemaSource.class);
        if (path.equals((Object)new PartialPath("root.CountGroupByLevelMergeOperatorTest.device2"))) {
            this.mockSchemaReader((ISchemaSource<ITimeSeriesSchemaInfo>)schemaSource, schemaRegion, 10, "root.CountGroupByLevelMergeOperatorTest.device2", success);
        } else if (path.equals((Object)new PartialPath(OPERATOR_TEST_SG))) {
            this.mockSchemaReader((ISchemaSource<ITimeSeriesSchemaInfo>)schemaSource, schemaRegion, 2000, OPERATOR_TEST_SG, success);
        }
        return schemaSource;
    }

    private void mockSchemaReader(ISchemaSource<ITimeSeriesSchemaInfo> schemaSource, ISchemaRegion schemaRegion, int expectedNum, String prefix, boolean success) throws IllegalPathException {
        ArrayList<ITimeSeriesSchemaInfo> timeSeriesSchemaInfoList = new ArrayList<ITimeSeriesSchemaInfo>(expectedNum);
        for (int i = 0; i < expectedNum; ++i) {
            ITimeSeriesSchemaInfo timeSeriesSchemaInfo = (ITimeSeriesSchemaInfo)Mockito.mock(ITimeSeriesSchemaInfo.class);
            Mockito.when((Object)timeSeriesSchemaInfo.getPartialPath()).thenReturn((Object)new PartialPath(prefix + ".d" + i + ".s"));
            timeSeriesSchemaInfoList.add(timeSeriesSchemaInfo);
        }
        Iterator iterator = timeSeriesSchemaInfoList.iterator();
        SchemaOperatorTestUtil.mockGetSchemaReader(schemaSource, iterator, schemaRegion, success);
    }
}

