/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.LeftOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LeftOuterTimeJoinOperatorTest {
    @Test
    public void testLeftOuterJoin1() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1.0, TimeUnit.SECONDS));
        Operator leftChild = new Operator(){
            private final long[][] timeArray = new long[][]{{4L, 6L, 9L}, {13L, 17L}, {22L, 25L}};
            private final int[][] valueArray = new int[][]{{4, 6, 9}, {13, 17}, {22, 25}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false}, {false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Collections.singletonList(TSDataType.INT32));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeInt(this.valueArray[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 3;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 3;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator rightChild = new Operator(){
            private final long[][] timeArray = new long[][]{{1L, 2L, 3L}, {4L, 5L, 10L}, {13L, 16L}, {26L, 27L}};
            private final long[][] valueArray = new long[][]{{10L, 20L, 30L}, {40L, 50L, 100L}, {130L, 160L}, {260L, 270L}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, false}, {false, false}, {false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Collections.singletonList(TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeLong(this.valueArray[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 4;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 4;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        LeftOuterTimeJoinOperator leftOuterTimeJoinOperator = new LeftOuterTimeJoinOperator(operatorContext, leftChild, 1, rightChild, Arrays.asList(TSDataType.INT32, TSDataType.INT64), (TimeComparator)new AscTimeComparator());
        Assert.assertEquals((long)(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes() + 131072), (long)leftOuterTimeJoinOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), (long)leftOuterTimeJoinOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)131072L, (long)leftOuterTimeJoinOperator.calculateRetainedSizeAfterCallingNext());
        long[] timeArray = new long[]{4L, 6L, 9L, 13L, 17L, 22L, 25L};
        int[] column1Array = new int[]{4, 6, 9, 13, 17, 22, 25};
        boolean[] column1IsNull = new boolean[]{false, false, false, false, false, false, false};
        long[] column2Array = new long[]{40L, 0L, 0L, 130L, 0L, 0L, 0L};
        boolean[] column2IsNull = new boolean[]{false, true, true, false, true, true, true};
        try {
            int count = 0;
            ListenableFuture listenableFuture = leftOuterTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!leftOuterTimeJoinOperator.isFinished() && leftOuterTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = leftOuterTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    int i = 0;
                    int size = tsBlock.getPositionCount();
                    while (i < size) {
                        Assert.assertEquals((long)timeArray[count], (long)tsBlock.getTimeByIndex(i));
                        Assert.assertEquals((Object)column1IsNull[count], (Object)tsBlock.getColumn(0).isNull(i));
                        if (!column1IsNull[count]) {
                            Assert.assertEquals((long)column1Array[count], (long)tsBlock.getColumn(0).getInt(i));
                        }
                        Assert.assertEquals((Object)column2IsNull[count], (Object)tsBlock.getColumn(1).isNull(i));
                        if (!column2IsNull[count]) {
                            Assert.assertEquals((long)column2Array[count], (long)tsBlock.getColumn(1).getLong(i));
                        }
                        ++i;
                        ++count;
                    }
                }
                listenableFuture = leftOuterTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)timeArray.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLeftOuterJoin2() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1.0, TimeUnit.SECONDS));
        Operator leftChild = new Operator(){
            private final long[][] timeArray = new long[][]{{25L, 22L}, null, {19L, 18L, 15L}, new long[0], {9L, 7L, 6L, 3L}, new long[0]};
            private final int[][] value1Array = new int[][]{{0, 22}, null, {19, 18, 0}, new int[0], {0, 7, 0, 3}, new int[0]};
            private final long[][] value2Array = new long[][]{{26L, 0L}, null, {20L, 0L, 16L}, new long[0], {0L, 0L, 7L, 4L}, new long[0]};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{true, false}, null, {false, false, true}, new boolean[0], {true, false, true, false}, new boolean[0]}, new boolean[][]{{false, true}, null, {false, true, false}, new boolean[0], {true, true, false, false}, new boolean[0]}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.INT32, TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeInt(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeLong(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 6;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 6;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator rightChild = new Operator(){
            private final long[][] timeArray = new long[][]{{21L, 20L}, new long[0], {19L, 18L, 15L, 14L, 8L, 7L}, null, {5L}, {4L}, {3L}, {2L, 1L}, new long[0]};
            private final float[][] value1Array = new float[][]{{210.0f, 200.0f}, new float[0], {190.0f, 180.0f, 0.0f, 0.0f, 80.0f, 0.0f}, null, {50.0f}, {40.0f}, {30.0f}, {20.0f, 10.0f}, new float[0]};
            private final boolean[][] value2Array = new boolean[][]{{false, false}, new boolean[0], {true, false, false, false, true, false}, null, {true}, {false}, {false}, {true, false}, new boolean[0]};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false}, new boolean[0], {false, false, true, true, false, true}, null, {false}, {false}, {false}, {false, false}, new boolean[0]}, new boolean[][]{{false, true}, new boolean[0], {false, true, false, true, false, false}, null, {false}, {true}, {false}, {false, false}, new boolean[0]}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeFloat(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeBoolean(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 9;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 9;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        LeftOuterTimeJoinOperator leftOuterTimeJoinOperator = new LeftOuterTimeJoinOperator(operatorContext, leftChild, 2, rightChild, Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.BOOLEAN), (TimeComparator)new DescTimeComparator());
        long[] timeArray = new long[]{25L, 22L, 19L, 18L, 15L, 9L, 7L, 6L, 3L};
        int[] column1Array = new int[]{0, 22, 19, 18, 0, 0, 7, 0, 3};
        boolean[] column1IsNull = new boolean[]{true, false, false, false, true, true, false, true, false};
        long[] column2Array = new long[]{26L, 0L, 20L, 0L, 16L, 0L, 0L, 7L, 4L};
        boolean[] column2IsNull = new boolean[]{false, true, false, true, false, true, true, false, false};
        float[] column3Array = new float[]{0.0f, 0.0f, 190.0f, 180.0f, 0.0f, 0.0f, 0.0f, 0.0f, 30.0f};
        boolean[] column3IsNull = new boolean[]{true, true, false, false, true, true, true, true, false};
        boolean[] column4Array = new boolean[]{false, false, true, false, false, false, false, false, false};
        boolean[] column4IsNull = new boolean[]{true, true, false, true, false, true, false, true, false};
        try {
            int count = 0;
            ListenableFuture listenableFuture = leftOuterTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!leftOuterTimeJoinOperator.isFinished() && leftOuterTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = leftOuterTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    int i = 0;
                    int size = tsBlock.getPositionCount();
                    while (i < size) {
                        Assert.assertEquals((long)timeArray[count], (long)tsBlock.getTimeByIndex(i));
                        Assert.assertEquals((Object)column1IsNull[count], (Object)tsBlock.getColumn(0).isNull(i));
                        if (!column1IsNull[count]) {
                            Assert.assertEquals((long)column1Array[count], (long)tsBlock.getColumn(0).getInt(i));
                        }
                        Assert.assertEquals((Object)column2IsNull[count], (Object)tsBlock.getColumn(1).isNull(i));
                        if (!column2IsNull[count]) {
                            Assert.assertEquals((long)column2Array[count], (long)tsBlock.getColumn(1).getLong(i));
                        }
                        Assert.assertEquals((Object)column3IsNull[count], (Object)tsBlock.getColumn(2).isNull(i));
                        if (!column3IsNull[count]) {
                            Assert.assertEquals((double)column3Array[count], (double)tsBlock.getColumn(2).getFloat(i), (double)1.0E-6);
                        }
                        Assert.assertEquals((Object)column4IsNull[count], (Object)tsBlock.getColumn(3).isNull(i));
                        if (!column4IsNull[count]) {
                            Assert.assertEquals((Object)column4Array[count], (Object)tsBlock.getColumn(3).getBoolean(i));
                        }
                        ++i;
                        ++count;
                    }
                }
                listenableFuture = leftOuterTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)timeArray.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLeftOuterJoin3() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1.0, TimeUnit.SECONDS));
        Operator leftChild = new Operator(){
            private final long[][] timeArray = new long[][]{{4L, 6L, 9L}, {13L, 17L}, {22L, 25L}, {100L, 101L}, {110L, 111L}};
            private final int[][] valueArray = new int[][]{{4, 6, 9}, {13, 17}, {22, 25}, {100, 101}, {110, 111}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false}, {false, false}, {false, false}, {false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Collections.singletonList(TSDataType.INT32));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeInt(this.valueArray[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 5;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 5;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator rightChild = new Operator(){
            private final long[][] timeArray = new long[][]{{1L, 2L, 3L}, {4L, 5L, 10L}, {13L, 16L}, {26L, 27L}};
            private final long[][] valueArray = new long[][]{{10L, 20L, 30L}, {40L, 50L, 100L}, {130L, 160L}, {260L, 270L}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, false}, {false, false}, {false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Collections.singletonList(TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeLong(this.valueArray[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 4;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 4;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        LeftOuterTimeJoinOperator leftOuterTimeJoinOperator = new LeftOuterTimeJoinOperator(operatorContext, leftChild, 1, rightChild, Arrays.asList(TSDataType.INT32, TSDataType.INT64), (TimeComparator)new AscTimeComparator());
        Assert.assertEquals((long)(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes() + 131072), (long)leftOuterTimeJoinOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), (long)leftOuterTimeJoinOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)131072L, (long)leftOuterTimeJoinOperator.calculateRetainedSizeAfterCallingNext());
        long[] timeArray = new long[]{4L, 6L, 9L, 13L, 17L, 22L, 25L, 100L, 101L, 110L, 111L};
        int[] column1Array = new int[]{4, 6, 9, 13, 17, 22, 25, 100, 101, 110, 111};
        boolean[] column1IsNull = new boolean[]{false, false, false, false, false, false, false, false, false, false, false};
        long[] column2Array = new long[]{40L, 0L, 0L, 130L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        boolean[] column2IsNull = new boolean[]{false, true, true, false, true, true, true, true, true, true, true};
        try {
            int count = 0;
            ListenableFuture listenableFuture = leftOuterTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!leftOuterTimeJoinOperator.isFinished() && leftOuterTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = leftOuterTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    int i = 0;
                    int size = tsBlock.getPositionCount();
                    while (i < size) {
                        Assert.assertEquals((long)timeArray[count], (long)tsBlock.getTimeByIndex(i));
                        Assert.assertEquals((Object)column1IsNull[count], (Object)tsBlock.getColumn(0).isNull(i));
                        if (!column1IsNull[count]) {
                            Assert.assertEquals((long)column1Array[count], (long)tsBlock.getColumn(0).getInt(i));
                        }
                        Assert.assertEquals((Object)column2IsNull[count], (Object)tsBlock.getColumn(1).isNull(i));
                        if (!column2IsNull[count]) {
                            Assert.assertEquals((long)column2Array[count], (long)tsBlock.getColumn(1).getLong(i));
                        }
                        ++i;
                        ++count;
                    }
                }
                listenableFuture = leftOuterTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)timeArray.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

