/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.InnerTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class InnerTimeJoinOperatorTest {
    @Test
    public void testInnerJoin1() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1.0, TimeUnit.SECONDS));
        Operator leftChild = new Operator(){
            private final long[][] timeArray = new long[][]{{4L, 6L, 9L}, {13L, 17L}, {22L, 25L}};
            private final int[][] valueArray = new int[][]{{4, 6, 9}, {13, 17}, {22, 25}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false}, {false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Collections.singletonList(TSDataType.INT32));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeInt(this.valueArray[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 3;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 3;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator rightChild = new Operator(){
            private final long[][] timeArray = new long[][]{{1L, 2L, 3L}, {4L, 5L, 10L}, {13L, 16L}, {26L, 27L}};
            private final long[][] valueArray = new long[][]{{10L, 20L, 30L}, {40L, 50L, 100L}, {130L, 160L}, {260L, 270L}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, false}, {false, false}, {false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Collections.singletonList(TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeLong(this.valueArray[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 4;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 4;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        HashMap<InputLocation, Integer> outputColumnMap = new HashMap<InputLocation, Integer>();
        outputColumnMap.put(new InputLocation(0, 0), 0);
        outputColumnMap.put(new InputLocation(1, 0), 1);
        InnerTimeJoinOperator innerTimeJoinOperator = new InnerTimeJoinOperator(operatorContext, Arrays.asList(leftChild, rightChild), Arrays.asList(TSDataType.INT32, TSDataType.INT64), (TimeComparator)new AscTimeComparator(), outputColumnMap);
        Assert.assertEquals((long)(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes() + 131072), (long)innerTimeJoinOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), (long)innerTimeJoinOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)65536L, (long)innerTimeJoinOperator.calculateRetainedSizeAfterCallingNext());
        long[] timeArray = new long[]{4L, 13L};
        int[] column1Array = new int[]{4, 13};
        boolean[] column1IsNull = new boolean[]{false, false};
        long[] column2Array = new long[]{40L, 130L};
        boolean[] column2IsNull = new boolean[]{false, false};
        try {
            int count = 0;
            ListenableFuture listenableFuture = innerTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!innerTimeJoinOperator.isFinished() && innerTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = innerTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    int i = 0;
                    int size = tsBlock.getPositionCount();
                    while (i < size) {
                        Assert.assertEquals((long)timeArray[count], (long)tsBlock.getTimeByIndex(i));
                        Assert.assertEquals((Object)column1IsNull[count], (Object)tsBlock.getColumn(0).isNull(i));
                        if (!column1IsNull[count]) {
                            Assert.assertEquals((long)column1Array[count], (long)tsBlock.getColumn(0).getInt(i));
                        }
                        Assert.assertEquals((Object)column2IsNull[count], (Object)tsBlock.getColumn(1).isNull(i));
                        if (!column2IsNull[count]) {
                            Assert.assertEquals((long)column2Array[count], (long)tsBlock.getColumn(1).getLong(i));
                        }
                        ++i;
                        ++count;
                    }
                }
                listenableFuture = innerTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)timeArray.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInnerJoin2() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1000.0, TimeUnit.SECONDS));
        Operator leftChild = new Operator(){
            private final long[][] timeArray = new long[][]{{25L, 22L}, null, {19L, 18L, 15L}, new long[0], {9L, 7L, 6L, 3L}, new long[0]};
            private final int[][] value1Array = new int[][]{{0, 22}, null, {19, 18, 0}, new int[0], {0, 7, 0, 3}, new int[0]};
            private final long[][] value2Array = new long[][]{{26L, 0L}, null, {20L, 0L, 16L}, new long[0], {0L, 0L, 7L, 4L}, new long[0]};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{true, false}, null, {false, false, true}, new boolean[0], {true, false, true, false}, new boolean[0]}, new boolean[][]{{false, true}, null, {false, true, false}, new boolean[0], {true, true, false, false}, new boolean[0]}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.INT32, TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeInt(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeLong(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 6;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 6;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator rightChild = new Operator(){
            private final long[][] timeArray = new long[][]{{21L, 20L}, new long[0], {19L, 18L, 15L, 14L, 8L, 7L}, null, {5L}, {4L}, {3L}, {2L, 1L}, new long[0]};
            private final float[][] value1Array = new float[][]{{210.0f, 200.0f}, new float[0], {190.0f, 180.0f, 0.0f, 0.0f, 80.0f, 0.0f}, null, {50.0f}, {40.0f}, {30.0f}, {20.0f, 10.0f}, new float[0]};
            private final boolean[][] value2Array = new boolean[][]{{false, false}, new boolean[0], {true, false, false, false, true, false}, null, {true}, {false}, {false}, {true, false}, new boolean[0]};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false}, new boolean[0], {false, false, true, true, false, true}, null, {false}, {false}, {false}, {false, false}, new boolean[0]}, new boolean[][]{{false, true}, new boolean[0], {false, true, false, true, false, false}, null, {false}, {true}, {false}, {false, false}, new boolean[0]}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeFloat(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeBoolean(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 9;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 9;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        HashMap<InputLocation, Integer> outputColumnMap = new HashMap<InputLocation, Integer>();
        outputColumnMap.put(new InputLocation(0, 0), 0);
        outputColumnMap.put(new InputLocation(0, 1), 1);
        outputColumnMap.put(new InputLocation(1, 0), 2);
        outputColumnMap.put(new InputLocation(1, 1), 3);
        InnerTimeJoinOperator innerTimeJoinOperator = new InnerTimeJoinOperator(operatorContext, Arrays.asList(leftChild, rightChild), Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.BOOLEAN), (TimeComparator)new DescTimeComparator(), outputColumnMap);
        long[] timeArray = new long[]{19L, 18L, 15L, 7L, 3L};
        int[] column1Array = new int[]{19, 18, 0, 7, 3};
        boolean[] column1IsNull = new boolean[]{false, false, true, false, false};
        long[] column2Array = new long[]{20L, 0L, 16L, 0L, 4L};
        boolean[] column2IsNull = new boolean[]{false, true, false, true, false};
        float[] column3Array = new float[]{190.0f, 180.0f, 0.0f, 0.0f, 30.0f};
        boolean[] column3IsNull = new boolean[]{false, false, true, true, false};
        boolean[] column4Array = new boolean[]{true, false, false, false, false};
        boolean[] column4IsNull = new boolean[]{false, true, false, false, false};
        try {
            int count = 0;
            ListenableFuture listenableFuture = innerTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!innerTimeJoinOperator.isFinished() && innerTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = innerTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    int i = 0;
                    int size = tsBlock.getPositionCount();
                    while (i < size) {
                        Assert.assertEquals((long)timeArray[count], (long)tsBlock.getTimeByIndex(i));
                        Assert.assertEquals((Object)column1IsNull[count], (Object)tsBlock.getColumn(0).isNull(i));
                        if (!column1IsNull[count]) {
                            Assert.assertEquals((long)column1Array[count], (long)tsBlock.getColumn(0).getInt(i));
                        }
                        Assert.assertEquals((Object)column2IsNull[count], (Object)tsBlock.getColumn(1).isNull(i));
                        if (!column2IsNull[count]) {
                            Assert.assertEquals((long)column2Array[count], (long)tsBlock.getColumn(1).getLong(i));
                        }
                        Assert.assertEquals((Object)column3IsNull[count], (Object)tsBlock.getColumn(2).isNull(i));
                        if (!column3IsNull[count]) {
                            Assert.assertEquals((double)column3Array[count], (double)tsBlock.getColumn(2).getFloat(i), (double)1.0E-6);
                        }
                        Assert.assertEquals((Object)column4IsNull[count], (Object)tsBlock.getColumn(3).isNull(i));
                        if (!column4IsNull[count]) {
                            Assert.assertEquals((Object)column4Array[count], (Object)tsBlock.getColumn(3).getBoolean(i));
                        }
                        ++i;
                        ++count;
                    }
                }
                listenableFuture = innerTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)timeArray.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInnerJoin3() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1000.0, TimeUnit.SECONDS));
        Operator child1 = new Operator(){
            private final long[][] timeArray = new long[][]{{100L, 90L, 80L, 70L, 60L, 50L, 40L, 30L, 20L, 10L, 0L}};
            private final int[][] value1Array = new int[][]{{100, 90, 80, 70, 60, 50, 40, 30, 20, 10, 0}};
            private final long[][] value2Array = new long[][]{{200L, 180L, 160L, 140L, 120L, 100L, 80L, 60L, 40L, 20L, 0L}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false}}, new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.INT32, TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeInt(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeLong(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 1;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 1;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator child2 = new Operator(){
            private final long[][] timeArray = new long[][]{{1000L, 500L, 100L}, {99L, 95L, 90L}, {50L, 48L, 20L, 10L}};
            private final float[][] value1Array = new float[][]{{3000.0f, 500.0f, 300.0f}, {99.0f, 95.0f, 0.0f}, {150.0f, 48.0f, 60.0f, 0.0f}};
            private final boolean[][] value2Array = new boolean[][]{{false, true, false}, {true, false, false}, {true, true, false, false}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, true}, {false, false, false, true}}, new boolean[][]{{false, false, true}, {false, true, false}, {false, false, true, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeFloat(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeBoolean(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 3;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 3;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        HashMap<InputLocation, Integer> outputColumnMap = new HashMap<InputLocation, Integer>();
        outputColumnMap.put(new InputLocation(0, 0), 0);
        outputColumnMap.put(new InputLocation(0, 1), 1);
        outputColumnMap.put(new InputLocation(1, 0), 2);
        outputColumnMap.put(new InputLocation(1, 1), 3);
        InnerTimeJoinOperator innerTimeJoinOperator = new InnerTimeJoinOperator(operatorContext, Arrays.asList(child1, child2), Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.BOOLEAN), (TimeComparator)new DescTimeComparator(), outputColumnMap);
        long[] timeArray = new long[]{100L, 90L, 50L, 20L, 10L};
        int[] column1Array = new int[]{100, 90, 50, 20, 10};
        boolean[] column1IsNull = new boolean[]{false, false, false, false, false};
        long[] column2Array = new long[]{200L, 180L, 100L, 40L, 20L};
        boolean[] column2IsNull = new boolean[]{false, false, false, false, false};
        float[] column3Array = new float[]{300.0f, 0.0f, 150.0f, 60.0f, 0.0f};
        boolean[] column3IsNull = new boolean[]{false, true, false, false, true};
        boolean[] column4Array = new boolean[]{false, false, true, false, false};
        boolean[] column4IsNull = new boolean[]{true, false, false, true, false};
        try {
            int count = 0;
            ListenableFuture listenableFuture = innerTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!innerTimeJoinOperator.isFinished() && innerTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = innerTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    int i = 0;
                    int size = tsBlock.getPositionCount();
                    while (i < size) {
                        Assert.assertEquals((long)timeArray[count], (long)tsBlock.getTimeByIndex(i));
                        Assert.assertEquals((Object)column1IsNull[count], (Object)tsBlock.getColumn(0).isNull(i));
                        if (!column1IsNull[count]) {
                            Assert.assertEquals((long)column1Array[count], (long)tsBlock.getColumn(0).getInt(i));
                        }
                        Assert.assertEquals((Object)column2IsNull[count], (Object)tsBlock.getColumn(1).isNull(i));
                        if (!column2IsNull[count]) {
                            Assert.assertEquals((long)column2Array[count], (long)tsBlock.getColumn(1).getLong(i));
                        }
                        Assert.assertEquals((Object)column3IsNull[count], (Object)tsBlock.getColumn(2).isNull(i));
                        if (!column3IsNull[count]) {
                            Assert.assertEquals((double)column3Array[count], (double)tsBlock.getColumn(2).getFloat(i), (double)1.0E-6);
                        }
                        Assert.assertEquals((Object)column4IsNull[count], (Object)tsBlock.getColumn(3).isNull(i));
                        if (!column4IsNull[count]) {
                            Assert.assertEquals((Object)column4Array[count], (Object)tsBlock.getColumn(3).getBoolean(i));
                        }
                        ++i;
                        ++count;
                    }
                }
                listenableFuture = innerTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)timeArray.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInnerJoin4() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1000.0, TimeUnit.SECONDS));
        Operator child1 = new Operator(){
            private final long[][] timeArray = new long[][]{{100L, 90L, 80L, 70L, 60L, 50L, 40L, 30L, 20L, 10L, 0L}};
            private final int[][] value1Array = new int[][]{{100, 90, 80, 70, 60, 50, 40, 30, 20, 10, 0}};
            private final long[][] value2Array = new long[][]{{200L, 180L, 160L, 140L, 120L, 100L, 80L, 60L, 40L, 20L, 0L}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false}}, new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.INT32, TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeInt(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeLong(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 1;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 1;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator child2 = new Operator(){
            private final long[][] timeArray = new long[][]{{1000L, 500L, 100L}, {99L, 95L, 90L}, {50L, 48L, 20L, 10L}};
            private final float[][] value1Array = new float[][]{{3000.0f, 500.0f, 300.0f}, {99.0f, 95.0f, 0.0f}, {150.0f, 48.0f, 60.0f, 0.0f}};
            private final boolean[][] value2Array = new boolean[][]{{false, true, false}, {true, false, false}, {true, true, false, false}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, true}, {false, false, false, true}}, new boolean[][]{{false, false, true}, {false, true, false}, {false, false, true, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeFloat(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeBoolean(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 3;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 3;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator child3 = new Operator(){
            private final long[][] timeArray = new long[][]{{1000L, 500L, 101L}, {99L, 95L, 80L, 60L}, {40L, 22L, 11L, 0L}};
            private final Binary[][] value1Array = new Binary[][]{{new Binary("iotdb".getBytes(StandardCharsets.UTF_8)), new Binary("ty".getBytes(StandardCharsets.UTF_8)), new Binary("zm".getBytes(StandardCharsets.UTF_8))}, {new Binary("ty".getBytes(StandardCharsets.UTF_8)), new Binary("love".getBytes(StandardCharsets.UTF_8)), new Binary("zm".getBytes(StandardCharsets.UTF_8)), new Binary("2018-05-06".getBytes(StandardCharsets.UTF_8))}, {new Binary("1997-09-09".getBytes(StandardCharsets.UTF_8)), new Binary("1995-04-21".getBytes(StandardCharsets.UTF_8)), new Binary("2022-04-21".getBytes(StandardCharsets.UTF_8)), new Binary("2023-12-30".getBytes(StandardCharsets.UTF_8))}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, false, false}, {false, false, false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.TEXT));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeBinary(this.value1Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 3;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 3;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        HashMap<InputLocation, Integer> outputColumnMap = new HashMap<InputLocation, Integer>();
        outputColumnMap.put(new InputLocation(0, 0), 0);
        outputColumnMap.put(new InputLocation(0, 1), 1);
        outputColumnMap.put(new InputLocation(1, 0), 2);
        outputColumnMap.put(new InputLocation(1, 1), 3);
        outputColumnMap.put(new InputLocation(2, 0), 4);
        InnerTimeJoinOperator innerTimeJoinOperator = new InnerTimeJoinOperator(operatorContext, Arrays.asList(child1, child2, child3), Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.BOOLEAN, TSDataType.TEXT), (TimeComparator)new DescTimeComparator(), outputColumnMap);
        try {
            int count = 0;
            ListenableFuture listenableFuture = innerTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!innerTimeJoinOperator.isFinished() && innerTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = innerTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    count += tsBlock.getPositionCount();
                }
                listenableFuture = innerTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)0L, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInnerJoin5() {
        final OperatorContext operatorContext = (OperatorContext)Mockito.mock(OperatorContext.class);
        Mockito.when((Object)operatorContext.getMaxRunTime()).thenReturn((Object)new Duration(1000.0, TimeUnit.SECONDS));
        Operator child1 = new Operator(){
            private final long[][] timeArray = new long[][]{{100L, 90L, 80L, 70L, 60L, 50L, 40L, 30L, 20L, 10L, 0L}};
            private final int[][] value1Array = new int[][]{{100, 90, 80, 70, 60, 50, 40, 30, 20, 10, 0}};
            private final long[][] value2Array = new long[][]{{200L, 180L, 160L, 140L, 120L, 100L, 80L, 60L, 40L, 20L, 0L}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false}}, new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.INT32, TSDataType.INT64));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeInt(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeLong(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 1;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 1;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator child2 = new Operator(){
            private final long[][] timeArray = new long[][]{{1000L, 500L, 100L}, {99L, 95L, 90L}, {50L, 48L, 20L, 10L}};
            private final float[][] value1Array = new float[][]{{3000.0f, 500.0f, 300.0f}, {99.0f, 95.0f, 0.0f}, {150.0f, 48.0f, 60.0f, 0.0f}};
            private final boolean[][] value2Array = new boolean[][]{{false, true, false}, {true, false, false}, {true, true, false, false}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, true}, {false, false, false, true}}, new boolean[][]{{false, false, true}, {false, true, false}, {false, false, true, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                    } else {
                        builder.getColumnBuilder(0).writeFloat(this.value1Array[this.index][i]);
                    }
                    if (this.valueIsNull[1][this.index][i]) {
                        builder.getColumnBuilder(1).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(1).writeBoolean(this.value2Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 3;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 3;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator child3 = new Operator(){
            private final long[][] timeArray = new long[][]{{1000L, 500L, 101L}, {99L, 90L, 80L, 60L}, {40L, 22L, 11L, 0L}};
            private final Binary[][] value1Array = new Binary[][]{{new Binary("iotdb".getBytes(StandardCharsets.UTF_8)), new Binary("ty".getBytes(StandardCharsets.UTF_8)), new Binary("zm".getBytes(StandardCharsets.UTF_8))}, {new Binary("ty".getBytes(StandardCharsets.UTF_8)), new Binary("love".getBytes(StandardCharsets.UTF_8)), new Binary("zm".getBytes(StandardCharsets.UTF_8)), new Binary("2018-05-06".getBytes(StandardCharsets.UTF_8))}, {new Binary("1997-09-09".getBytes(StandardCharsets.UTF_8)), new Binary("1995-04-21".getBytes(StandardCharsets.UTF_8)), new Binary("2022-04-21".getBytes(StandardCharsets.UTF_8)), new Binary("2023-12-30".getBytes(StandardCharsets.UTF_8))}};
            private final boolean[][][] valueIsNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, false, false}, {false, false, false, false}}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return operatorContext;
            }

            public TsBlock next() {
                if (this.timeArray[this.index] == null) {
                    ++this.index;
                    return null;
                }
                TsBlockBuilder builder = new TsBlockBuilder(this.timeArray[this.index].length, Arrays.asList(TSDataType.TEXT));
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    builder.getTimeColumnBuilder().writeLong(this.timeArray[this.index][i]);
                    if (this.valueIsNull[0][this.index][i]) {
                        builder.getColumnBuilder(0).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(0).writeBinary(this.value1Array[this.index][i]);
                }
                builder.declarePositions(this.timeArray[this.index].length);
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 3;
            }

            public void close() {
            }

            public boolean isFinished() {
                return this.index >= 3;
            }

            public long calculateMaxPeekMemory() {
                return 65536L;
            }

            public long calculateMaxReturnSize() {
                return 65536L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        HashMap<InputLocation, Integer> outputColumnMap = new HashMap<InputLocation, Integer>();
        outputColumnMap.put(new InputLocation(0, 0), 0);
        outputColumnMap.put(new InputLocation(0, 1), 1);
        outputColumnMap.put(new InputLocation(1, 0), 2);
        outputColumnMap.put(new InputLocation(1, 1), 3);
        outputColumnMap.put(new InputLocation(2, 0), 4);
        InnerTimeJoinOperator innerTimeJoinOperator = new InnerTimeJoinOperator(operatorContext, Arrays.asList(child1, child2, child3), Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.BOOLEAN, TSDataType.TEXT), (TimeComparator)new DescTimeComparator(), outputColumnMap);
        try {
            int count = 0;
            ListenableFuture listenableFuture = innerTimeJoinOperator.isBlocked();
            listenableFuture.get();
            while (!innerTimeJoinOperator.isFinished() && innerTimeJoinOperator.hasNext()) {
                TsBlock tsBlock = innerTimeJoinOperator.next();
                if (tsBlock != null && !tsBlock.isEmpty()) {
                    count += tsBlock.getPositionCount();
                    Assert.assertEquals((long)90L, (long)tsBlock.getTimeByIndex(0));
                    Assert.assertFalse((boolean)tsBlock.getColumn(0).isNull(0));
                    Assert.assertEquals((long)90L, (long)tsBlock.getColumn(0).getInt(0));
                    Assert.assertFalse((boolean)tsBlock.getColumn(1).isNull(0));
                    Assert.assertEquals((long)180L, (long)tsBlock.getColumn(1).getLong(0));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(0));
                    Assert.assertFalse((boolean)tsBlock.getColumn(3).isNull(0));
                    Assert.assertFalse((boolean)tsBlock.getColumn(3).getBoolean(0));
                    Assert.assertFalse((boolean)tsBlock.getColumn(4).isNull(0));
                    Assert.assertEquals((Object)"love", (Object)tsBlock.getColumn(4).getBinary(0).getStringValue(StandardCharsets.UTF_8));
                }
                listenableFuture = innerTimeJoinOperator.isBlocked();
                listenableFuture.get();
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

