/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter.MonthIntervalMSFillFilter;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter.MonthIntervalNSFillFilter;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter.MonthIntervalUSFillFilter;
import org.junit.Assert;
import org.junit.Test;

public class MonthIntervalFillFilterTest {
    @Test
    public void testMonthIntervalMSFillFilter() {
        MonthIntervalMSFillFilter fillFilter1 = new MonthIntervalMSFillFilter(1, 0L, ZoneId.systemDefault());
        MonthIntervalMSFillFilter fillFilter2 = new MonthIntervalMSFillFilter(1, 86400000L, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime localDateTime = LocalDateTime.parse("2023-02-01T11:47:30", formatter);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(localDateTime);
        Instant instant = localDateTime.toInstant(zoneOffset);
        long previousTime = instant.toEpochMilli();
        Assert.assertTrue((boolean)fillFilter1.needFill(localDateTime.plusMonths(1L).toInstant(zoneOffset).toEpochMilli(), previousTime));
        Assert.assertFalse((boolean)fillFilter1.needFill(localDateTime.plusMonths(1L).toInstant(zoneOffset).toEpochMilli() + 1L, previousTime));
        Assert.assertTrue((boolean)fillFilter2.needFill(localDateTime.plusMonths(1L).toInstant(zoneOffset).toEpochMilli() + 1L, previousTime));
        Assert.assertTrue((boolean)fillFilter2.needFill(localDateTime.plusMonths(1L).plusDays(1L).toInstant(zoneOffset).toEpochMilli(), previousTime));
        Assert.assertFalse((boolean)fillFilter2.needFill(localDateTime.plusMonths(1L).plusDays(1L).toInstant(zoneOffset).toEpochMilli() + 1L, previousTime));
    }

    @Test
    public void testMonthIntervalUSFillFilter() {
        MonthIntervalUSFillFilter fillFilter1 = new MonthIntervalUSFillFilter(1, 0L, ZoneId.systemDefault());
        MonthIntervalUSFillFilter fillFilter2 = new MonthIntervalUSFillFilter(1, 86400000000L, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime localDateTime = LocalDateTime.parse("2023-02-01T11:47:30", formatter);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(localDateTime);
        Instant instant = localDateTime.toInstant(zoneOffset);
        long previousTime = instant.getEpochSecond() * 1000000L + instant.getLong(ChronoField.MICRO_OF_SECOND);
        Instant current = localDateTime.plusMonths(1L).toInstant(zoneOffset);
        Assert.assertTrue((boolean)fillFilter1.needFill(current.getEpochSecond() * 1000000L + current.getLong(ChronoField.MICRO_OF_SECOND), previousTime));
        Assert.assertFalse((boolean)fillFilter1.needFill(current.getEpochSecond() * 1000000L + current.getLong(ChronoField.MICRO_OF_SECOND) + 1L, previousTime));
        Assert.assertTrue((boolean)fillFilter2.needFill(current.getEpochSecond() * 1000000L + current.getLong(ChronoField.MICRO_OF_SECOND) + 1L, previousTime));
        current = localDateTime.plusMonths(1L).plusDays(1L).toInstant(zoneOffset);
        Assert.assertTrue((boolean)fillFilter2.needFill(current.getEpochSecond() * 1000000L + current.getLong(ChronoField.MICRO_OF_SECOND), previousTime));
        Assert.assertFalse((boolean)fillFilter2.needFill(current.getEpochSecond() * 1000000L + current.getLong(ChronoField.MICRO_OF_SECOND) + 1L, previousTime));
    }

    @Test
    public void testMonthIntervalNSFillFilter() {
        MonthIntervalNSFillFilter fillFilter1 = new MonthIntervalNSFillFilter(1, 0L, ZoneId.systemDefault());
        MonthIntervalNSFillFilter fillFilter2 = new MonthIntervalNSFillFilter(1, 86400000000000L, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime localDateTime = LocalDateTime.parse("2023-02-01T11:47:30", formatter);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(localDateTime);
        Instant instant = localDateTime.toInstant(zoneOffset);
        long previousTime = instant.getEpochSecond() * 1000000000L + instant.getLong(ChronoField.NANO_OF_SECOND);
        Instant current = localDateTime.plusMonths(1L).toInstant(zoneOffset);
        Assert.assertTrue((boolean)fillFilter1.needFill(current.getEpochSecond() * 1000000000L + current.getLong(ChronoField.NANO_OF_SECOND), previousTime));
        Assert.assertFalse((boolean)fillFilter1.needFill(current.getEpochSecond() * 1000000000L + current.getLong(ChronoField.NANO_OF_SECOND) + 1L, previousTime));
        Assert.assertTrue((boolean)fillFilter2.needFill(current.getEpochSecond() * 1000000000L + current.getLong(ChronoField.NANO_OF_SECOND) + 1L, previousTime));
        current = localDateTime.plusMonths(1L).plusDays(1L).toInstant(zoneOffset);
        Assert.assertTrue((boolean)fillFilter2.needFill(current.getEpochSecond() * 1000000000L + current.getLong(ChronoField.NANO_OF_SECOND), previousTime));
        Assert.assertFalse((boolean)fillFilter2.needFill(current.getEpochSecond() * 1000000000L + current.getLong(ChronoField.NANO_OF_SECOND) + 1L, previousTime));
    }
}

