/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.UpdateLastCacheOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UpdateLastCacheOperatorTest {
    private static final String SERIES_SCAN_OPERATOR_TEST_SG = "root.UpdateLastCacheOperator";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, SERIES_SCAN_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void testUpdateLastCacheOperatorTestWithoutTimeFilter() {
        try {
            List aggregators = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            UpdateLastCacheOperator updateLastCacheOperator = this.initUpdateLastCacheOperator(aggregators, null, false, null);
            Assert.assertTrue((boolean)updateLastCacheOperator.isBlocked().isDone());
            Assert.assertTrue((boolean)updateLastCacheOperator.hasNext());
            TsBlock result = updateLastCacheOperator.next();
            Assert.assertEquals((long)1L, (long)result.getPositionCount());
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            Assert.assertEquals((long)499L, (long)result.getTimeByIndex(0));
            Assert.assertEquals((Object)"root.UpdateLastCacheOperator.device0.sensor0", (Object)result.getColumn(0).getBinary(0).toString());
            Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(0).toString());
            Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(0).toString());
            Assert.assertFalse((boolean)updateLastCacheOperator.hasNext());
            Assert.assertTrue((boolean)updateLastCacheOperator.isFinished());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testUpdateLastCacheOperatorTestWithTimeFilter1() {
        try {
            List aggregators = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            TimeFilterOperators.TimeGtEq timeFilter = TimeFilterApi.gtEq((long)200L);
            UpdateLastCacheOperator updateLastCacheOperator = this.initUpdateLastCacheOperator(aggregators, (Filter)timeFilter, false, null);
            Assert.assertTrue((boolean)updateLastCacheOperator.isBlocked().isDone());
            Assert.assertTrue((boolean)updateLastCacheOperator.hasNext());
            TsBlock result = updateLastCacheOperator.next();
            Assert.assertEquals((long)1L, (long)result.getPositionCount());
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            Assert.assertEquals((long)499L, (long)result.getTimeByIndex(0));
            Assert.assertEquals((Object)"root.UpdateLastCacheOperator.device0.sensor0", (Object)result.getColumn(0).getBinary(0).toString());
            Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(0).toString());
            Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(0).toString());
            Assert.assertFalse((boolean)updateLastCacheOperator.hasNext());
            Assert.assertTrue((boolean)updateLastCacheOperator.isFinished());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testUpdateLastCacheOperatorTestWithTimeFilter2() {
        try {
            List aggregators = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            TimeFilterOperators.TimeLtEq timeFilter = TimeFilterApi.ltEq((long)120L);
            UpdateLastCacheOperator updateLastCacheOperator = this.initUpdateLastCacheOperator(aggregators, (Filter)timeFilter, false, null);
            Assert.assertTrue((boolean)updateLastCacheOperator.isBlocked().isDone());
            Assert.assertTrue((boolean)updateLastCacheOperator.hasNext());
            TsBlock result = updateLastCacheOperator.next();
            Assert.assertEquals((long)1L, (long)result.getPositionCount());
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            Assert.assertEquals((long)120L, (long)result.getTimeByIndex(0));
            Assert.assertEquals((Object)"root.UpdateLastCacheOperator.device0.sensor0", (Object)result.getColumn(0).getBinary(0).toString());
            Assert.assertEquals((Object)"20120", (Object)result.getColumn(1).getBinary(0).toString());
            Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(0).toString());
            Assert.assertFalse((boolean)updateLastCacheOperator.hasNext());
            Assert.assertTrue((boolean)updateLastCacheOperator.isFinished());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    public UpdateLastCacheOperator initUpdateLastCacheOperator(List<Aggregator> aggregators, Filter timeFilter, boolean ascending, GroupByTimeParameter groupByTimeParameter) throws IllegalPathException {
        MeasurementPath measurementPath = new MeasurementPath("root.UpdateLastCacheOperator.device0.sensor0", TSDataType.INT32);
        HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0"});
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        driverContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
        PlanNodeId planNodeId2 = new PlanNodeId("2");
        driverContext.addOperatorContext(2, planNodeId2, UpdateLastCacheOperator.class.getSimpleName());
        driverContext.getOperatorContexts().forEach(operatorContext -> OperatorContext.setMaxRunTime((Duration)AggregationOperatorTest.TEST_TIME_SLICE));
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors((Set)allSensors);
        scanOptionsBuilder.withGlobalTimeFilter(timeFilter);
        SeriesAggregationScanOperator seriesAggregationScanOperator = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)ascending, (boolean)true), groupByTimeParameter, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        seriesAggregationScanOperator.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
        return new UpdateLastCacheOperator((OperatorContext)driverContext.getOperatorContexts().get(1), (Operator)seriesAggregationScanOperator, measurementPath, measurementPath.getSeriesType(), null, false, false);
    }
}

