/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.SortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SortOperatorTest {
    private static final String SORT_OPERATOR_TEST_SG = "root.SortOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private int dataNodeId;
    private int maxTsBlockSizeInBytes;

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        this.dataNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
        this.maxTsBlockSizeInBytes = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
        IoTDBDescriptor.getInstance().getConfig().setDataNodeId(0);
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes(200);
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, SORT_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        IoTDBDescriptor.getInstance().getConfig().setDataNodeId(this.dataNodeId);
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes(this.maxTsBlockSizeInBytes);
    }

    public Operator genSortOperator(Ordering timeOrdering, boolean getSortOperator) {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"sortOperator-test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(3, new PlanNodeId("3"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(4, new PlanNodeId("4"), SortOperator.class.getSimpleName());
            MeasurementPath measurementPath1 = new MeasurementPath("root.SortOperatorTest.device0.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.SortOperatorTest.device1.sensor0", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath1));
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath2));
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            LinkedList<TSDataType> tsDataTypes = new LinkedList<TSDataType>(Arrays.asList(TSDataType.INT32, TSDataType.INT32));
            FullOuterTimeJoinOperator timeJoinOperator1 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(2), Arrays.asList(seriesScanOperator1, seriesScanOperator2), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            if (!getSortOperator) {
                return timeJoinOperator1;
            }
            Comparator<SortKey> comparator = Comparator.comparing(sortKey -> sortKey.tsBlock.getColumn(0).getInt(sortKey.rowIndex));
            OperatorContext operatorContext = (OperatorContext)driverContext.getOperatorContexts().get(3);
            String filePrefix = "target" + File.separator + operatorContext.getDriverContext().getFragmentInstanceContext().getId().getFragmentInstanceId() + File.separator + operatorContext.getDriverContext().getPipelineId() + File.separator;
            SortOperator sortOperator = new SortOperator(operatorContext, (Operator)timeJoinOperator1, tsDataTypes, filePrefix, comparator);
            sortOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            return sortOperator;
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
            return null;
        }
    }

    long getValue(long expectedTime) {
        if (expectedTime < 200L) {
            return 20000L + expectedTime;
        }
        if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
            return 10000L + expectedTime;
        }
        return expectedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sortOperatorSpillingTest() throws Exception {
        long sortBufferSize = IoTDBDescriptor.getInstance().getConfig().getSortBufferSize();
        try {
            IoTDBDescriptor.getInstance().getConfig().setSortBufferSize(5000L);
            SortOperator root = (SortOperator)this.genSortOperator(Ordering.ASC, true);
            int lastValue = -1;
            int count = 0;
            while (root.isBlocked().isDone() && root.hasNext()) {
                TsBlock tsBlock = root.next();
                if (tsBlock == null) continue;
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    long time = tsBlock.getTimeByIndex(i);
                    int v1 = tsBlock.getColumn(0).getInt(i);
                    int v2 = tsBlock.getColumn(1).getInt(i);
                    Assert.assertTrue((lastValue == -1 || lastValue < v1 ? 1 : 0) != 0);
                    Assert.assertEquals((long)this.getValue(time), (long)v1);
                    Assert.assertEquals((long)v1, (long)v2);
                    lastValue = v1;
                    ++count;
                }
            }
            root.close();
            Assert.assertEquals((long)500L, (long)count);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setSortBufferSize(sortBufferSize);
        }
    }

    @Test
    public void sortOperatorNormalTest() throws Exception {
        Operator root = this.genSortOperator(Ordering.ASC, true);
        int lastValue = -1;
        int count = 0;
        while (root.isBlocked().isDone() && root.hasNext()) {
            TsBlock tsBlock = root.next();
            if (tsBlock == null) continue;
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                long time = tsBlock.getTimeByIndex(i);
                int v1 = tsBlock.getColumn(0).getInt(i);
                int v2 = tsBlock.getColumn(1).getInt(i);
                Assert.assertTrue((lastValue == -1 || lastValue < v1 ? 1 : 0) != 0);
                Assert.assertEquals((long)this.getValue(time), (long)v1);
                Assert.assertEquals((long)v1, (long)v2);
                lastValue = v1;
                ++count;
            }
        }
        root.close();
        Assert.assertEquals((long)500L, (long)count);
    }
}

