/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.slidingwindow.SlidingWindowAggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.slidingwindow.SlidingWindowAggregatorFactory;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.SlidingWindowAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlidingWindowAggregationOperatorTest {
    private static final String AGGREGATION_OPERATOR_TEST_SG = "root.SlidingWindowAggregationOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    private final List<TAggregationType> leafAggregationTypes = Arrays.asList(TAggregationType.COUNT, TAggregationType.SUM, TAggregationType.LAST_VALUE, TAggregationType.FIRST_VALUE, TAggregationType.MAX_VALUE, TAggregationType.MIN_VALUE);
    private final List<TAggregationType> rootAggregationTypes = Arrays.asList(TAggregationType.COUNT, TAggregationType.AVG, TAggregationType.SUM, TAggregationType.LAST_VALUE, TAggregationType.MIN_TIME, TAggregationType.MAX_TIME, TAggregationType.FIRST_VALUE, TAggregationType.MAX_VALUE, TAggregationType.MIN_VALUE);
    private final List<String> rootAggregationNames = this.rootAggregationTypes.stream().map(SchemaUtils::getBuiltinAggregationName).collect(Collectors.toList());
    private final List<List<List<InputLocation>>> inputLocations = Arrays.asList(Collections.singletonList(Collections.singletonList(new InputLocation(0, 0))), Collections.singletonList(Arrays.asList(new InputLocation(0, 0), new InputLocation(0, 1))), Collections.singletonList(Collections.singletonList(new InputLocation(0, 1))), Collections.singletonList(Arrays.asList(new InputLocation(0, 2), new InputLocation(0, 3))), Collections.singletonList(Collections.singletonList(new InputLocation(0, 5))), Collections.singletonList(Collections.singletonList(new InputLocation(0, 3))), Collections.singletonList(Arrays.asList(new InputLocation(0, 4), new InputLocation(0, 5))), Collections.singletonList(Collections.singletonList(new InputLocation(0, 6))), Collections.singletonList(Collections.singletonList(new InputLocation(0, 7))));
    private final GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 300L, new TimeDuration(0, 100L), new TimeDuration(0, 50L), true);
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, AGGREGATION_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void slidingWindowAggregationTest() throws Exception {
        String[] retArray = new String[]{"0,100,20049.5,2004950.0,20099,0,99,20000,20099,20000", "50,100,20099.5,2009950.0,20149,50,149,20050,20149,20050", "100,100,20149.5,2014950.0,20199,100,199,20100,20199,20100", "150,100,15199.5,1519950.0,10249,150,249,20150,20199,10200", "200,100,6249.5,624950.0,299,200,299,10200,10259,260", "250,50,2274.5,113725.0,299,250,299,10250,10259,260"};
        SlidingWindowAggregationOperator slidingWindowAggregationOperator1 = this.initSlidingWindowAggregationOperator(true);
        int count = 0;
        while (slidingWindowAggregationOperator1.hasNext()) {
            TsBlock resultTsBlock = slidingWindowAggregationOperator1.next();
            if (resultTsBlock == null) continue;
            Assert.assertEquals((long)this.rootAggregationTypes.size(), (long)resultTsBlock.getValueColumnCount());
            int positionCount = resultTsBlock.getPositionCount();
            for (int pos = 0; pos < positionCount; ++pos) {
                Assert.assertEquals((Object)retArray[count], (Object)this.getResultString(resultTsBlock, pos));
                ++count;
            }
        }
        Assert.assertEquals((long)retArray.length, (long)count);
        SlidingWindowAggregationOperator slidingWindowAggregationOperator2 = this.initSlidingWindowAggregationOperator(false);
        while (slidingWindowAggregationOperator2.hasNext()) {
            TsBlock resultTsBlock = slidingWindowAggregationOperator2.next();
            if (resultTsBlock == null) continue;
            Assert.assertEquals((long)this.rootAggregationTypes.size(), (long)resultTsBlock.getValueColumnCount());
            int positionCount = resultTsBlock.getPositionCount();
            for (int pos = 0; pos < positionCount; ++pos) {
                Assert.assertEquals((Object)retArray[count - 1], (Object)this.getResultString(resultTsBlock, pos));
                --count;
            }
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    private String getResultString(TsBlock resultTsBlock, int pos) {
        return resultTsBlock.getTimeColumn().getLong(pos) + "," + resultTsBlock.getColumn(0).getLong(pos) + "," + resultTsBlock.getColumn(1).getDouble(pos) + "," + resultTsBlock.getColumn(2).getDouble(pos) + "," + resultTsBlock.getColumn(3).getInt(pos) + "," + resultTsBlock.getColumn(4).getLong(pos) + "," + resultTsBlock.getColumn(5).getLong(pos) + "," + resultTsBlock.getColumn(6).getInt(pos) + "," + resultTsBlock.getColumn(7).getInt(pos) + "," + resultTsBlock.getColumn(8).getInt(pos);
    }

    private SlidingWindowAggregationOperator initSlidingWindowAggregationOperator(boolean ascending) throws IllegalPathException {
        QueryId queryId = new QueryId("test");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        PlanNodeId sourceId = queryId.genPlanNodeId();
        driverContext.addOperatorContext(0, sourceId, SeriesAggregationScanOperator.class.getSimpleName());
        driverContext.addOperatorContext(1, queryId.genPlanNodeId(), SlidingWindowAggregationOperator.class.getSimpleName());
        driverContext.getOperatorContexts().forEach(operatorContext -> OperatorContext.setMaxRunTime((Duration)AggregationOperatorTest.TEST_TIME_SLICE));
        MeasurementPath d0s0 = new MeasurementPath("root.SlidingWindowAggregationOperatorTest.device0.sensor0", TSDataType.INT32);
        ArrayList aggregators = new ArrayList();
        AccumulatorFactory.createBuiltinAccumulators(this.leafAggregationTypes, (TSDataType)TSDataType.INT32, Collections.emptyList(), Collections.emptyMap(), (boolean)ascending).forEach(accumulator -> aggregators.add(new Aggregator(accumulator, AggregationStep.PARTIAL)));
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(Collections.singleton("sensor0"));
        SeriesAggregationScanOperator seriesAggregationScanOperator = new SeriesAggregationScanOperator(sourceId, (PartialPath)d0s0, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)this.groupByTimeParameter, (boolean)ascending, (boolean)true), this.groupByTimeParameter, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        seriesAggregationScanOperator.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
        ArrayList<SlidingWindowAggregator> finalAggregators = new ArrayList<SlidingWindowAggregator>();
        for (int i = 0; i < this.rootAggregationTypes.size(); ++i) {
            finalAggregators.add(SlidingWindowAggregatorFactory.createSlidingWindowAggregator((String)this.rootAggregationNames.get(i), (TAggregationType)this.rootAggregationTypes.get(i), Collections.singletonList(TSDataType.INT32), Collections.emptyList(), Collections.emptyMap(), (boolean)ascending, this.inputLocations.get(i).stream().map(tmpInputLocations -> tmpInputLocations.toArray(new InputLocation[0])).collect(Collectors.toList()), (AggregationStep)AggregationStep.FINAL));
        }
        return new SlidingWindowAggregationOperator((OperatorContext)driverContext.getOperatorContexts().get(1), finalAggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)this.groupByTimeParameter, (boolean)ascending, (boolean)false), (Operator)seriesAggregationScanOperator, ascending, false, this.groupByTimeParameter, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
    }
}

