/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.SingleDeviceViewOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleDeviceViewOperatorTest {
    private static final String SINGLE_DEVICE_MERGE_OPERATOR_TEST_SG = "root.SingleDeviceViewOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, SINGLE_DEVICE_MERGE_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    @Test
    public void singleDeviceViewOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(3, new PlanNodeId("3"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(4, new PlanNodeId("4"), SingleDeviceViewOperator.class.getSimpleName());
            MeasurementPath measurementPath1 = new MeasurementPath("root.SingleDeviceViewOperatorTest.device0.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.SingleDeviceViewOperatorTest.device0.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, Ordering.ASC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath1));
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, Ordering.ASC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath2));
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(2), Arrays.asList(seriesScanOperator1, seriesScanOperator2), Ordering.ASC, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new AscTimeComparator())), (TimeComparator)new AscTimeComparator());
            timeJoinOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SingleDeviceViewOperator singleDeviceViewOperator = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(3), "root.SingleDeviceViewOperatorTest.device0", (Operator)timeJoinOperator, Arrays.asList(1, 2), Arrays.asList(TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32));
            int count = 0;
            int total = 0;
            while (singleDeviceViewOperator.isBlocked().isDone() && singleDeviceViewOperator.hasNext()) {
                TsBlock tsBlock = singleDeviceViewOperator.next();
                Assert.assertEquals((long)4L, (long)tsBlock.getValueColumnCount());
                total += tsBlock.getPositionCount();
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    long expectedTime = (long)i + 20L * (long)(count % 25);
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertEquals((Object)"root.SingleDeviceViewOperatorTest.device0", (Object)tsBlock.getColumn(0).getBinary(i).toString());
                    if (expectedTime < 200L) {
                        Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                        Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                        continue;
                    }
                    if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                        Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                        Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                        continue;
                    }
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(1).getInt(i));
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(2).getInt(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                }
                ++count;
            }
            Assert.assertEquals((long)500L, (long)total);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

