/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import java.util.Collections;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.junit.Assert;
import org.junit.Test;

public class SingleColumnMergerTest {
    @Test
    public void mergeTest1() {
        SingleColumnMerger merger = new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator());
        TsBlockBuilder inputBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        inputBuilder.getTimeColumnBuilder().writeLong(2L);
        inputBuilder.getColumnBuilder(0).writeInt(20);
        inputBuilder.declarePosition();
        inputBuilder.getTimeColumnBuilder().writeLong(4L);
        inputBuilder.getColumnBuilder(0).writeInt(40);
        inputBuilder.declarePosition();
        inputBuilder.getTimeColumnBuilder().writeLong(5L);
        inputBuilder.getColumnBuilder(0).appendNull();
        inputBuilder.declarePosition();
        inputBuilder.getTimeColumnBuilder().writeLong(6L);
        inputBuilder.getColumnBuilder(0).writeInt(60);
        inputBuilder.declarePosition();
        TsBlock[] inputTsBlocks = new TsBlock[]{inputBuilder.build()};
        int[] inputIndex = new int[]{1};
        int[] updatedInputIndex = new int[]{1};
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(4L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(5L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(6L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(7L);
        builder.declarePosition();
        ColumnBuilder valueColumnBuilder = builder.getColumnBuilder(0);
        merger.mergeColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeColumnBuilder, 7L, valueColumnBuilder);
        Assert.assertEquals((long)4L, (long)updatedInputIndex[0]);
        Column result = valueColumnBuilder.build();
        Assert.assertEquals((long)4L, (long)result.getPositionCount());
        Assert.assertFalse((boolean)result.isNull(0));
        Assert.assertEquals((long)40L, (long)result.getInt(0));
        Assert.assertTrue((boolean)result.isNull(1));
        Assert.assertFalse((boolean)result.isNull(2));
        Assert.assertEquals((long)60L, (long)result.getInt(2));
        Assert.assertTrue((boolean)result.isNull(3));
    }

    @Test
    public void mergeTest2() {
        SingleColumnMerger merger = new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator());
        TsBlock[] inputTsBlocks = new TsBlock[1];
        int[] inputIndex = new int[]{0};
        int[] updatedInputIndex = new int[]{0};
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(4L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(5L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(6L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(7L);
        builder.declarePosition();
        ColumnBuilder valueColumnBuilder = builder.getColumnBuilder(0);
        merger.mergeColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeColumnBuilder, 7L, valueColumnBuilder);
        Assert.assertEquals((long)0L, (long)updatedInputIndex[0]);
        Column result = valueColumnBuilder.build();
        Assert.assertEquals((long)4L, (long)result.getPositionCount());
        Assert.assertTrue((boolean)result.isNull(0));
        Assert.assertTrue((boolean)result.isNull(1));
        Assert.assertTrue((boolean)result.isNull(2));
        Assert.assertTrue((boolean)result.isNull(3));
    }

    @Test
    public void mergeTest3() {
        SingleColumnMerger merger = new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator());
        TsBlockBuilder inputBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        inputBuilder.getTimeColumnBuilder().writeLong(8L);
        inputBuilder.getColumnBuilder(0).writeInt(80);
        inputBuilder.declarePosition();
        TsBlock[] inputTsBlocks = new TsBlock[]{inputBuilder.build()};
        int[] inputIndex = new int[]{0};
        int[] updatedInputIndex = new int[]{0};
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(4L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(5L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(6L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(7L);
        builder.declarePosition();
        ColumnBuilder valueColumnBuilder = builder.getColumnBuilder(0);
        merger.mergeColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeColumnBuilder, 7L, valueColumnBuilder);
        Assert.assertEquals((long)0L, (long)updatedInputIndex[0]);
        Column result = valueColumnBuilder.build();
        Assert.assertEquals((long)4L, (long)result.getPositionCount());
        Assert.assertTrue((boolean)result.isNull(0));
        Assert.assertTrue((boolean)result.isNull(1));
        Assert.assertTrue((boolean)result.isNull(2));
        Assert.assertTrue((boolean)result.isNull(3));
    }

    @Test
    public void mergeTest4() {
        SingleColumnMerger merger = new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new DescTimeComparator());
        TsBlockBuilder inputBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        inputBuilder.getTimeColumnBuilder().writeLong(2L);
        inputBuilder.getColumnBuilder(0).writeInt(20);
        inputBuilder.declarePosition();
        TsBlock[] inputTsBlocks = new TsBlock[]{inputBuilder.build()};
        int[] inputIndex = new int[]{0};
        int[] updatedInputIndex = new int[]{0};
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(7L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(6L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(5L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(4L);
        builder.declarePosition();
        ColumnBuilder valueColumnBuilder = builder.getColumnBuilder(0);
        merger.mergeColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeColumnBuilder, 4L, valueColumnBuilder);
        Assert.assertEquals((long)0L, (long)updatedInputIndex[0]);
        Column result = valueColumnBuilder.build();
        Assert.assertEquals((long)4L, (long)result.getPositionCount());
        Assert.assertTrue((boolean)result.isNull(0));
        Assert.assertTrue((boolean)result.isNull(1));
        Assert.assertTrue((boolean)result.isNull(2));
        Assert.assertTrue((boolean)result.isNull(3));
    }
}

