/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeriesScanOperatorTest {
    private static final String SERIES_SCAN_OPERATOR_TEST_SG = "root.SeriesScanOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, SERIES_SCAN_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath = new MeasurementPath("root.SeriesScanOperatorTest.device0.sensor0", TSDataType.INT32);
            HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0"});
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors((Set)allSensors);
            SeriesScanOperator seriesScanOperator = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId, (PartialPath)measurementPath, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            int count = 0;
            while (seriesScanOperator.hasNext()) {
                TsBlock tsBlock = seriesScanOperator.next();
                Assert.assertEquals((long)1L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof IntColumn));
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    if ((long)count < 200L) {
                        Assert.assertEquals((long)(20000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                    } else if ((long)count < 260L || (long)count >= 300L && (long)count < 380L || (long)count >= 400L) {
                        Assert.assertEquals((long)(10000L + (long)count), (long)tsBlock.getColumn(0).getInt(i));
                    } else {
                        Assert.assertEquals((long)count, (long)tsBlock.getColumn(0).getInt(i));
                    }
                    ++i;
                    ++count;
                }
            }
            Assert.assertEquals((long)500L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

