/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.RawDataAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.window.CountWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.SessionWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RawDataAggregationOperatorTest {
    private static final String AGGREGATION_OPERATOR_TEST_SG = "root.RawDataAggregationOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, AGGREGATION_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void aggregateRawDataTest1() throws Exception {
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            aggregationTypes.add(TAggregationType.SUM);
            aggregationTypes.add(TAggregationType.MIN_TIME);
            aggregationTypes.add(TAggregationType.MAX_TIME);
            aggregationTypes.add(TAggregationType.MAX_VALUE);
            aggregationTypes.add(TAggregationType.MIN_VALUE);
            for (int j = 0; j < 6; ++j) {
                ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
                inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
                inputLocations.add(inputLocationForOneAggregator);
            }
        }
        TimeWindowParameter windowParameter = new TimeWindowParameter(false);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            for (int i = 0; i < 2; ++i) {
                Assert.assertEquals((long)500L, (long)resultTsBlock.getColumn(6 * i).getLong(0));
                Assert.assertEquals((double)6524750.0, (double)resultTsBlock.getColumn(6 * i + 1).getDouble(0), (double)1.0E-4);
                Assert.assertEquals((long)0L, (long)resultTsBlock.getColumn(6 * i + 2).getLong(0));
                Assert.assertEquals((long)499L, (long)resultTsBlock.getColumn(6 * i + 3).getLong(0));
                Assert.assertEquals((long)20199L, (long)resultTsBlock.getColumn(6 * i + 4).getInt(0));
                Assert.assertEquals((long)260L, (long)resultTsBlock.getColumn(6 * i + 5).getInt(0));
            }
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void aggregateRawDataTest2() throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.AVG);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        TimeWindowParameter windowParameter = new TimeWindowParameter(false);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            int i2;
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            for (i2 = 0; i2 < 2; ++i2) {
                Assert.assertEquals((double)13049.5, (double)resultTsBlock.getColumn(i2).getDouble(0), (double)0.001);
            }
            for (i2 = 2; i2 < 4; ++i2) {
                Assert.assertEquals((long)20000L, (long)resultTsBlock.getColumn(i2).getInt(0));
            }
            for (i2 = 4; i2 < 6; ++i2) {
                Assert.assertEquals((long)10499L, (long)resultTsBlock.getColumn(i2).getInt(0));
            }
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void groupByTimeRawDataTest1() throws Exception {
        int[][] result = new int[][]{{100, 100, 100, 99}, {2004950, 2014950, 624950, 834551}, {0, 100, 200, 300}, {99, 199, 299, 398}, {20099, 20199, 10259, 10379}, {20000, 20100, 260, 380}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            aggregationTypes.add(TAggregationType.SUM);
            aggregationTypes.add(TAggregationType.MIN_TIME);
            aggregationTypes.add(TAggregationType.MAX_TIME);
            aggregationTypes.add(TAggregationType.MAX_VALUE);
            aggregationTypes.add(TAggregationType.MIN_VALUE);
            for (int j = 0; j < 6; ++j) {
                ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
                inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
                inputLocations.add(inputLocationForOneAggregator);
            }
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 399L, new TimeDuration(0, 100L), new TimeDuration(0, 100L), true);
        TimeWindowParameter windowParameter = new TimeWindowParameter(false);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(row));
                for (int i = 0; i < 2; ++i) {
                    Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(6 * i).getLong(row));
                    Assert.assertEquals((double)result[1][count], (double)resultTsBlock.getColumn(6 * i + 1).getDouble(row), (double)1.0E-4);
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(6 * i + 2).getLong(row));
                    Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(6 * i + 3).getLong(row));
                    Assert.assertEquals((long)result[4][count], (long)resultTsBlock.getColumn(6 * i + 4).getInt(row));
                    Assert.assertEquals((long)result[5][count], (long)resultTsBlock.getColumn(6 * i + 5).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void groupByTimeRawDataTest2() throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        double[][] result = new double[][]{{20049.5, 20149.5, 6249.5, 8429.808}, {20000.0, 20100.0, 10200.0, 10300.0}, {20099.0, 20199.0, 299.0, 398.0}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.AVG);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 399L, new TimeDuration(0, 100L), new TimeDuration(0, 100L), true);
        TimeWindowParameter windowParameter = new TimeWindowParameter(false);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                int i2;
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(row));
                for (i2 = 0; i2 < 2; ++i2) {
                    Assert.assertEquals((double)result[0][count], (double)resultTsBlock.getColumn(i2).getDouble(row), (double)0.001);
                }
                for (i2 = 2; i2 < 4; ++i2) {
                    Assert.assertEquals((long)((int)result[1][count]), (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                for (i2 = 4; i2 < 6; ++i2) {
                    Assert.assertEquals((long)((int)result[2][count]), (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void groupByTimeRawDataTest3() throws Exception {
        int[][] result = new int[][]{{100, 100, 100, 99}, {2004950, 2014950, 624950, 834551}, {0, 100, 200, 300}, {99, 199, 299, 398}, {20099, 20199, 10259, 10379}, {20000, 20100, 260, 380}, {20000, 20100, 10200, 10300}, {20099, 20199, 299, 398}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            aggregationTypes.add(TAggregationType.SUM);
            aggregationTypes.add(TAggregationType.MIN_TIME);
            aggregationTypes.add(TAggregationType.MAX_TIME);
            aggregationTypes.add(TAggregationType.MAX_VALUE);
            aggregationTypes.add(TAggregationType.MIN_VALUE);
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            for (int j = 0; j < 8; ++j) {
                ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
                inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
                inputLocations.add(inputLocationForOneAggregator);
            }
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 399L, new TimeDuration(0, 100L), new TimeDuration(0, 100L), true);
        TimeWindowParameter windowParameter = new TimeWindowParameter(true);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(row));
                long endTime = 100L * (long)count + 99L;
                if (count == 3) {
                    endTime = 398L;
                }
                Assert.assertEquals((long)endTime, (long)resultTsBlock.getColumn(0).getLong(row));
                for (int i = 0; i < 2; ++i) {
                    Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(8 * i + 1).getLong(row));
                    Assert.assertEquals((double)result[1][count], (double)resultTsBlock.getColumn(8 * i + 2).getDouble(row), (double)1.0E-4);
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(8 * i + 3).getLong(row));
                    Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(8 * i + 4).getLong(row));
                    Assert.assertEquals((long)result[4][count], (long)resultTsBlock.getColumn(8 * i + 5).getInt(row));
                    Assert.assertEquals((long)result[5][count], (long)resultTsBlock.getColumn(8 * i + 6).getInt(row));
                    Assert.assertEquals((long)result[6][count], (long)resultTsBlock.getColumn(8 * i + 7).getInt(row));
                    Assert.assertEquals((long)result[7][count], (long)resultTsBlock.getColumn(8 * i + 8).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void groupByTimeRawDataTest4() throws Exception {
        int[][] result = new int[][]{{100, 100, 100, 100, 100, 0}, {20099, 20199, 10259, 10379, 10499}, {20000, 20100, 260, 380, 10400}, {20000, 20100, 10200, 10300, 10400}, {20099, 20199, 299, 399, 10499}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            aggregationTypes.add(TAggregationType.MAX_VALUE);
            aggregationTypes.add(TAggregationType.MIN_VALUE);
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            for (int j = 0; j < 8; ++j) {
                ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
                inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
                inputLocations.add(inputLocationForOneAggregator);
            }
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 600L, new TimeDuration(0, 100L), new TimeDuration(0, 100L), true);
        TimeWindowParameter windowParameter = new TimeWindowParameter(true);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(row));
                Assert.assertEquals((long)(100L * (long)count + 99L), (long)resultTsBlock.getColumn(0).getLong(row));
                for (int i = 0; i < 2; ++i) {
                    if (count == 5) {
                        Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(5 * i + 1).getLong(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 2).isNull(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 3).isNull(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 4).isNull(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 5).isNull(row));
                        continue;
                    }
                    Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(5 * i + 1).getLong(row));
                    Assert.assertEquals((long)result[1][count], (long)resultTsBlock.getColumn(5 * i + 2).getInt(row));
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(5 * i + 3).getInt(row));
                    Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(5 * i + 4).getInt(row));
                    Assert.assertEquals((long)result[4][count], (long)resultTsBlock.getColumn(5 * i + 5).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void groupByTimeRawDataTest5() throws Exception {
        int[][] result = new int[][]{{100, 100, 100, 100, 99, 0}, {20100, 20199, 10300, 10400, 10499}, {20001, 10200, 260, 380, 10401}, {20001, 20101, 10201, 10301, 10401}, {20100, 10200, 10300, 10400, 10499}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            aggregationTypes.add(TAggregationType.MAX_VALUE);
            aggregationTypes.add(TAggregationType.MIN_VALUE);
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            for (int j = 0; j < 8; ++j) {
                ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
                inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
                inputLocations.add(inputLocationForOneAggregator);
            }
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 600L, new TimeDuration(0, 100L), new TimeDuration(0, 100L), false);
        TimeWindowParameter windowParameter = new TimeWindowParameter(false);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                Assert.assertEquals((long)(100 * (count + 1)), (long)resultTsBlock.getTimeColumn().getLong(row));
                for (int i = 0; i < 2; ++i) {
                    if (count == 5) {
                        Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(5 * i).getLong(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 1).isNull(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 2).isNull(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 3).isNull(row));
                        Assert.assertTrue((boolean)resultTsBlock.getColumn(5 * i + 4).isNull(row));
                        continue;
                    }
                    Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(5 * i).getLong(row));
                    Assert.assertEquals((long)result[1][count], (long)resultTsBlock.getColumn(5 * i + 1).getInt(row));
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(5 * i + 2).getInt(row));
                    Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(5 * i + 3).getInt(row));
                    Assert.assertEquals((long)result[4][count], (long)resultTsBlock.getColumn(5 * i + 4).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void groupByEventRawDataTest1() throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        int[][] result = new int[][]{{0, 260, 300}, {259, 299, 499}, {20000, 260, 10300}, {10259, 299, 10499}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.MIN_TIME);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.MAX_TIME);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        VariationWindowParameter windowParameter = new VariationWindowParameter(TSDataType.INT32, 0, false, true, 10000.0);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                int i2;
                for (i2 = 0; i2 < 2; ++i2) {
                    Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(i2).getLong(row));
                }
                for (i2 = 2; i2 < 4; ++i2) {
                    Assert.assertEquals((long)result[1][count], (long)resultTsBlock.getColumn(i2).getLong(row));
                }
                for (i2 = 4; i2 < 6; ++i2) {
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                for (i2 = 6; i2 < 8; ++i2) {
                    Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void groupByEventRawDataTest2() throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        int[][] result = new int[][]{{4019900, 613770, 11180, 827160, 7790, 1044950}, {200, 60, 40, 80, 20, 100}, {20000, 10200, 260, 10300, 380, 10400}};
        long[][] resultTime = new long[][]{{0L, 200L, 260L, 300L, 380L, 400L}, {199L, 259L, 299L, 379L, 399L, 499L}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.SUM);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        VariationWindowParameter windowParameter = new VariationWindowParameter(TSDataType.INT32, 0, true, true, 5000.0);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                int i2;
                Assert.assertEquals((long)resultTime[0][count], (long)resultTsBlock.getTimeByIndex(row));
                Assert.assertEquals((long)resultTime[1][count], (long)resultTsBlock.getColumn(0).getLong(row));
                for (i2 = 1; i2 <= 2; ++i2) {
                    Assert.assertEquals((double)result[0][count], (double)resultTsBlock.getColumn(i2).getDouble(row), (double)0.01);
                }
                for (i2 = 3; i2 <= 4; ++i2) {
                    Assert.assertEquals((long)result[1][count], (long)resultTsBlock.getColumn(i2).getLong(row));
                }
                for (i2 = 5; i2 <= 6; ++i2) {
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void groupByEventRawDataTest3() throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        int[][] result = new int[][]{{4019900, 613770, 11180, 827160, 7790, 1044950}, {200, 60, 40, 80, 20, 100}, {20000, 10200, 260, 10300, 380, 10400}};
        long[] resultTime = new long[]{0L, 200L, 260L, 300L, 380L, 400L};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.SUM);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        VariationWindowParameter windowParameter = new VariationWindowParameter(TSDataType.INT32, 0, false, true, 5000.0);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                int i2;
                Assert.assertEquals((long)resultTime[count], (long)resultTsBlock.getTimeByIndex(row));
                for (i2 = 0; i2 < 2; ++i2) {
                    Assert.assertEquals((double)result[0][count], (double)resultTsBlock.getColumn(i2).getDouble(row), (double)0.01);
                }
                for (i2 = 2; i2 < 4; ++i2) {
                    Assert.assertEquals((long)result[1][count], (long)resultTsBlock.getColumn(i2).getLong(row));
                }
                for (i2 = 4; i2 < 6; ++i2) {
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void groupByEventRawDataTest4() throws Exception {
        int[] result = new int[]{20000, 10200, 260, 10300, 380, 10400};
        long[][] resultTime = new long[][]{{0L, 200L, 260L, 300L, 380L, 400L}, {199L, 259L, 299L, 379L, 399L, 499L}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        VariationWindowParameter windowParameter = new VariationWindowParameter(TSDataType.INT32, 0, true, true, 5000.0);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                Assert.assertEquals((long)resultTime[0][count], (long)resultTsBlock.getTimeByIndex(row));
                Assert.assertEquals((long)resultTime[1][count], (long)resultTsBlock.getColumn(0).getLong(row));
                for (int i = 1; i <= 2; ++i) {
                    Assert.assertEquals((long)result[count], (long)resultTsBlock.getColumn(i).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void onePointInOneEqualEventWindowTest() throws Exception {
        VariationWindowParameter windowParameter = new VariationWindowParameter(TSDataType.INT32, 0, false, true, 0.0);
        this.onePointInOneWindowTest((WindowParameter)windowParameter);
    }

    @Test
    public void onePointInOneVariationEventWindowTest() throws Exception {
        VariationWindowParameter windowParameter = new VariationWindowParameter(TSDataType.INT32, 0, false, true, 0.5);
        this.onePointInOneWindowTest((WindowParameter)windowParameter);
    }

    private void onePointInOneWindowTest(WindowParameter windowParameter) throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.COUNT);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.MIN_TIME);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, windowParameter);
        int resultMinTime1 = -1;
        int resultMinTime2 = -1;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            int j;
            int i2;
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            for (i2 = 0; i2 < 2; ++i2) {
                for (j = 0; j < resultTsBlock.getColumn(i2).getPositionCount(); ++j) {
                    Assert.assertEquals((long)1L, (long)resultTsBlock.getColumn(i2).getLong(j));
                }
            }
            for (i2 = 2; i2 < 4; ++i2) {
                if (i2 == 2) {
                    for (j = 0; j < resultTsBlock.getColumn(i2).getPositionCount(); ++j) {
                        Assert.assertEquals((long)(++resultMinTime1), (long)resultTsBlock.getColumn(i2).getLong(j));
                    }
                    continue;
                }
                for (j = 0; j < resultTsBlock.getColumn(i2).getPositionCount(); ++j) {
                    Assert.assertEquals((long)(++resultMinTime2), (long)resultTsBlock.getColumn(i2).getLong(j));
                }
            }
        }
        Assert.assertEquals((long)499L, (long)resultMinTime1);
        Assert.assertEquals((long)499L, (long)resultMinTime2);
    }

    @Test
    public void groupBySessionRawDataTest1() throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        int[][] result = new int[][]{{0}, {499}, {20000}, {10499}};
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.MIN_TIME);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.MAX_TIME);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        SessionWindowParameter windowParameter = new SessionWindowParameter(2L, false);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        int count = 0;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            int row = 0;
            while (row < resultTsBlock.getPositionCount()) {
                int i2;
                for (i2 = 0; i2 < 2; ++i2) {
                    Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(i2).getLong(row));
                }
                for (i2 = 2; i2 < 4; ++i2) {
                    Assert.assertEquals((long)result[1][count], (long)resultTsBlock.getColumn(i2).getLong(row));
                }
                for (i2 = 4; i2 < 6; ++i2) {
                    Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                for (i2 = 6; i2 < 8; ++i2) {
                    Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                ++row;
                ++count;
            }
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    private RawDataAggregationOperator initRawDataAggregationOperator(List<TAggregationType> aggregationTypes, GroupByTimeParameter groupByTimeParameter, List<List<InputLocation[]>> inputLocations, WindowParameter windowParameter) throws IllegalPathException {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        MeasurementPath measurementPath1 = new MeasurementPath("root.RawDataAggregationOperatorTest.device0.sensor0", TSDataType.INT32);
        HashSet<String> allSensors = new HashSet<String>();
        allSensors.add("sensor0");
        allSensors.add("sensor1");
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
        PlanNodeId planNodeId2 = new PlanNodeId("2");
        driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
        driverContext.addOperatorContext(3, new PlanNodeId("3"), FullOuterTimeJoinOperator.class.getSimpleName());
        driverContext.addOperatorContext(4, new PlanNodeId("4"), RawDataAggregationOperatorTest.class.getSimpleName());
        driverContext.getOperatorContexts().forEach(operatorContext -> OperatorContext.setMaxRunTime((Duration)AggregationOperatorTest.TEST_TIME_SLICE));
        TimeFilterOperators.TimeGt timeFilter = null;
        if (groupByTimeParameter != null && !groupByTimeParameter.isLeftCRightO()) {
            timeFilter = TimeFilterApi.gt((long)0L);
        }
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(allSensors);
        scanOptionsBuilder.withGlobalTimeFilter((Filter)timeFilter);
        SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, Ordering.ASC, scanOptionsBuilder.build());
        seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
        MeasurementPath measurementPath2 = new MeasurementPath("root.RawDataAggregationOperatorTest.device0.sensor1", TSDataType.INT32);
        SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, Ordering.ASC, scanOptionsBuilder.build());
        seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
        FullOuterTimeJoinOperator timeJoinOperator = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(2), Arrays.asList(seriesScanOperator1, seriesScanOperator2), Ordering.ASC, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new AscTimeComparator())), (TimeComparator)new AscTimeComparator());
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        List accumulators = AccumulatorFactory.createBuiltinAccumulators(aggregationTypes, (TSDataType)TSDataType.INT32, Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        for (int i = 0; i < accumulators.size(); ++i) {
            aggregators.add(new Aggregator((Accumulator)accumulators.get(i), AggregationStep.SINGLE, inputLocations.get(i)));
        }
        return new RawDataAggregationOperator((OperatorContext)driverContext.getOperatorContexts().get(3), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true), (Operator)timeJoinOperator, true, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, windowParameter);
    }

    @Test
    public void groupByCountTest() throws Exception {
        ArrayList<InputLocation[]> inputLocationForOneAggregator;
        int i;
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.FIRST_VALUE);
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        for (i = 0; i < 2; ++i) {
            aggregationTypes.add(TAggregationType.LAST_VALUE);
            inputLocationForOneAggregator = new ArrayList();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        CountWindowParameter windowParameter = new CountWindowParameter(10L, 0, false, false);
        RawDataAggregationOperator rawDataAggregationOperator = this.initRawDataAggregationOperator(aggregationTypes, null, inputLocations, (WindowParameter)windowParameter);
        long count = 0L;
        long index = 0L;
        while (rawDataAggregationOperator.isBlocked().isDone() && rawDataAggregationOperator.hasNext()) {
            TsBlock resultTsBlock = rawDataAggregationOperator.next();
            if (resultTsBlock == null) continue;
            for (int row = 0; row < resultTsBlock.getPositionCount(); ++row) {
                int i2;
                long firstValue = count;
                long lastValue = count + 9L;
                if (count < 200L) {
                    firstValue += 20000L;
                    lastValue += 20000L;
                } else if (count < 260L || count >= 300L && count < 380L || count >= 400L && count < 500L) {
                    firstValue += 10000L;
                    lastValue += 10000L;
                }
                for (i2 = 0; i2 < 2; ++i2) {
                    Assert.assertEquals((long)firstValue, (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                for (i2 = 2; i2 < 4; ++i2) {
                    Assert.assertEquals((long)lastValue, (long)resultTsBlock.getColumn(i2).getInt(row));
                }
                count += 10L;
                ++index;
            }
        }
        Assert.assertEquals((long)50L, (long)index);
        Assert.assertEquals((long)500L, (long)count);
    }
}

