/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.DeviceViewOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.FillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.FilterAndProjectOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.IntoOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.LimitOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.LinearFillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.OffsetOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.RawDataAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.SlidingWindowAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.SortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear.LinearFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.HorizontallyConcatOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryCollectOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryMergeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQuerySortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.UpdateLastCacheOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.CountGroupByLevelScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.CountMergeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.NodeManageMemoryMergeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.NodePathsConvertOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.NodePathsCountOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaCountOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaFetchMergeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaFetchScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaQueryMergeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaQueryOrderByHeatOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.ExchangeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.LastCacheScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowParameter;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.ArithmeticAdditionColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.CompareLessEqualColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.ConstantColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.TimeColumnTransformer;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.type.BooleanType;
import org.apache.iotdb.tsfile.read.common.type.LongType;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class OperatorMemoryTest {
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seriesScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath = new MeasurementPath("root.SeriesScanOperatorTest.device0.sensor0", TSDataType.INT32);
            HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0"});
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors((Set)allSensors);
            SeriesScanOperator seriesScanOperator = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId, (PartialPath)measurementPath, Ordering.ASC, scanOptionsBuilder.build());
            Assert.assertEquals((long)((long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L), (long)seriesScanOperator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte(), (long)seriesScanOperator.calculateMaxReturnSize());
            Assert.assertEquals((long)((long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 2L), (long)seriesScanOperator.calculateRetainedSizeAfterCallingNext());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void alignedSeriesScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            AlignedPath alignedPath = new AlignedPath("root.AlignedSeriesScanOperatorTest.device0", Arrays.asList("sensor0", "sensor1", "sensor2"));
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, AlignedSeriesScanOperator.class.getSimpleName());
            AlignedSeriesScanOperator seriesScanOperator = new AlignedSeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId, alignedPath, Ordering.ASC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)alignedPath), false, null, -1);
            long maxPeekMemory = Math.max((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), (long)(4 * TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()) * 3L);
            long maxReturnMemory = Math.min(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), 4 * TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
            Assert.assertEquals((long)maxPeekMemory, (long)seriesScanOperator.calculateMaxPeekMemory());
            Assert.assertEquals((long)maxReturnMemory, (long)seriesScanOperator.calculateMaxReturnSize());
            Assert.assertEquals((long)(maxPeekMemory - maxReturnMemory), (long)seriesScanOperator.calculateRetainedSizeAfterCallingNext());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    @Test
    public void exchangeOperatorTest() {
        ExchangeOperator exchangeOperator = new ExchangeOperator(null, null, null);
        Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)exchangeOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)exchangeOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)0L, (long)exchangeOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void pipelineExchangeOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        ExchangeOperator exchangeOperator = new ExchangeOperator(null, null, null, child.calculateMaxReturnSize());
        Assert.assertEquals((long)1024L, (long)exchangeOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)exchangeOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)0L, (long)exchangeOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastCacheScanOperatorTest() {
        TsBlock tsBlock = (TsBlock)Mockito.mock(TsBlock.class);
        Mockito.when((Object)tsBlock.getRetainedSizeInBytes()).thenReturn((Object)1024L);
        LastCacheScanOperator lastCacheScanOperator = new LastCacheScanOperator(null, null, tsBlock);
        Assert.assertEquals((long)1024L, (long)lastCacheScanOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)lastCacheScanOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)0L, (long)lastCacheScanOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void fillOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        FillOperator fillOperator = new FillOperator((OperatorContext)Mockito.mock(OperatorContext.class), new IFill[]{null, null}, child);
        Assert.assertEquals((long)4608L, (long)fillOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)fillOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)fillOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQueryCollectOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        Random random = new Random();
        long expectedMaxPeekMemory = 0L;
        long expectedMaxReturnSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            long currentMaxPeekMemory = random.nextInt(1024) + 1024;
            long currentMaxReturnSize = random.nextInt(1024);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)currentMaxPeekMemory);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)currentMaxReturnSize);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, currentMaxPeekMemory);
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, currentMaxReturnSize);
        }
        LastQueryCollectOperator lastQueryCollectOperator = new LastQueryCollectOperator((OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)lastQueryCollectOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)lastQueryCollectOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)2048L, (long)lastQueryCollectOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQueryMergeOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        Random random = new Random();
        long expectedMaxPeekMemory = 0L;
        long temp = 0L;
        long expectedMaxReturnSize = 0L;
        long childSumReturnSize = 0L;
        long minReturnSize = Long.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            long currentMaxPeekMemory = random.nextInt(1024) + 1024;
            long currentMaxReturnSize = random.nextInt(1024);
            minReturnSize = Math.min(minReturnSize, currentMaxReturnSize);
            childSumReturnSize += currentMaxReturnSize;
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)currentMaxPeekMemory);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)currentMaxReturnSize);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, currentMaxReturnSize);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, temp + child.calculateMaxPeekMemory());
            temp += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, temp + expectedMaxReturnSize + (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber() * LastQueryMergeOperator.MAP_NODE_RETRAINED_SIZE);
        LastQueryMergeOperator lastQueryMergeOperator = new LastQueryMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, Comparator.naturalOrder());
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)lastQueryMergeOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)lastQueryMergeOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(childSumReturnSize - minReturnSize + 2048L + (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber() * LastQueryMergeOperator.MAP_NODE_RETRAINED_SIZE), (long)lastQueryMergeOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQueryOperatorTest() {
        TsBlockBuilder builder = (TsBlockBuilder)Mockito.mock(TsBlockBuilder.class);
        Mockito.when((Object)builder.getRetainedSizeInBytes()).thenReturn((Object)1024L);
        ArrayList<UpdateLastCacheOperator> children = new ArrayList<UpdateLastCacheOperator>(4);
        long expectedMaxReturnSize = DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
        for (int i = 0; i < 4; ++i) {
            UpdateLastCacheOperator child = (UpdateLastCacheOperator)Mockito.mock(UpdateLastCacheOperator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)0x200000L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, 1024L);
        }
        LastQueryOperator lastQueryOperator = new LastQueryOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, builder);
        Assert.assertEquals((long)((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + 0x200000L), (long)lastQueryOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)lastQueryOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)lastQueryOperator.calculateRetainedSizeAfterCallingNext());
        Mockito.when((Object)builder.getRetainedSizeInBytes()).thenReturn((Object)0x400000L);
        Assert.assertEquals((long)0x600000L, (long)lastQueryOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)0x400000L, (long)lastQueryOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)lastQueryOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQuerySortOperatorTest() {
        TsBlock tsBlock = (TsBlock)Mockito.mock(TsBlock.class);
        Mockito.when((Object)tsBlock.getRetainedSizeInBytes()).thenReturn((Object)16384L);
        Mockito.when((Object)tsBlock.getPositionCount()).thenReturn((Object)16);
        ArrayList<UpdateLastCacheOperator> children = new ArrayList<UpdateLastCacheOperator>(4);
        for (int i = 0; i < 4; ++i) {
            UpdateLastCacheOperator child = (UpdateLastCacheOperator)Mockito.mock(UpdateLastCacheOperator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
        }
        LastQuerySortOperator lastQuerySortOperator = new LastQuerySortOperator((OperatorContext)Mockito.mock(OperatorContext.class), tsBlock, children, Comparator.naturalOrder());
        Assert.assertEquals((long)((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + tsBlock.getRetainedSizeInBytes() + 2048L), (long)lastQuerySortOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)lastQuerySortOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)19456L, (long)lastQuerySortOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void limitOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemoryWithCounter()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        LimitOperator limitOperator = new LimitOperator((OperatorContext)Mockito.mock(OperatorContext.class), 100L, child);
        Assert.assertEquals((long)2048L, (long)limitOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)limitOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)limitOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void offsetOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemoryWithCounter()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        OffsetOperator offsetOperator = new OffsetOperator((OperatorContext)Mockito.mock(OperatorContext.class), 100L, child);
        Assert.assertEquals((long)2048L, (long)offsetOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)offsetOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)offsetOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void rowBasedTimeJoinOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(2);
        dataTypeList.add(TSDataType.INT32);
        dataTypeList.add(TSDataType.INT32);
        long expectedMaxReturnSize = Math.min((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), 3L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
        long expectedMaxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, expectedMaxPeekMemory + child.calculateMaxPeekMemory());
            expectedMaxPeekMemory += 65536L;
            children.add(child);
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory + expectedMaxReturnSize, childrenMaxPeekMemory);
        FullOuterTimeJoinOperator fullOuterTimeJoinOperator = new FullOuterTimeJoinOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, Ordering.ASC, dataTypeList, null, null);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)fullOuterTimeJoinOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)fullOuterTimeJoinOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)196608L, (long)fullOuterTimeJoinOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void horizontallyConcatOperatorTest() {
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            children.add(child);
            expectedMaxReturnSize += child.calculateMaxReturnSize();
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, expectedMaxPeekMemory + child.calculateMaxPeekMemory());
            expectedMaxPeekMemory += child.calculateMaxReturnSize();
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory + expectedMaxReturnSize, childrenMaxPeekMemory);
        HorizontallyConcatOperator horizontallyConcatOperator = new HorizontallyConcatOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, Collections.emptyList());
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)horizontallyConcatOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)horizontallyConcatOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)196608L, (long)horizontallyConcatOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void sortOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemoryWithCounter()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        SortOperator sortOperator = new SortOperator((OperatorContext)Mockito.mock(OperatorContext.class), child, Collections.singletonList(TSDataType.INT32), "", null);
        Assert.assertEquals((long)(2560L + IoTDBDescriptor.getInstance().getConfig().getSortBufferSize()), (long)sortOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), (long)sortOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(512L + IoTDBDescriptor.getInstance().getConfig().getSortBufferSize()), (long)sortOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void updateLastCacheOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        OperatorContext context = new OperatorContext(1, (PlanNodeId)Mockito.mock(PlanNodeId.class), SeriesAggregationScanOperator.class.getSimpleName(), (DriverContext)Mockito.mock(DriverContext.class));
        FragmentInstanceContext fragmentInstanceContext = (FragmentInstanceContext)Mockito.mock(FragmentInstanceContext.class);
        Mockito.when((Object)fragmentInstanceContext.getDataNodeQueryContext()).thenReturn(null);
        Mockito.when((Object)context.getDriverContext().getFragmentInstanceContext()).thenReturn((Object)fragmentInstanceContext);
        UpdateLastCacheOperator updateLastCacheOperator = new UpdateLastCacheOperator(context, child, null, TSDataType.BOOLEAN, null, false, false);
        Assert.assertEquals((long)2048L, (long)updateLastCacheOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)updateLastCacheOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)updateLastCacheOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void linearFillOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        LinearFillOperator linearFillOperator = new LinearFillOperator((OperatorContext)Mockito.mock(OperatorContext.class), (ILinearFill[])new LinearFill[]{null, null}, child);
        Assert.assertEquals((long)6656L, (long)linearFillOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)linearFillOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)linearFillOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void deviceViewOperatorTest() {
        long expectedMaxReturnSize;
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(2);
        dataTypeList.add(TSDataType.INT32);
        dataTypeList.add(TSDataType.INT32);
        ArrayList<String> devices = new ArrayList<String>(4);
        devices.add("device1");
        devices.add("device2");
        devices.add("device3");
        devices.add("device4");
        long expectedMaxPeekMemory = expectedMaxReturnSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        long expectedRetainedSizeAfterCallingNext = 0L;
        long childrenMaxPeekMemory = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)1024L);
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedRetainedSizeAfterCallingNext = Math.max(expectedRetainedSizeAfterCallingNext, child.calculateRetainedSizeAfterCallingNext());
            children.add(child);
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, childrenMaxPeekMemory) + expectedRetainedSizeAfterCallingNext;
        DeviceViewOperator deviceViewOperator = new DeviceViewOperator((OperatorContext)Mockito.mock(OperatorContext.class), devices, children, new ArrayList(), dataTypeList);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)deviceViewOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)deviceViewOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSizeAfterCallingNext, (long)deviceViewOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void filterAndProjectOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        BooleanType booleanType = (BooleanType)Mockito.mock(BooleanType.class);
        Mockito.when((Object)booleanType.getTypeEnum()).thenReturn((Object)TypeEnum.BOOLEAN);
        LongType longType = (LongType)Mockito.mock(LongType.class);
        Mockito.when((Object)longType.getTypeEnum()).thenReturn((Object)TypeEnum.INT64);
        CompareLessEqualColumnTransformer filterColumnTransformer = new CompareLessEqualColumnTransformer((Type)booleanType, (ColumnTransformer)new TimeColumnTransformer((Type)longType), (ColumnTransformer)new ConstantColumnTransformer((Type)longType, (Column)Mockito.mock(IntColumn.class)));
        ArrayList<TSDataType> filterOutputTypes = new ArrayList<TSDataType>();
        filterOutputTypes.add(TSDataType.INT32);
        filterOutputTypes.add(TSDataType.INT64);
        ArrayList<ArithmeticAdditionColumnTransformer> projectColumnTransformers = new ArrayList<ArithmeticAdditionColumnTransformer>();
        projectColumnTransformers.add(new ArithmeticAdditionColumnTransformer((Type)booleanType, (ColumnTransformer)new TimeColumnTransformer((Type)longType), (ColumnTransformer)new ConstantColumnTransformer((Type)longType, (Column)Mockito.mock(IntColumn.class))));
        FilterAndProjectOperator operator = new FilterAndProjectOperator((OperatorContext)Mockito.mock(OperatorContext.class), child, filterOutputTypes, new ArrayList(), (ColumnTransformer)filterColumnTransformer, new ArrayList(), new ArrayList(), projectColumnTransformers, false, true);
        Assert.assertEquals((long)(4L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() + 512L), (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)(2 * TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()), (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SchemaQueryScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, SchemaQueryScanOperator.class.getSimpleName());
            SchemaQueryScanOperator operator = new SchemaQueryScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), (ISchemaSource)Mockito.mock(ISchemaSource.class));
            Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void LevelTimeSeriesCountOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            CountGroupByLevelScanOperator operator = new CountGroupByLevelScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), 4, (ISchemaSource)Mockito.mock(ISchemaSource.class));
            Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SchemaCountOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, SchemaCountOperator.class.getSimpleName());
            SchemaCountOperator operator = new SchemaCountOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), (ISchemaSource)Mockito.mock(ISchemaSource.class));
            Assert.assertEquals((long)8L, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)8L, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    @Test
    public void SchemaQueryMergeOperatorTest() {
        QueryId queryId = new QueryId("stub_query");
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, child.calculateMaxReturnSize());
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext();
            children.add(child);
        }
        SchemaQueryMergeOperator operator = new SchemaQueryMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void CountMergeOperatorTest() {
        QueryId queryId = new QueryId("stub_query");
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, child.calculateMaxReturnSize());
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext();
            children.add(child);
        }
        CountMergeOperator operator = new CountMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SchemaFetchScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            SchemaFetchScanOperator operator = new SchemaFetchScanOperator(planNodeId, (OperatorContext)driverContext.getOperatorContexts().get(0), null, null, null, false, false);
            Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    @Test
    public void SchemaFetchMergeOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, child.calculateMaxReturnSize());
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext();
            children.add(child);
        }
        SchemaFetchMergeOperator operator = new SchemaFetchMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, null);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void SchemaQueryOrderByHeatOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory += child.calculateMaxReturnSize();
            expectedMaxReturnSize += child.calculateMaxReturnSize();
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext() + child.calculateMaxReturnSize();
            children.add(child);
        }
        SchemaQueryOrderByHeatOperator operator = new SchemaQueryOrderByHeatOperator((OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void NodePathsConvertOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
        long expectedMaxPeekMemory = child.calculateMaxPeekMemory() + child.calculateMaxReturnSize();
        long expectedMaxReturnSize = child.calculateMaxReturnSize();
        long expectedRetainedSize = child.calculateRetainedSizeAfterCallingNext();
        NodePathsConvertOperator operator = new NodePathsConvertOperator((OperatorContext)Mockito.mock(OperatorContext.class), child);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void NodePathsCountOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
        long expectedMaxPeekMemory = Math.max(2L * (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxPeekMemory());
        long expectedMaxReturnSize = Math.max((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxReturnSize());
        long expectedRetainedSize = (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + child.calculateRetainedSizeAfterCallingNext();
        NodePathsCountOperator operator = new NodePathsCountOperator((OperatorContext)Mockito.mock(OperatorContext.class), child);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void NodeManageMemoryMergeOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
        long expectedMaxPeekMemory = Math.max(2L * (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxPeekMemory());
        long expectedMaxReturnSize = Math.max((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxReturnSize());
        long expectedRetainedSize = (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + child.calculateRetainedSizeAfterCallingNext();
        NodeManageMemoryMergeOperator operator = new NodeManageMemoryMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), Collections.emptySet(), child);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seriesAggregationScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
            TypeProvider typeProvider = new TypeProvider();
            typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
            typeProvider.setType("min_time(root.sg.d1.s1)", TSDataType.INT64);
            typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
            List<AggregationDescriptor> aggregationDescriptors1 = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator1 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors1, null, typeProvider);
            long expectedMaxReturnSize = 529L;
            long cachedRawDataSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L;
            Assert.assertEquals((long)(expectedMaxReturnSize + cachedRawDataSize), (long)seriesAggregationScanOperator1.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator1.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)seriesAggregationScanOperator1.calculateRetainedSizeAfterCallingNext());
            List<AggregationDescriptor> aggregationDescriptors2 = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator2 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors2, null, typeProvider);
            expectedMaxReturnSize = 538L;
            cachedRawDataSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L;
            Assert.assertEquals((long)(expectedMaxReturnSize + cachedRawDataSize), (long)seriesAggregationScanOperator2.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator2.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)seriesAggregationScanOperator2.calculateRetainedSizeAfterCallingNext());
            long maxTsBlockLineNumber = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
            GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 2L * maxTsBlockLineNumber, new TimeDuration(0, maxTsBlockLineNumber / 100L), new TimeDuration(0, maxTsBlockLineNumber / 100L), true);
            List<AggregationDescriptor> aggregationDescriptors3 = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator3 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors3, groupByTimeParameter, typeProvider);
            expectedMaxReturnSize = 105800L;
            cachedRawDataSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L;
            Assert.assertEquals((long)(expectedMaxReturnSize + cachedRawDataSize), (long)seriesAggregationScanOperator3.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator3.calculateMaxReturnSize());
            Assert.assertEquals((long)cachedRawDataSize, (long)seriesAggregationScanOperator3.calculateRetainedSizeAfterCallingNext());
            groupByTimeParameter = new GroupByTimeParameter(0L, 2L * maxTsBlockLineNumber, new TimeDuration(0, 1L), new TimeDuration(0, 1L), true);
            List<AggregationDescriptor> aggregationDescriptors4 = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator4 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors4, groupByTimeParameter, typeProvider);
            expectedMaxReturnSize = Math.min((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, maxTsBlockLineNumber * 529L);
            cachedRawDataSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L;
            Assert.assertEquals((long)(expectedMaxReturnSize + cachedRawDataSize), (long)seriesAggregationScanOperator4.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator4.calculateMaxReturnSize());
            Assert.assertEquals((long)cachedRawDataSize, (long)seriesAggregationScanOperator4.calculateRetainedSizeAfterCallingNext());
            groupByTimeParameter = new GroupByTimeParameter(0L, 2L * maxTsBlockLineNumber, new TimeDuration(0, 1L), new TimeDuration(0, 1L), true);
            List<AggregationDescriptor> aggregationDescriptors5 = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator5 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors5, groupByTimeParameter, typeProvider);
            expectedMaxReturnSize = DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
            cachedRawDataSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L;
            Assert.assertEquals((long)(expectedMaxReturnSize + cachedRawDataSize), (long)seriesAggregationScanOperator5.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator5.calculateMaxReturnSize());
            Assert.assertEquals((long)cachedRawDataSize, (long)seriesAggregationScanOperator5.calculateRetainedSizeAfterCallingNext());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    private SeriesAggregationScanOperator createSeriesAggregationScanOperator(ExecutorService instanceNotificationExecutor, MeasurementPath measurementPath, List<AggregationDescriptor> aggregationDescriptors, GroupByTimeParameter groupByTimeParameter, TypeProvider typeProvider) throws IllegalPathException {
        HashSet allSensors = Sets.newHashSet((Object[])new String[]{"s1"});
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        PlanNodeId planNodeId = new PlanNodeId("1");
        driverContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createBuiltinAccumulator((TAggregationType)o.getAggregationType(), Collections.singletonList(measurementPath.getSeriesType()), Collections.emptyList(), Collections.emptyMap(), (boolean)true), o.getStep())));
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors((Set)allSensors);
        return new SeriesAggregationScanOperator(planNodeId, (PartialPath)measurementPath, Ordering.ASC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators, timeRangeIterator, groupByTimeParameter, maxReturnSize);
    }

    @Test
    public void rawDataAggregationOperatorTest() throws IllegalPathException {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
        TypeProvider typeProvider = new TypeProvider();
        typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
        typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
        List<AggregationDescriptor> aggregationDescriptors = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createBuiltinAccumulator((TAggregationType)o.getAggregationType(), Collections.singletonList(measurementPath.getSeriesType()), Collections.emptyList(), Collections.emptyMap(), (boolean)true), o.getStep())));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 1000L, new TimeDuration(0, 10L), new TimeDuration(0, 10L), true);
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)false);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        TimeWindowParameter windowParameter = new TimeWindowParameter(false);
        RawDataAggregationOperator rawDataAggregationOperator = new RawDataAggregationOperator((OperatorContext)Mockito.mock(OperatorContext.class), aggregators, timeRangeIterator, child, true, maxReturnSize, (WindowParameter)windowParameter);
        long expectedMaxReturnSize = 52900L;
        long expectedMaxRetainSize = child.calculateMaxReturnSize();
        Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)rawDataAggregationOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)rawDataAggregationOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)rawDataAggregationOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void slidingWindowAggregationOperatorTest() throws IllegalPathException {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
        TypeProvider typeProvider = new TypeProvider();
        typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
        typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
        List<AggregationDescriptor> aggregationDescriptors = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createBuiltinAccumulator((TAggregationType)o.getAggregationType(), Collections.singletonList(measurementPath.getSeriesType()), Collections.emptyList(), Collections.emptyMap(), (boolean)true), o.getStep())));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 1000L, new TimeDuration(0, 10L), new TimeDuration(0, 5L), true);
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)false);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        SlidingWindowAggregationOperator slidingWindowAggregationOperator = new SlidingWindowAggregationOperator((OperatorContext)Mockito.mock(OperatorContext.class), aggregators, timeRangeIterator, child, true, false, groupByTimeParameter, maxReturnSize);
        long expectedMaxReturnSize = 105800L;
        long expectedMaxRetainSize = child.calculateMaxReturnSize();
        Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)slidingWindowAggregationOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)slidingWindowAggregationOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)slidingWindowAggregationOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void aggregationOperatorTest() throws IllegalPathException {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedChildrenRetainedSize = 0L;
        long expectedMaxRetainSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)65536L);
            expectedChildrenRetainedSize += 65536L;
            expectedMaxRetainSize += 65536L;
            children.add(child);
        }
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
        TypeProvider typeProvider = new TypeProvider();
        typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
        typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
        List<AggregationDescriptor> aggregationDescriptors = Arrays.asList(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createBuiltinAccumulator((TAggregationType)o.getAggregationType(), Collections.singletonList(measurementPath.getSeriesType()), Collections.emptyList(), Collections.emptyMap(), (boolean)true), o.getStep())));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 1000L, new TimeDuration(0, 10L), new TimeDuration(0, 10L), true);
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)false);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        AggregationOperator aggregationOperator = new AggregationOperator((OperatorContext)Mockito.mock(OperatorContext.class), aggregators, timeRangeIterator, children, false, maxReturnSize);
        long expectedMaxReturnSize = 52900L;
        Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize + expectedChildrenRetainedSize), (long)aggregationOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)aggregationOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxRetainSize + expectedChildrenRetainedSize), (long)aggregationOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void intoOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemoryWithCounter()).thenReturn((Object)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
        long statementSizePerLine1 = 537008L;
        IntoOperator intoOperator1 = this.createIntoOperator(child, statementSizePerLine1);
        int expectedMaxRowNumber = 195;
        long expectedMaxStatementSize = (long)expectedMaxRowNumber * statementSizePerLine1;
        Assert.assertEquals((long)expectedMaxRowNumber, (long)intoOperator1.getMaxRowNumberInStatement());
        Assert.assertEquals((long)(expectedMaxStatementSize + 3L * (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator1.calculateMaxPeekMemory());
        Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)intoOperator1.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxStatementSize + (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator1.calculateRetainedSizeAfterCallingNext());
        long statementSizePerLine2 = 25008L;
        IntoOperator intoOperator2 = this.createIntoOperator(child, statementSizePerLine2);
        expectedMaxRowNumber = 4192;
        expectedMaxStatementSize = (long)expectedMaxRowNumber * statementSizePerLine2;
        Assert.assertEquals((long)expectedMaxRowNumber, (long)intoOperator2.getMaxRowNumberInStatement());
        Assert.assertEquals((long)(expectedMaxStatementSize + 3L * (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator2.calculateMaxPeekMemory());
        Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)intoOperator2.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxStatementSize + (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator2.calculateRetainedSizeAfterCallingNext());
        long statementSizePerLine3 = 2508L;
        IntoOperator intoOperator3 = this.createIntoOperator(child, statementSizePerLine3);
        expectedMaxRowNumber = 10000;
        expectedMaxStatementSize = (long)expectedMaxRowNumber * statementSizePerLine3;
        Assert.assertEquals((long)expectedMaxRowNumber, (long)intoOperator3.getMaxRowNumberInStatement());
        Assert.assertEquals((long)(expectedMaxStatementSize + 3L * (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator3.calculateMaxPeekMemory());
        Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)intoOperator3.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxStatementSize + (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator3.calculateRetainedSizeAfterCallingNext());
        long statementSizePerLine4 = 537000008L;
        IntoOperator intoOperator4 = this.createIntoOperator(child, statementSizePerLine4);
        expectedMaxRowNumber = 1;
        expectedMaxStatementSize = (long)expectedMaxRowNumber * statementSizePerLine4;
        Assert.assertEquals((long)expectedMaxRowNumber, (long)intoOperator4.getMaxRowNumberInStatement());
        Assert.assertEquals((long)(expectedMaxStatementSize + 3L * (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator4.calculateMaxPeekMemory());
        Assert.assertEquals((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)intoOperator4.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxStatementSize + (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)intoOperator4.calculateRetainedSizeAfterCallingNext());
    }

    private IntoOperator createIntoOperator(Operator child, long statementSizePerLine) {
        return new IntoOperator((OperatorContext)Mockito.mock(OperatorContext.class), child, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), null, statementSizePerLine);
    }
}

