/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.DeviceViewOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.MergeSortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.SingleDeviceViewOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.SortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.MergeSortComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.ShowQueriesOperator;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class MergeSortOperatorTest {
    private static final String MERGE_SORT_OPERATOR_TEST_SG = "root.MergeSortOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private static final String DEVICE0 = "root.MergeSortOperatorTest.device0";
    private static final String DEVICE1 = "root.MergeSortOperatorTest.device1";
    private static final String DEVICE2 = "root.MergeSortOperatorTest.device2";
    private static final String DEVICE3 = "root.MergeSortOperatorTest.device3";
    private int dataNodeId;
    @Mock
    Operator childOperator1 = (Operator)Mockito.mock(Operator.class);
    @Mock
    Operator childOperator2 = (Operator)Mockito.mock(Operator.class);

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        this.dataNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
        IoTDBDescriptor.getInstance().getConfig().setDataNodeId(0);
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, MERGE_SORT_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        IoTDBDescriptor.getInstance().getConfig().setDataNodeId(this.dataNodeId);
    }

    long getValue(long expectedTime) {
        if (expectedTime < 200L) {
            return 20000L + expectedTime;
        }
        if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
            return 10000L + expectedTime;
        }
        return expectedTime;
    }

    public MergeSortOperator mergeSortOperatorTest(Ordering timeOrdering, Ordering deviceOrdering) {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId5, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(6, new PlanNodeId("6"), SingleDeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(7, new PlanNodeId("7"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(8, new PlanNodeId("8"), SingleDeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(9, new PlanNodeId("9"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(10, new PlanNodeId("10"), SingleDeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(11, new PlanNodeId("11"), MergeSortOperator.class.getSimpleName());
            MeasurementPath measurementPath1 = new MeasurementPath("root.MergeSortOperatorTest.device0.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.MergeSortOperatorTest.device1.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath3 = new MeasurementPath("root.MergeSortOperatorTest.device1.sensor1", TSDataType.INT32);
            MeasurementPath measurementPath4 = new MeasurementPath("root.MergeSortOperatorTest.device2.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath5 = new MeasurementPath("root.MergeSortOperatorTest.device2.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath1));
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath2));
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(2), planNodeId3, (PartialPath)measurementPath3, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath3));
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator4 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(3), planNodeId4, (PartialPath)measurementPath4, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath4));
            seriesScanOperator4.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator4.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator5 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(4), planNodeId5, (PartialPath)measurementPath5, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath5));
            seriesScanOperator5.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator5.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            LinkedList<TSDataType> tsDataTypes = new LinkedList<TSDataType>(Arrays.asList(TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32));
            SingleDeviceViewOperator singleDeviceViewOperator1 = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(5), DEVICE0, (Operator)seriesScanOperator1, Collections.singletonList(1), tsDataTypes);
            FullOuterTimeJoinOperator timeJoinOperator1 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(6), Arrays.asList(seriesScanOperator2, seriesScanOperator3), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SingleDeviceViewOperator singleDeviceViewOperator2 = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(7), DEVICE1, (Operator)timeJoinOperator1, Arrays.asList(2, 3), tsDataTypes);
            FullOuterTimeJoinOperator timeJoinOperator2 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(8), Arrays.asList(seriesScanOperator4, seriesScanOperator5), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SingleDeviceViewOperator singleDeviceViewOperator3 = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(9), DEVICE2, (Operator)timeJoinOperator2, Arrays.asList(4, 5), tsDataTypes);
            MergeSortOperator mergeSortOperator = new MergeSortOperator((OperatorContext)driverContext.getOperatorContexts().get(10), Arrays.asList(singleDeviceViewOperator1, singleDeviceViewOperator2, singleDeviceViewOperator3), tsDataTypes, MergeSortComparator.getComparator(Arrays.asList(new SortItem("TIME", timeOrdering), new SortItem("DEVICE", deviceOrdering)), Arrays.asList(-1, 0), Arrays.asList(TSDataType.INT64, TSDataType.TEXT)));
            mergeSortOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            return mergeSortOperator;
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
            return null;
        }
    }

    @Test
    public void testOrderByTime1() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest(Ordering.ASC, Ordering.ASC);
        long lastTime = -1L;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)6L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) >= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(3).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(4).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(5).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)1500L, (long)count);
    }

    @Test
    public void testOrderByTime2() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest(Ordering.ASC, Ordering.DESC);
        long lastTime = -1L;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)6L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) >= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(4).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(5).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(3).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)1500L, (long)count);
    }

    @Test
    public void testOrderByTime3() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest(Ordering.DESC, Ordering.DESC);
        long lastTime = Long.MAX_VALUE;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)6L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) <= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(4).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(5).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(3).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)1500L, (long)count);
    }

    @Test
    public void testOrderByTime4() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest(Ordering.DESC, Ordering.ASC);
        long lastTime = Long.MAX_VALUE;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)6L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) <= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(3).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(i));
                    Assert.assertEquals((long)tsBlock.getColumn(4).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(5).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)1500L, (long)count);
    }

    public MergeSortOperator mergeSortOperatorTest2(Ordering timeOrdering, Ordering deviceOrdering) {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId5, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId6 = new PlanNodeId("6");
            driverContext.addOperatorContext(6, planNodeId6, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId7 = new PlanNodeId("7");
            driverContext.addOperatorContext(7, planNodeId7, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(8, new PlanNodeId("8"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(9, new PlanNodeId("9"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(10, new PlanNodeId("10"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(11, new PlanNodeId("11"), SingleDeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(12, new PlanNodeId("12"), SingleDeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(13, new PlanNodeId("13"), SingleDeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(14, new PlanNodeId("14"), SingleDeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(15, new PlanNodeId("15"), MergeSortOperator.class.getSimpleName());
            driverContext.addOperatorContext(16, new PlanNodeId("16"), MergeSortOperator.class.getSimpleName());
            driverContext.addOperatorContext(17, new PlanNodeId("17"), MergeSortOperator.class.getSimpleName());
            MeasurementPath measurementPath1 = new MeasurementPath("root.MergeSortOperatorTest.device0.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.MergeSortOperatorTest.device1.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath3 = new MeasurementPath("root.MergeSortOperatorTest.device1.sensor1", TSDataType.INT32);
            MeasurementPath measurementPath4 = new MeasurementPath("root.MergeSortOperatorTest.device2.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath5 = new MeasurementPath("root.MergeSortOperatorTest.device2.sensor1", TSDataType.INT32);
            MeasurementPath measurementPath6 = new MeasurementPath("root.MergeSortOperatorTest.device3.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath7 = new MeasurementPath("root.MergeSortOperatorTest.device3.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath1));
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath2));
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(2), planNodeId3, (PartialPath)measurementPath3, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath3));
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator4 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(3), planNodeId4, (PartialPath)measurementPath4, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath4));
            seriesScanOperator4.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator4.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator5 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(4), planNodeId5, (PartialPath)measurementPath5, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath5));
            seriesScanOperator5.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator5.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator6 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(5), planNodeId6, (PartialPath)measurementPath6, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath6));
            seriesScanOperator6.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator6.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator7 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(6), planNodeId7, (PartialPath)measurementPath7, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath7));
            seriesScanOperator7.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator7.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            LinkedList<TSDataType> tsDataTypes = new LinkedList<TSDataType>(Arrays.asList(TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32));
            FullOuterTimeJoinOperator timeJoinOperator1 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(7), Arrays.asList(seriesScanOperator2, seriesScanOperator3), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator2 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(8), Arrays.asList(seriesScanOperator4, seriesScanOperator5), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator3 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(9), Arrays.asList(seriesScanOperator6, seriesScanOperator7), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SingleDeviceViewOperator singleDeviceViewOperator1 = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(10), DEVICE0, (Operator)seriesScanOperator1, Collections.singletonList(1), tsDataTypes);
            SingleDeviceViewOperator singleDeviceViewOperator2 = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(11), DEVICE1, (Operator)timeJoinOperator1, Arrays.asList(1, 2), tsDataTypes);
            SingleDeviceViewOperator singleDeviceViewOperator3 = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(12), DEVICE2, (Operator)timeJoinOperator2, Arrays.asList(1, 2), tsDataTypes);
            SingleDeviceViewOperator singleDeviceViewOperator4 = new SingleDeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(13), DEVICE3, (Operator)timeJoinOperator3, Arrays.asList(1, 2), tsDataTypes);
            MergeSortOperator mergeSortOperator1 = new MergeSortOperator((OperatorContext)driverContext.getOperatorContexts().get(14), Arrays.asList(singleDeviceViewOperator1, singleDeviceViewOperator2), tsDataTypes, MergeSortComparator.getComparator(Arrays.asList(new SortItem("TIME", timeOrdering), new SortItem("DEVICE", deviceOrdering)), Arrays.asList(-1, 0), Arrays.asList(TSDataType.INT64, TSDataType.TEXT)));
            mergeSortOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MergeSortOperator mergeSortOperator2 = new MergeSortOperator((OperatorContext)driverContext.getOperatorContexts().get(15), Arrays.asList(singleDeviceViewOperator3, singleDeviceViewOperator4), tsDataTypes, MergeSortComparator.getComparator(Arrays.asList(new SortItem("TIME", timeOrdering), new SortItem("DEVICE", deviceOrdering)), Arrays.asList(-1, 0), Arrays.asList(TSDataType.INT64, TSDataType.TEXT)));
            mergeSortOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MergeSortOperator mergeSortOperator = new MergeSortOperator((OperatorContext)driverContext.getOperatorContexts().get(16), Arrays.asList(mergeSortOperator1, mergeSortOperator2), tsDataTypes, MergeSortComparator.getComparator(Arrays.asList(new SortItem("TIME", timeOrdering), new SortItem("DEVICE", deviceOrdering)), Arrays.asList(-1, 0), Arrays.asList(TSDataType.INT64, TSDataType.TEXT)));
            mergeSortOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            return mergeSortOperator;
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
            return null;
        }
    }

    @Test
    public void testOrderByTime1_2() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest2(Ordering.ASC, Ordering.ASC);
        long lastTime = -1L;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) >= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)3L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    @Test
    public void testOrderByTime2_2() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest2(Ordering.ASC, Ordering.DESC);
        long lastTime = -1L;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) >= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertEquals((long)3L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    @Test
    public void testOrderByTime3_2() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest2(Ordering.DESC, Ordering.DESC);
        long lastTime = Long.MAX_VALUE;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) <= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertEquals((long)3L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    @Test
    public void testOrderByTime4_2() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest2(Ordering.DESC, Ordering.ASC);
        long lastTime = Long.MAX_VALUE;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) <= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertEquals((long)0L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)1L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)2L, (long)checkDevice);
                    ++checkDevice;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)3L, (long)checkDevice);
                    checkDevice = 0;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    public MergeSortOperator mergeSortOperatorTest3(Ordering timeOrdering, Ordering deviceOrdering) {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId5, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId6 = new PlanNodeId("6");
            driverContext.addOperatorContext(6, planNodeId6, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId7 = new PlanNodeId("7");
            driverContext.addOperatorContext(7, planNodeId7, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(8, new PlanNodeId("8"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(9, new PlanNodeId("9"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(10, new PlanNodeId("10"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(11, new PlanNodeId("11"), DeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(12, new PlanNodeId("12"), DeviceViewOperator.class.getSimpleName());
            driverContext.addOperatorContext(13, new PlanNodeId("13"), MergeSortOperator.class.getSimpleName());
            MeasurementPath measurementPath1 = new MeasurementPath("root.MergeSortOperatorTest.device0.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.MergeSortOperatorTest.device1.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath3 = new MeasurementPath("root.MergeSortOperatorTest.device1.sensor1", TSDataType.INT32);
            MeasurementPath measurementPath4 = new MeasurementPath("root.MergeSortOperatorTest.device2.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath5 = new MeasurementPath("root.MergeSortOperatorTest.device2.sensor1", TSDataType.INT32);
            MeasurementPath measurementPath6 = new MeasurementPath("root.MergeSortOperatorTest.device3.sensor0", TSDataType.INT32);
            MeasurementPath measurementPath7 = new MeasurementPath("root.MergeSortOperatorTest.device3.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath1));
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath2));
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(2), planNodeId3, (PartialPath)measurementPath3, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath3));
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator4 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(3), planNodeId4, (PartialPath)measurementPath4, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath4));
            seriesScanOperator4.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator4.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator5 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(4), planNodeId5, (PartialPath)measurementPath5, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath5));
            seriesScanOperator5.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator5.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator6 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(5), planNodeId6, (PartialPath)measurementPath6, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath6));
            seriesScanOperator6.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator6.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            SeriesScanOperator seriesScanOperator7 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(6), planNodeId7, (PartialPath)measurementPath7, timeOrdering, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)measurementPath7));
            seriesScanOperator7.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesScanOperator7.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            LinkedList<TSDataType> tsDataTypes = new LinkedList<TSDataType>(Arrays.asList(TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32));
            FullOuterTimeJoinOperator timeJoinOperator1 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(7), Arrays.asList(seriesScanOperator2, seriesScanOperator3), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator2 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(8), Arrays.asList(seriesScanOperator4, seriesScanOperator5), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator3 = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(9), Arrays.asList(seriesScanOperator6, seriesScanOperator7), timeOrdering, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator())), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()))), (TimeComparator)(timeOrdering == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
            timeJoinOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            ArrayList<String> devices = new ArrayList<String>(Arrays.asList(DEVICE0, DEVICE1, DEVICE2, DEVICE3));
            if (deviceOrdering == Ordering.DESC) {
                Collections.reverse(devices);
            }
            ArrayList<List<Integer>> deviceColumnIndex = new ArrayList<List<Integer>>();
            deviceColumnIndex.add(Collections.singletonList(1));
            deviceColumnIndex.add(Arrays.asList(1, 2));
            if (deviceOrdering == Ordering.DESC) {
                Collections.reverse(deviceColumnIndex);
            }
            DeviceViewOperator deviceViewOperator1 = new DeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(10), deviceOrdering == Ordering.ASC ? Arrays.asList(DEVICE0, DEVICE1) : Arrays.asList(DEVICE1, DEVICE0), deviceOrdering == Ordering.ASC ? Arrays.asList(seriesScanOperator1, timeJoinOperator1) : Arrays.asList(timeJoinOperator1, seriesScanOperator1), deviceColumnIndex, tsDataTypes);
            deviceColumnIndex = new ArrayList();
            deviceColumnIndex.add(Arrays.asList(1, 2));
            deviceColumnIndex.add(Arrays.asList(1, 2));
            DeviceViewOperator deviceViewOperator2 = new DeviceViewOperator((OperatorContext)driverContext.getOperatorContexts().get(11), deviceOrdering == Ordering.ASC ? Arrays.asList(DEVICE2, DEVICE3) : Arrays.asList(DEVICE3, DEVICE2), deviceOrdering == Ordering.ASC ? Arrays.asList(timeJoinOperator2, timeJoinOperator3) : Arrays.asList(timeJoinOperator3, timeJoinOperator2), deviceColumnIndex, tsDataTypes);
            MergeSortOperator mergeSortOperator = new MergeSortOperator((OperatorContext)driverContext.getOperatorContexts().get(12), Arrays.asList(deviceViewOperator1, deviceViewOperator2), tsDataTypes, MergeSortComparator.getComparator(Arrays.asList(new SortItem("DEVICE", deviceOrdering), new SortItem("TIME", timeOrdering)), Arrays.asList(0, -1), Arrays.asList(TSDataType.TEXT, TSDataType.INT64)));
            mergeSortOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            return mergeSortOperator;
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
            return null;
        }
    }

    @Test
    public void testOrderByDevice1() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest3(Ordering.ASC, Ordering.ASC);
        long lastTime = -1L;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) >= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((checkDevice < 500 ? 1 : 0) != 0);
                    if (++checkDevice != 500) continue;
                    lastTime = -1L;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 500 && checkDevice < 1000 ? 1 : 0) != 0);
                    if (++checkDevice != 1000) continue;
                    lastTime = -1L;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 1000 && checkDevice < 1500 ? 1 : 0) != 0);
                    if (++checkDevice != 1500) continue;
                    lastTime = -1L;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 1500 && checkDevice < 2000 ? 1 : 0) != 0);
                    ++checkDevice;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    @Test
    public void testOrderByDevice2() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest3(Ordering.ASC, Ordering.DESC);
        long lastTime = -1L;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) >= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice < 500 ? 1 : 0) != 0);
                    if (++checkDevice != 500) continue;
                    lastTime = -1L;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 500 && checkDevice < 1000 ? 1 : 0) != 0);
                    if (++checkDevice != 1000) continue;
                    lastTime = -1L;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 1000 && checkDevice < 1500 ? 1 : 0) != 0);
                    if (++checkDevice != 1500) continue;
                    lastTime = -1L;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((checkDevice >= 1500 && checkDevice < 2000 ? 1 : 0) != 0);
                    ++checkDevice;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    @Test
    public void testOrderByDevice3() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest3(Ordering.DESC, Ordering.ASC);
        long lastTime = Long.MAX_VALUE;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) <= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((checkDevice < 500 ? 1 : 0) != 0);
                    if (++checkDevice != 500) continue;
                    lastTime = Long.MAX_VALUE;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 500 && checkDevice < 1000 ? 1 : 0) != 0);
                    if (++checkDevice != 1000) continue;
                    lastTime = Long.MAX_VALUE;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 1000 && checkDevice < 1500 ? 1 : 0) != 0);
                    if (++checkDevice != 1500) continue;
                    lastTime = Long.MAX_VALUE;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 1500 && checkDevice < 2000 ? 1 : 0) != 0);
                    ++checkDevice;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    @Test
    public void testOrderByDevice4() throws Exception {
        MergeSortOperator mergeSortOperator = this.mergeSortOperatorTest3(Ordering.DESC, Ordering.DESC);
        long lastTime = Long.MAX_VALUE;
        int checkDevice = 0;
        int count = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock tsBlock = mergeSortOperator.next();
            if (tsBlock == null) continue;
            Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
            count += tsBlock.getPositionCount();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                Assert.assertTrue((tsBlock.getTimeByIndex(i) <= lastTime ? 1 : 0) != 0);
                lastTime = tsBlock.getTimeByIndex(i);
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE3)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice < 500 ? 1 : 0) != 0);
                    if (++checkDevice != 500) continue;
                    lastTime = Long.MAX_VALUE;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE2)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 500 && checkDevice < 1000 ? 1 : 0) != 0);
                    if (++checkDevice != 1000) continue;
                    lastTime = Long.MAX_VALUE;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE1)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertEquals((long)tsBlock.getColumn(2).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((checkDevice >= 1000 && checkDevice < 1500 ? 1 : 0) != 0);
                    if (++checkDevice != 1500) continue;
                    lastTime = Long.MAX_VALUE;
                    continue;
                }
                if (Objects.equals(tsBlock.getColumn(0).getBinary(i).toString(), DEVICE0)) {
                    Assert.assertEquals((long)tsBlock.getColumn(1).getInt(i), (long)this.getValue(lastTime));
                    Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                    Assert.assertTrue((checkDevice >= 1500 && checkDevice < 2000 ? 1 : 0) != 0);
                    ++checkDevice;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mergeSortWithSortOperatorTest() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId0 = new PlanNodeId("0");
            driverContext.addOperatorContext(0, planNodeId0, ShowQueriesOperator.class.getSimpleName());
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, ShowQueriesOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SortOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SortOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, MergeSortOperator.class.getSimpleName());
            List operatorContexts = driverContext.getOperatorContexts();
            List dataTypes = DatasetHeaderFactory.getShowQueriesHeader().getRespDataTypes();
            Comparator comparator = MergeSortComparator.getComparator(Arrays.asList(new SortItem("TIME", Ordering.ASC), new SortItem("DATANODEID", Ordering.DESC)), (List)ImmutableList.of((Object)-1, (Object)1), (List)ImmutableList.of((Object)TSDataType.INT64, (Object)TSDataType.INT32));
            Coordinator coordinator1 = (Coordinator)Mockito.mock(Coordinator.class);
            Mockito.when((Object)coordinator1.getAllQueryExecutions()).thenReturn((Object)ImmutableList.of((Object)new FakeQueryExecution(3L, "20221229_000000_00003_1", "sql3_node1"), (Object)new FakeQueryExecution(1L, "20221229_000000_00001_1", "sql1_node1"), (Object)new FakeQueryExecution(2L, "20221229_000000_00002_1", "sql2_node1")));
            Coordinator coordinator2 = (Coordinator)Mockito.mock(Coordinator.class);
            Mockito.when((Object)coordinator2.getAllQueryExecutions()).thenReturn((Object)ImmutableList.of((Object)new FakeQueryExecution(3L, "20221229_000000_00003_2", "sql3_node2"), (Object)new FakeQueryExecution(2L, "20221229_000000_00002_2", "sql2_node2"), (Object)new FakeQueryExecution(1L, "20221229_000000_00001_2", "sql1_node2")));
            ShowQueriesOperator showQueriesOperator1 = new ShowQueriesOperator((OperatorContext)operatorContexts.get(0), planNodeId0, coordinator1);
            ShowQueriesOperator showQueriesOperator2 = new ShowQueriesOperator((OperatorContext)operatorContexts.get(1), planNodeId1, coordinator2);
            final SortOperator sortOperator1 = new SortOperator((OperatorContext)operatorContexts.get(2), (Operator)showQueriesOperator1, dataTypes, "", comparator);
            final SortOperator sortOperator2 = new SortOperator((OperatorContext)operatorContexts.get(3), (Operator)showQueriesOperator2, dataTypes, "", comparator);
            MergeSortOperator root = new MergeSortOperator((OperatorContext)operatorContexts.get(4), (List)new ArrayList<Operator>(){
                {
                    this.add(sortOperator1);
                    this.add(sortOperator2);
                }
            }, dataTypes, comparator);
            root.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            int index = 0;
            long[] expectedTime = new long[]{1L, 1L, 2L, 2L, 3L, 3L};
            String[] expectedQueryId = new String[]{"20221229_000000_00001_2", "20221229_000000_00001_1", "20221229_000000_00002_2", "20221229_000000_00002_1", "20221229_000000_00003_2", "20221229_000000_00003_1"};
            int[] expectedDataNodeId = new int[]{2, 1, 2, 1, 2, 1};
            String[] expectedStatement = new String[]{"sql1_node2", "sql1_node1", "sql2_node2", "sql2_node1", "sql3_node2", "sql3_node1"};
            while (root.isBlocked().isDone() && root.hasNext()) {
                TsBlock result = root.next();
                if (result == null) continue;
                int i = 0;
                while (i < result.getPositionCount()) {
                    Assert.assertEquals((long)expectedTime[index], (long)result.getTimeColumn().getLong(i));
                    Assert.assertEquals((Object)expectedQueryId[index], (Object)result.getColumn(0).getBinary(i).toString());
                    Assert.assertEquals((long)expectedDataNodeId[index], (long)result.getColumn(1).getInt(i));
                    Assert.assertEquals((Object)expectedStatement[index], (Object)result.getColumn(3).getBinary(i).toString());
                    ++i;
                    ++index;
                }
            }
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    private TsBlock[] constructOutput(long[] time) {
        TsBlockBuilder tsBlockBuilder1 = new TsBlockBuilder(3, Collections.singletonList(TSDataType.INT64));
        TimeColumnBuilder timeColumnBuilder = tsBlockBuilder1.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = tsBlockBuilder1.getValueColumnBuilders();
        for (int i = 0; i < time.length / 2; ++i) {
            timeColumnBuilder.writeLong(time[i]);
            for (ColumnBuilder columnBuilder : columnBuilders) {
                columnBuilder.writeLong(time[i]);
            }
            tsBlockBuilder1.declarePosition();
        }
        TsBlock tsBlock1 = tsBlockBuilder1.build();
        TsBlockBuilder tsBlockBuilder2 = new TsBlockBuilder(3, Collections.singletonList(TSDataType.INT64));
        timeColumnBuilder = tsBlockBuilder2.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders2 = tsBlockBuilder2.getValueColumnBuilders();
        for (int i = time.length / 2; i < time.length; ++i) {
            timeColumnBuilder.writeLong(time[i]);
            for (ColumnBuilder columnBuilder : columnBuilders2) {
                columnBuilder.writeLong(time[i]);
            }
            tsBlockBuilder2.declarePosition();
        }
        TsBlock tsBlock2 = tsBlockBuilder2.build();
        return new TsBlock[]{tsBlock1, tsBlock2};
    }

    @Test
    public void mergeSortTest() throws Exception {
        AtomicInteger count1 = new AtomicInteger(0);
        AtomicInteger count2 = new AtomicInteger(0);
        long[] time1 = new long[]{1L, 2L, 3L, 4L, 5L, 6L};
        long[] time2 = new long[]{3L, 3L, 6L, 7L, 8L, 9L};
        long[] ans = new long[]{1L, 2L, 3L, 3L, 3L, 4L, 5L, 6L, 6L, 7L, 8L, 9L};
        TsBlock[] tsBlocks1 = this.constructOutput(time1);
        TsBlock[] tsBlocks2 = this.constructOutput(time2);
        ListenableFuture mockFuture = (ListenableFuture)Mockito.mock(ListenableFuture.class);
        ((Operator)Mockito.doReturn((Object)mockFuture).when((Object)this.childOperator1)).isBlocked();
        ((Operator)Mockito.doReturn((Object)mockFuture).when((Object)this.childOperator2)).isBlocked();
        Mockito.when((Object)mockFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)this.childOperator1.nextWithTimer()).thenAnswer(invocationOnMock -> {
            int count = count1.getAndIncrement();
            if (count == 0) {
                return tsBlocks1[0];
            }
            if (count == 1) {
                return tsBlocks1[1];
            }
            return null;
        });
        Mockito.when((Object)this.childOperator2.nextWithTimer()).thenAnswer(invocationOnMock -> {
            int count = count2.getAndIncrement();
            if (count == 0) {
                return tsBlocks2[0];
            }
            if (count == 1) {
                return tsBlocks2[1];
            }
            return null;
        });
        Mockito.when((Object)this.childOperator1.hasNextWithTimer()).thenAnswer(invocationOnMock -> {
            int count = count1.get();
            return count < 2;
        });
        Mockito.when((Object)this.childOperator2.hasNextWithTimer()).thenAnswer(invocationOnMock -> {
            int count = count2.get();
            return count < 2;
        });
        QueryId queryId = new QueryId("stub_query");
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        driverContext.addOperatorContext(1, planNodeId1, MergeSortOperator.class.getSimpleName());
        MergeSortOperator mergeSortOperator = new MergeSortOperator((OperatorContext)driverContext.getOperatorContexts().get(0), Arrays.asList(this.childOperator1, this.childOperator2), Collections.singletonList(TSDataType.INT64), MergeSortComparator.getComparator(Collections.singletonList(new SortItem("TIME", Ordering.ASC)), Collections.singletonList(-1), Collections.singletonList(TSDataType.INT64)));
        mergeSortOperator.getOperatorContext();
        OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
        int index = 0;
        while (mergeSortOperator.isBlocked().isDone() && mergeSortOperator.hasNext()) {
            TsBlock result = mergeSortOperator.next();
            for (int i = 0; i < result.getPositionCount(); ++i) {
                long time = result.getTimeByIndex(i);
                Assert.assertEquals((long)time, (long)ans[index++]);
            }
        }
        Assert.assertEquals((long)index, (long)ans.length);
    }

    static class FakeQueryExecution
    implements IQueryExecution {
        private final long startTime;
        private final String queryId;
        private final String sql;

        FakeQueryExecution(long startTime, String queryId, String sql) {
            this.startTime = startTime;
            this.queryId = queryId;
            this.sql = sql;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public long getStartExecutionTime() {
            return this.startTime;
        }

        public void recordExecutionTime(long executionTime) {
        }

        public long getTotalExecutionTime() {
            return 0L;
        }

        public Optional<String> getExecuteSQL() {
            return Optional.of(this.sql);
        }

        public String getStatementType() {
            return null;
        }

        public void start() {
        }

        public void stop(Throwable t) {
        }

        public void stopAndCleanup() {
        }

        public void stopAndCleanup(Throwable t) {
        }

        public void cancel() {
        }

        public ExecutionResult getStatus() {
            return null;
        }

        public Optional<TsBlock> getBatchResult() {
            return Optional.empty();
        }

        public Optional<ByteBuffer> getByteBufferBatchResult() {
            return Optional.empty();
        }

        public boolean hasNextResult() {
            return false;
        }

        public int getOutputValueColumnCount() {
            return 0;
        }

        public DatasetHeader getDatasetHeader() {
            return null;
        }

        public boolean isQuery() {
            return false;
        }
    }
}

