/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.LinearFillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.identity.IdentityLinearFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear.FloatLinearFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear.LinearFill;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.junit.Assert;
import org.junit.Test;

public class LinearFillOperatorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchLinearFillTest1() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, LinearFillOperator.class.getSimpleName());
            LinearFill[] fillArray = new LinearFill[]{new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill()};
            LinearFillOperator fillOperator = new LinearFillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), (ILinearFill[])fillArray, new Operator(){
                private int index = 0;
                private final float[][][] value = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 0.0f}, {21.0f, 22.0f, 0.0f, 0.0f}, {0.0f, 32.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 43.0f, 0.0f}}, new float[][]{{51.0f, 0.0f, 53.0f, 0.0f}, {61.0f, 62.0f, 63.0f, 0.0f}, {71.0f, 72.0f, 0.0f, 74.0f}, {0.0f, 82.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 93.0f, 0.0f}}, new float[][]{{101.0f, 0.0f, 103.0f, 0.0f}, {111.0f, 112.0f, 113.0f, 114.0f}, {121.0f, 122.0f, 0.0f, 124.0f}, {0.0f, 132.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 143.0f, 0.0f}}};
                final boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, true}, {false, false, true, true}, {true, false, true, true}, {true, true, false, true}}, new boolean[][]{{false, true, false, true}, {false, false, false, true}, {false, false, true, false}, {true, false, true, true}, {true, true, false, true}}, new boolean[][]{{false, true, false, true}, {false, false, false, false}, {false, false, true, false}, {true, false, true, true}, {true, true, false, true}}};

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT));
                    for (int i = 0; i < 5; ++i) {
                        builder.getTimeColumnBuilder().writeLong((long)i + (long)this.index * 5L);
                        for (int j = 0; j < 4; ++j) {
                            if (this.isNull[this.index][i][j]) {
                                builder.getColumnBuilder(j).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(j).writeFloat(this.value[this.index][i][j]);
                        }
                        builder.declarePosition();
                    }
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 3;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 3;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            float[][][] res = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 14.0f}, {21.0f, 22.0f, 23.0f, 24.0f}, {31.0f, 32.0f, 33.0f, 34.0f}, {41.0f, 42.0f, 43.0f, 44.0f}}, new float[][]{{51.0f, 52.0f, 53.0f, 54.0f}, {61.0f, 62.0f, 63.0f, 64.0f}, {71.0f, 72.0f, 73.0f, 74.0f}, {81.0f, 82.0f, 83.0f, 84.0f}, {91.0f, 92.0f, 93.0f, 94.0f}}, new float[][]{{101.0f, 102.0f, 103.0f, 104.0f}, {111.0f, 112.0f, 113.0f, 114.0f}, {121.0f, 122.0f, 123.0f, 124.0f}, {0.0f, 132.0f, 133.0f, 0.0f}, {0.0f, 0.0f, 143.0f, 0.0f}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {true, false, false, true}, {true, true, false, true}}};
            boolean[] nullBlock = new boolean[]{true, false, false, false};
            int nullBlockIndex = 0;
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                Assert.assertEquals((Object)nullBlock[nullBlockIndex++], (Object)(block == null ? 1 : 0));
                if (block == null) continue;
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = (long)i + (long)count * 5L;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 4; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((float)res[count][i][j], (float)block.getColumn(j).getFloat(i), (float)1.0E-5f);
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)res.length, (long)count);
            Assert.assertEquals((long)nullBlock.length, (long)nullBlockIndex);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchLinearFillTest1OrderByDesc() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, LinearFillOperator.class.getSimpleName());
            LinearFill[] fillArray = new LinearFill[]{new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill()};
            LinearFillOperator fillOperator = new LinearFillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), (ILinearFill[])fillArray, new Operator(){
                private int index = 0;
                private final float[][][] value = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 0.0f}, {21.0f, 22.0f, 0.0f, 0.0f}, {0.0f, 32.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 43.0f, 0.0f}}, new float[][]{{51.0f, 0.0f, 53.0f, 0.0f}, {61.0f, 62.0f, 63.0f, 0.0f}, {71.0f, 72.0f, 0.0f, 74.0f}, {0.0f, 82.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 93.0f, 0.0f}}, new float[][]{{101.0f, 0.0f, 103.0f, 0.0f}, {111.0f, 112.0f, 113.0f, 114.0f}, {121.0f, 122.0f, 0.0f, 124.0f}, {0.0f, 132.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 143.0f, 0.0f}}};
                final boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, true}, {false, false, true, true}, {true, false, true, true}, {true, true, false, true}}, new boolean[][]{{false, true, false, true}, {false, false, false, true}, {false, false, true, false}, {true, false, true, true}, {true, true, false, true}}, new boolean[][]{{false, true, false, true}, {false, false, false, false}, {false, false, true, false}, {true, false, true, true}, {true, true, false, true}}};

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT));
                    for (int i = 0; i < 5; ++i) {
                        builder.getTimeColumnBuilder().writeLong((long)(4 - i) + (long)(2 - this.index) * 5L);
                        for (int j = 0; j < 4; ++j) {
                            if (this.isNull[this.index][i][j]) {
                                builder.getColumnBuilder(j).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(j).writeFloat(this.value[this.index][i][j]);
                        }
                        builder.declarePosition();
                    }
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 3;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 3;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            float[][][] res = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 14.0f}, {21.0f, 22.0f, 23.0f, 24.0f}, {31.0f, 32.0f, 33.0f, 34.0f}, {41.0f, 42.0f, 43.0f, 44.0f}}, new float[][]{{51.0f, 52.0f, 53.0f, 54.0f}, {61.0f, 62.0f, 63.0f, 64.0f}, {71.0f, 72.0f, 73.0f, 74.0f}, {81.0f, 82.0f, 83.0f, 84.0f}, {91.0f, 92.0f, 93.0f, 94.0f}}, new float[][]{{101.0f, 102.0f, 103.0f, 104.0f}, {111.0f, 112.0f, 113.0f, 114.0f}, {121.0f, 122.0f, 123.0f, 124.0f}, {0.0f, 132.0f, 133.0f, 0.0f}, {0.0f, 0.0f, 143.0f, 0.0f}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {true, false, false, true}, {true, true, false, true}}};
            boolean[] nullBlock = new boolean[]{true, false, false, false};
            int nullBlockIndex = 0;
            int count = 0;
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                Assert.assertEquals((Object)nullBlock[nullBlockIndex++], (Object)(block == null ? 1 : 0));
                if (block == null) continue;
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = (long)(block.getPositionCount() - i - 1) + (long)(res.length - count - 1) * 5L;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 4; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((float)res[count][i][j], (float)block.getColumn(j).getFloat(i), (float)1.0E-5f);
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)res.length, (long)count);
            Assert.assertEquals((long)nullBlock.length, (long)nullBlockIndex);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchLinearFillTest2() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, LinearFillOperator.class.getSimpleName());
            LinearFill[] fillArray = new LinearFill[]{new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill()};
            LinearFillOperator fillOperator = new LinearFillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), (ILinearFill[])fillArray, new Operator(){
                private int index = 0;
                private final float[][][] value = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 0.0f}, {21.0f, 22.0f, 0.0f, 0.0f}, {0.0f, 32.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{51.0f, 0.0f, 0.0f, 0.0f}, {61.0f, 62.0f, 0.0f, 0.0f}, {71.0f, 72.0f, 0.0f, 74.0f}, {0.0f, 82.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{101.0f, 0.0f, 103.0f, 0.0f}, {111.0f, 112.0f, 0.0f, 114.0f}, {121.0f, 122.0f, 0.0f, 124.0f}, {0.0f, 132.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}};
                final boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, true}, {false, false, true, true}, {true, false, true, true}, {true, true, true, true}}, new boolean[][]{{false, true, true, true}, {false, false, true, true}, {false, false, true, false}, {true, false, true, true}, {true, true, true, true}}, new boolean[][]{{false, true, false, true}, {false, false, true, false}, {false, false, true, false}, {true, false, true, true}, {true, true, true, true}}};

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT));
                    for (int i = 0; i < 5; ++i) {
                        builder.getTimeColumnBuilder().writeLong((long)i + (long)this.index * 5L);
                        for (int j = 0; j < 4; ++j) {
                            if (this.isNull[this.index][i][j]) {
                                builder.getColumnBuilder(j).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(j).writeFloat(this.value[this.index][i][j]);
                        }
                        builder.declarePosition();
                    }
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 3;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 3;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            float[][][] res = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 14.0f}, {21.0f, 22.0f, 23.0f, 24.0f}, {31.0f, 32.0f, 33.0f, 34.0f}, {41.0f, 42.0f, 43.0f, 44.0f}}, new float[][]{{51.0f, 52.0f, 53.0f, 54.0f}, {61.0f, 62.0f, 63.0f, 64.0f}, {71.0f, 72.0f, 73.0f, 74.0f}, {81.0f, 82.0f, 83.0f, 84.0f}, {91.0f, 92.0f, 93.0f, 94.0f}}, new float[][]{{101.0f, 102.0f, 103.0f, 104.0f}, {111.0f, 112.0f, 0.0f, 114.0f}, {121.0f, 122.0f, 0.0f, 124.0f}, {0.0f, 132.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, true, false}, {false, false, true, false}, {true, false, true, true}, {true, true, true, true}}};
            boolean[] nullBlock = new boolean[]{true, true, false, false, false};
            int nullBlockIndex = 0;
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                Assert.assertEquals((Object)nullBlock[nullBlockIndex++], (Object)(block == null ? 1 : 0));
                if (block == null) continue;
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = (long)i + (long)count * 5L;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 4; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((float)res[count][i][j], (float)block.getColumn(j).getFloat(i), (float)1.0E-5f);
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)res.length, (long)count);
            Assert.assertEquals((long)nullBlock.length, (long)nullBlockIndex);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchLinearFillTest2OrderByDesc() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, LinearFillOperator.class.getSimpleName());
            LinearFill[] fillArray = new LinearFill[]{new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill(), new FloatLinearFill()};
            LinearFillOperator fillOperator = new LinearFillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), (ILinearFill[])fillArray, new Operator(){
                private int index = 0;
                private final float[][][] value = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 0.0f}, {21.0f, 22.0f, 0.0f, 0.0f}, {0.0f, 32.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{51.0f, 0.0f, 0.0f, 0.0f}, {61.0f, 62.0f, 0.0f, 0.0f}, {71.0f, 72.0f, 0.0f, 74.0f}, {0.0f, 82.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{101.0f, 0.0f, 103.0f, 0.0f}, {111.0f, 112.0f, 0.0f, 114.0f}, {121.0f, 122.0f, 0.0f, 124.0f}, {0.0f, 132.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}};
                final boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, true}, {false, false, true, true}, {true, false, true, true}, {true, true, true, true}}, new boolean[][]{{false, true, true, true}, {false, false, true, true}, {false, false, true, false}, {true, false, true, true}, {true, true, true, true}}, new boolean[][]{{false, true, false, true}, {false, false, true, false}, {false, false, true, false}, {true, false, true, true}, {true, true, true, true}}};

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT, (Object)TSDataType.FLOAT));
                    for (int i = 0; i < 5; ++i) {
                        builder.getTimeColumnBuilder().writeLong((long)(4 - i) + (long)(2 - this.index) * 5L);
                        for (int j = 0; j < 4; ++j) {
                            if (this.isNull[this.index][i][j]) {
                                builder.getColumnBuilder(j).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(j).writeFloat(this.value[this.index][i][j]);
                        }
                        builder.declarePosition();
                    }
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 3;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 3;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            float[][][] res = new float[][][]{new float[][]{{1.0f, 0.0f, 3.0f, 4.0f}, {11.0f, 12.0f, 13.0f, 14.0f}, {21.0f, 22.0f, 23.0f, 24.0f}, {31.0f, 32.0f, 33.0f, 34.0f}, {41.0f, 42.0f, 43.0f, 44.0f}}, new float[][]{{51.0f, 52.0f, 53.0f, 54.0f}, {61.0f, 62.0f, 63.0f, 64.0f}, {71.0f, 72.0f, 73.0f, 74.0f}, {81.0f, 82.0f, 83.0f, 84.0f}, {91.0f, 92.0f, 93.0f, 94.0f}}, new float[][]{{101.0f, 102.0f, 103.0f, 104.0f}, {111.0f, 112.0f, 0.0f, 114.0f}, {121.0f, 122.0f, 0.0f, 124.0f}, {0.0f, 132.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}}, new boolean[][]{{false, false, false, false}, {false, false, true, false}, {false, false, true, false}, {true, false, true, true}, {true, true, true, true}}};
            boolean[] nullBlock = new boolean[]{true, true, false, false, false};
            int nullBlockIndex = 0;
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                Assert.assertEquals((Object)nullBlock[nullBlockIndex++], (Object)(block == null ? 1 : 0));
                if (block == null) continue;
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = (long)(block.getPositionCount() - i - 1) + (long)(res.length - count - 1) * 5L;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 4; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((float)res[count][i][j], (float)block.getColumn(j).getFloat(i), (float)1.0E-5f);
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)res.length, (long)count);
            Assert.assertEquals((long)nullBlock.length, (long)nullBlockIndex);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchLinearFillTest3() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, LinearFillOperator.class.getSimpleName());
            LinearFill[] fillArray = new LinearFill[]{new FloatLinearFill()};
            LinearFillOperator fillOperator = new LinearFillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), (ILinearFill[])fillArray, new Operator(){
                private int index = 0;
                private final float[][][] value = new float[][][]{new float[][]{{0.0f}}, new float[][]{{2.0f}}, new float[][]{{3.0f}}, new float[][]{{4.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}};
                final boolean[][][] isNull = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{true}}};

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.FLOAT));
                    for (int i = 0; i < 1; ++i) {
                        builder.getTimeColumnBuilder().writeLong((long)(i + this.index));
                        for (int j = 0; j < 1; ++j) {
                            if (this.isNull[this.index][i][j]) {
                                builder.getColumnBuilder(j).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(j).writeFloat(this.value[this.index][i][j]);
                        }
                        builder.declarePosition();
                    }
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 7;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 7;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            float[][][] res = new float[][][]{new float[][]{{0.0f}}, new float[][]{{2.0f}}, new float[][]{{3.0f}}, new float[][]{{4.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{true}}};
            boolean[] nullBlock = new boolean[]{true, false, false, false, false, true, true, true, false, false, false};
            int nullBlockIndex = 0;
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                Assert.assertEquals((Object)nullBlock[nullBlockIndex++], (Object)(block == null ? 1 : 0));
                if (block == null) continue;
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = i + count;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 1; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((float)res[count][i][j], (float)block.getColumn(j).getFloat(i), (float)1.0E-5f);
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)res.length, (long)count);
            Assert.assertEquals((long)nullBlock.length, (long)nullBlockIndex);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchLinearFillTest3OrderByDesc() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, LinearFillOperator.class.getSimpleName());
            LinearFill[] fillArray = new LinearFill[]{new FloatLinearFill()};
            LinearFillOperator fillOperator = new LinearFillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), (ILinearFill[])fillArray, new Operator(){
                private int index = 0;
                private final float[][][] value = new float[][][]{new float[][]{{0.0f}}, new float[][]{{2.0f}}, new float[][]{{3.0f}}, new float[][]{{4.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}};
                final boolean[][][] isNull = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{true}}};

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.FLOAT));
                    for (int i = 0; i < 1; ++i) {
                        builder.getTimeColumnBuilder().writeLong((long)(i + (6 - this.index)));
                        for (int j = 0; j < 1; ++j) {
                            if (this.isNull[this.index][i][j]) {
                                builder.getColumnBuilder(j).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(j).writeFloat(this.value[this.index][i][j]);
                        }
                        builder.declarePosition();
                    }
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 7;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 7;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            float[][][] res = new float[][][]{new float[][]{{0.0f}}, new float[][]{{2.0f}}, new float[][]{{3.0f}}, new float[][]{{4.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}, new float[][]{{0.0f}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{true}}};
            boolean[] nullBlock = new boolean[]{true, false, false, false, false, true, true, true, false, false, false};
            int nullBlockIndex = 0;
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                Assert.assertEquals((Object)nullBlock[nullBlockIndex++], (Object)(block == null ? 1 : 0));
                if (block == null) continue;
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = block.getPositionCount() - i - 1 + (res.length - count - 1);
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 1; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((float)res[count][i][j], (float)block.getColumn(j).getFloat(i), (float)1.0E-5f);
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)res.length, (long)count);
            Assert.assertEquals((long)nullBlock.length, (long)nullBlockIndex);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchLinearFillBooleanTest() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, LinearFillOperator.class.getSimpleName());
            ILinearFill[] fillArray = new ILinearFill[]{new IdentityLinearFill()};
            LinearFillOperator fillOperator = new LinearFillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), fillArray, new Operator(){
                private int index = 0;
                private final boolean[][][] value = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{true}}};
                final boolean[][][] isNull = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{true}}};

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.BOOLEAN));
                    for (int i = 0; i < 1; ++i) {
                        builder.getTimeColumnBuilder().writeLong((long)(i + this.index));
                        for (int j = 0; j < 1; ++j) {
                            if (this.isNull[this.index][i][j]) {
                                builder.getColumnBuilder(j).appendNull();
                                continue;
                            }
                            builder.getColumnBuilder(j).writeBoolean(this.value[this.index][i][j]);
                        }
                        builder.declarePosition();
                    }
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 7;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 7;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            boolean[][][] res = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{true}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{true}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{false}}, new boolean[][]{{true}}, new boolean[][]{{true}}, new boolean[][]{{true}}};
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                Assert.assertNotNull((Object)block);
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = i + count;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 1; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((Object)res[count][i][j], (Object)block.getColumn(j).getBoolean(i));
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)res.length, (long)count);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

