/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQuerySortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.UpdateLastCacheOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LastQuerySortOperatorTest {
    private static final String SERIES_SCAN_OPERATOR_TEST_SG = "root.LastQuerySortOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, SERIES_SCAN_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void testLastQuerySortOperatorAsc() {
        try {
            List aggregators1 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath1 = new MeasurementPath("root.LastQuerySortOperatorTest.device0.sensor0", TSDataType.INT32);
            List aggregators2 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.LastQuerySortOperatorTest.device0.sensor1", TSDataType.INT32);
            HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0", "sensor1"});
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId5, LastQueryOperator.class.getSimpleName());
            driverContext.getOperatorContexts().forEach(operatorContext -> OperatorContext.setMaxRunTime((Duration)AggregationOperatorTest.TEST_TIME_SLICE));
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors((Set)allSensors);
            SeriesAggregationScanOperator seriesAggregationScanOperator1 = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath1, Ordering.DESC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators1, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator1 = new UpdateLastCacheOperator((OperatorContext)driverContext.getOperatorContexts().get(1), (Operator)seriesAggregationScanOperator1, measurementPath1, measurementPath1.getSeriesType(), null, false, false);
            SeriesAggregationScanOperator seriesAggregationScanOperator2 = new SeriesAggregationScanOperator(planNodeId3, (PartialPath)measurementPath2, Ordering.DESC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(2), aggregators2, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator2 = new UpdateLastCacheOperator((OperatorContext)driverContext.getOperatorContexts().get(3), (Operator)seriesAggregationScanOperator2, measurementPath2, measurementPath2.getSeriesType(), null, false, false);
            LastQuerySortOperator lastQuerySortOperator = new LastQuerySortOperator((OperatorContext)driverContext.getOperatorContexts().get(4), LastQueryUtil.createTsBlockBuilder().build(), (List)ImmutableList.of((Object)updateLastCacheOperator1, (Object)updateLastCacheOperator2), Comparator.naturalOrder());
            int count = 0;
            while (!lastQuerySortOperator.isFinished()) {
                Assert.assertTrue((boolean)lastQuerySortOperator.isBlocked().isDone());
                Assert.assertTrue((boolean)lastQuerySortOperator.hasNext());
                TsBlock result = lastQuerySortOperator.next();
                if (result == null) continue;
                Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
                for (int i = 0; i < result.getPositionCount(); ++i) {
                    Assert.assertEquals((long)499L, (long)result.getTimeByIndex(i));
                    Assert.assertEquals((Object)("root.LastQuerySortOperatorTest.device0.sensor" + count), (Object)result.getColumn(0).getBinary(i).toString());
                    Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(i).toString());
                    Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(i).toString());
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testLastQuerySortOperatorDesc() {
        try {
            List aggregators1 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath1 = new MeasurementPath("root.LastQuerySortOperatorTest.device0.sensor0", TSDataType.INT32);
            List aggregators2 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.LastQuerySortOperatorTest.device0.sensor1", TSDataType.INT32);
            HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0", "sensor1"});
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId4, LastQueryOperator.class.getSimpleName());
            driverContext.getOperatorContexts().forEach(operatorContext -> OperatorContext.setMaxRunTime((Duration)AggregationOperatorTest.TEST_TIME_SLICE));
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors((Set)allSensors);
            SeriesAggregationScanOperator seriesAggregationScanOperator1 = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath1, Ordering.DESC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators1, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator1 = new UpdateLastCacheOperator((OperatorContext)driverContext.getOperatorContexts().get(1), (Operator)seriesAggregationScanOperator1, measurementPath1, measurementPath1.getSeriesType(), null, false, false);
            SeriesAggregationScanOperator seriesAggregationScanOperator2 = new SeriesAggregationScanOperator(planNodeId3, (PartialPath)measurementPath2, Ordering.DESC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(2), aggregators2, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator2 = new UpdateLastCacheOperator((OperatorContext)driverContext.getOperatorContexts().get(3), (Operator)seriesAggregationScanOperator2, measurementPath2, measurementPath2.getSeriesType(), null, false, false);
            TsBlockBuilder builder = LastQueryUtil.createTsBlockBuilder((int)6);
            LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)499L, (String)"root.LastQuerySortOperatorTest.device0.sensor4", (String)"10499", (String)"INT32");
            LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)499L, (String)"root.LastQuerySortOperatorTest.device0.sensor3", (String)"10499", (String)"INT32");
            LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)499L, (String)"root.LastQuerySortOperatorTest.device0.sensor2", (String)"10499", (String)"INT32");
            LastQuerySortOperator lastQuerySortOperator = new LastQuerySortOperator((OperatorContext)driverContext.getOperatorContexts().get(4), builder.build(), (List)ImmutableList.of((Object)updateLastCacheOperator2, (Object)updateLastCacheOperator1), Comparator.reverseOrder());
            int count = 0;
            int[] suffix = new int[]{4, 3, 2, 1, 0};
            while (!lastQuerySortOperator.isFinished()) {
                Assert.assertTrue((boolean)lastQuerySortOperator.isBlocked().isDone());
                Assert.assertTrue((boolean)lastQuerySortOperator.hasNext());
                TsBlock result = lastQuerySortOperator.next();
                if (result == null) continue;
                Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
                for (int i = 0; i < result.getPositionCount(); ++i) {
                    Assert.assertEquals((long)499L, (long)result.getTimeByIndex(i));
                    Assert.assertEquals((Object)("root.LastQuerySortOperatorTest.device0.sensor" + suffix[count]), (Object)result.getColumn(0).getBinary(i).toString());
                    Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(i).toString());
                    Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(i).toString());
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

