/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.HorizontallyConcatOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HorizontallyConcatOperatorTest {
    private static final String HORIZONTALLY_CONCAT_OPERATOR_TEST_SG = "root.HorizontallyConcatOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, HORIZONTALLY_CONCAT_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest1() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesAggregationScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(3, new PlanNodeId("3"), HorizontallyConcatOperator.class.getSimpleName());
            MeasurementPath measurementPath1 = new MeasurementPath("root.HorizontallyConcatOperatorTest.device0.sensor0", TSDataType.INT32);
            List<TAggregationType> aggregationTypes = Arrays.asList(TAggregationType.COUNT, TAggregationType.SUM, TAggregationType.FIRST_VALUE);
            GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 10L, new TimeDuration(0, 1L), new TimeDuration(0, 1L), true);
            ArrayList aggregators = new ArrayList();
            AccumulatorFactory.createBuiltinAccumulators(aggregationTypes, (TSDataType)TSDataType.INT32, Collections.emptyList(), Collections.emptyMap(), (boolean)true).forEach(o -> aggregators.add(new Aggregator(o, AggregationStep.SINGLE)));
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors(allSensors);
            SeriesAggregationScanOperator seriesAggregationScanOperator1 = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath1, Ordering.ASC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true), groupByTimeParameter, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesAggregationScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath2 = new MeasurementPath("root.HorizontallyConcatOperatorTest.device0.sensor1", TSDataType.INT32);
            SeriesAggregationScanOperator seriesAggregationScanOperator2 = new SeriesAggregationScanOperator(planNodeId2, (PartialPath)measurementPath2, Ordering.ASC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(1), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true), groupByTimeParameter, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            seriesAggregationScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            HorizontallyConcatOperator horizontallyConcatOperator = new HorizontallyConcatOperator((OperatorContext)driverContext.getOperatorContexts().get(2), Arrays.asList(seriesAggregationScanOperator1, seriesAggregationScanOperator2), Arrays.asList(TSDataType.INT64, TSDataType.DOUBLE, TSDataType.INT32, TSDataType.INT64, TSDataType.DOUBLE, TSDataType.INT32));
            horizontallyConcatOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            int count = 0;
            while (horizontallyConcatOperator.isBlocked().isDone() && horizontallyConcatOperator.hasNext()) {
                TsBlock tsBlock = horizontallyConcatOperator.next();
                Assert.assertEquals((long)6L, (long)tsBlock.getValueColumnCount());
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertEquals((long)1L, (long)tsBlock.getColumn(0).getLong(i));
                    Assert.assertEquals((double)(20000 + count), (double)tsBlock.getColumn(1).getDouble(i), (double)1.0E-5);
                    Assert.assertEquals((long)(20000 + count), (long)tsBlock.getColumn(2).getInt(i));
                    Assert.assertEquals((long)1L, (long)tsBlock.getColumn(3).getLong(i));
                    Assert.assertEquals((double)(20000 + count), (double)tsBlock.getColumn(4).getDouble(i), (double)1.0E-5);
                    Assert.assertEquals((long)(20000 + count), (long)tsBlock.getColumn(5).getInt(i));
                    ++i;
                    ++count;
                }
            }
            Assert.assertEquals((long)10L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

