/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.FillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFillFilter;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant.DoubleConstantFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter.FixedIntervalFillFilter;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.previous.IntPreviousFill;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.junit.Assert;
import org.junit.Test;

public class FillOperatorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchConstantFillTest() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, FillOperator.class.getSimpleName());
            IFill[] fillArray = new IFill[]{new DoubleConstantFill(520.0), new DoubleConstantFill(520.0), new DoubleConstantFill(520.0)};
            FillOperator fillOperator = new FillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), fillArray, new Operator(){
                private int index = 0;

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    int delta = this.index * 10000;
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.DOUBLE, (Object)TSDataType.DOUBLE, (Object)TSDataType.DOUBLE));
                    builder.getTimeColumnBuilder().writeLong((long)(1 + delta));
                    builder.getColumnBuilder(0).writeDouble((double)(1 + delta));
                    builder.getColumnBuilder(1).appendNull();
                    builder.getColumnBuilder(2).writeDouble((double)(100 + delta));
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(2 + delta));
                    builder.getColumnBuilder(0).writeDouble((double)(2 + delta));
                    builder.getColumnBuilder(1).writeDouble((double)(20 + delta));
                    builder.getColumnBuilder(2).writeDouble((double)(200 + delta));
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(3 + delta));
                    builder.getColumnBuilder(0).writeDouble((double)(3 + delta));
                    builder.getColumnBuilder(1).writeDouble((double)(30 + delta));
                    builder.getColumnBuilder(2).appendNull();
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(4 + delta));
                    builder.getColumnBuilder(0).appendNull();
                    builder.getColumnBuilder(1).writeDouble((double)(40 + delta));
                    builder.getColumnBuilder(2).appendNull();
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(5 + delta));
                    builder.getColumnBuilder(0).appendNull();
                    builder.getColumnBuilder(1).appendNull();
                    builder.getColumnBuilder(2).writeDouble((double)(500 + delta));
                    builder.declarePosition();
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 3;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 3;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            double[][][] res = new double[][][]{new double[][]{{1.0, 520.0, 100.0}, {2.0, 20.0, 200.0}, {3.0, 30.0, 520.0}, {520.0, 40.0, 520.0}, {520.0, 520.0, 500.0}}, new double[][]{{10001.0, 520.0, 10100.0}, {10002.0, 10020.0, 10200.0}, {10003.0, 10030.0, 520.0}, {520.0, 10040.0, 520.0}, {520.0, 520.0, 10500.0}}, new double[][]{{20001.0, 520.0, 20100.0}, {20002.0, 20020.0, 20200.0}, {20003.0, 20030.0, 520.0}, {520.0, 20040.0, 520.0}, {520.0, 520.0, 20500.0}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}}, new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}}, new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}}};
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = (long)(i + 1) + (long)count * 10000L;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 3; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((double)res[count][i][j], (double)block.getColumn(j).getDouble(i), (double)1.0E-5);
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)3L, (long)count);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchPreviousFillTest() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, FillOperator.class.getSimpleName());
            IFill[] fillArray = new IFill[]{new IntPreviousFill(IFillFilter.TRUE), new IntPreviousFill(IFillFilter.TRUE), new IntPreviousFill(IFillFilter.TRUE)};
            FillOperator fillOperator = new FillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), fillArray, new Operator(){
                private int index = 0;

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() throws Exception {
                    int delta = this.index * 10000;
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.INT32, (Object)TSDataType.INT32, (Object)TSDataType.INT32));
                    builder.getTimeColumnBuilder().writeLong((long)(1 + delta));
                    builder.getColumnBuilder(0).writeInt(1 + delta);
                    builder.getColumnBuilder(1).appendNull();
                    builder.getColumnBuilder(2).writeInt(100 + delta);
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(2 + delta));
                    builder.getColumnBuilder(0).writeInt(2 + delta);
                    builder.getColumnBuilder(1).writeInt(20 + delta);
                    builder.getColumnBuilder(2).writeInt(200 + delta);
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(3 + delta));
                    builder.getColumnBuilder(0).writeInt(3 + delta);
                    builder.getColumnBuilder(1).writeInt(30 + delta);
                    builder.getColumnBuilder(2).appendNull();
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(4 + delta));
                    builder.getColumnBuilder(0).appendNull();
                    builder.getColumnBuilder(1).writeInt(40 + delta);
                    builder.getColumnBuilder(2).appendNull();
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(5 + delta));
                    builder.getColumnBuilder(0).appendNull();
                    builder.getColumnBuilder(1).appendNull();
                    builder.getColumnBuilder(2).writeInt(500 + delta);
                    builder.declarePosition();
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() throws Exception {
                    return this.index < 3;
                }

                public boolean isFinished() throws Exception {
                    return this.index >= 3;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            int[][][] res = new int[][][]{new int[][]{{1, 0, 100}, {2, 20, 200}, {3, 30, 200}, {3, 40, 200}, {3, 40, 500}}, new int[][]{{10001, 40, 10100}, {10002, 10020, 10200}, {10003, 10030, 10200}, {10003, 10040, 10200}, {10003, 10040, 10500}}, new int[][]{{20001, 10040, 20100}, {20002, 20020, 20200}, {20003, 20030, 20200}, {20003, 20040, 20200}, {20003, 20040, 20500}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}}, new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}}, new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}}};
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = (long)(i + 1) + (long)count * 10000L;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 3; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((long)res[count][i][j], (long)block.getColumn(j).getInt(i));
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)3L, (long)count);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchPreviousFillWithThresholdTest() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            final DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, FillOperator.class.getSimpleName());
            IFill[] fillArray = new IFill[]{new IntPreviousFill((IFillFilter)new FixedIntervalFillFilter(2L)), new IntPreviousFill((IFillFilter)new FixedIntervalFillFilter(100L)), new IntPreviousFill((IFillFilter)new FixedIntervalFillFilter(1L))};
            FillOperator fillOperator = new FillOperator((OperatorContext)driverContext.getOperatorContexts().get(0), fillArray, new Operator(){
                private int index = 0;

                public OperatorContext getOperatorContext() {
                    return (OperatorContext)driverContext.getOperatorContexts().get(0);
                }

                public TsBlock next() {
                    int delta = this.index * 10000;
                    TsBlockBuilder builder = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.INT32, (Object)TSDataType.INT32, (Object)TSDataType.INT32));
                    builder.getTimeColumnBuilder().writeLong((long)(1 + delta));
                    builder.getColumnBuilder(0).writeInt(1 + delta);
                    builder.getColumnBuilder(1).appendNull();
                    builder.getColumnBuilder(2).writeInt(100 + delta);
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(2 + delta));
                    builder.getColumnBuilder(0).writeInt(2 + delta);
                    builder.getColumnBuilder(1).writeInt(20 + delta);
                    builder.getColumnBuilder(2).writeInt(200 + delta);
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(3 + delta));
                    builder.getColumnBuilder(0).writeInt(3 + delta);
                    builder.getColumnBuilder(1).writeInt(30 + delta);
                    builder.getColumnBuilder(2).appendNull();
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(4 + delta));
                    builder.getColumnBuilder(0).appendNull();
                    builder.getColumnBuilder(1).writeInt(40 + delta);
                    builder.getColumnBuilder(2).appendNull();
                    builder.declarePosition();
                    builder.getTimeColumnBuilder().writeLong((long)(5 + delta));
                    builder.getColumnBuilder(0).appendNull();
                    builder.getColumnBuilder(1).appendNull();
                    builder.getColumnBuilder(2).writeInt(500 + delta);
                    builder.declarePosition();
                    ++this.index;
                    return builder.build();
                }

                public boolean hasNext() {
                    return this.index < 3;
                }

                public boolean isFinished() {
                    return this.index >= 3;
                }

                public void close() throws Exception {
                }

                public long calculateMaxPeekMemory() {
                    return 0L;
                }

                public long calculateMaxReturnSize() {
                    return 0L;
                }

                public long calculateRetainedSizeAfterCallingNext() {
                    return 0L;
                }
            });
            int count = 0;
            int[][][] res = new int[][][]{new int[][]{{1, 0, 100}, {2, 20, 200}, {3, 30, 200}, {3, 40, 0}, {3, 40, 500}}, new int[][]{{10001, 0, 10100}, {10002, 10020, 10200}, {10003, 10030, 10200}, {10003, 10040, 0}, {10003, 10040, 10500}}, new int[][]{{20001, 0, 20100}, {20002, 20020, 20200}, {20003, 20030, 20200}, {20003, 20040, 0}, {20003, 20040, 20500}}};
            boolean[][][] isNull = new boolean[][][]{new boolean[][]{{false, true, false}, {false, false, false}, {false, false, false}, {false, false, true}, {false, false, false}}, new boolean[][]{{false, true, false}, {false, false, false}, {false, false, false}, {false, false, true}, {false, false, false}}, new boolean[][]{{false, true, false}, {false, false, false}, {false, false, false}, {false, false, true}, {false, false, false}}};
            while (fillOperator.hasNext()) {
                TsBlock block = fillOperator.next();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    long expectedTime = (long)(i + 1) + (long)count * 10000L;
                    Assert.assertEquals((long)expectedTime, (long)block.getTimeByIndex(i));
                    for (int j = 0; j < 3; ++j) {
                        Assert.assertEquals((Object)isNull[count][i][j], (Object)block.getColumn(j).isNull(i));
                        if (isNull[count][i][j]) continue;
                        Assert.assertEquals((long)res[count][i][j], (long)block.getColumn(j).getInt(i));
                    }
                }
                ++count;
            }
            Assert.assertTrue((boolean)fillOperator.isFinished());
            Assert.assertEquals((long)3L, (long)count);
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

