/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AlignedSeriesTestUtil;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumn;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumn;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumn;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumn;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AlignedSeriesScanOperatorTest {
    private static final String SERIES_SCAN_OPERATOR_TEST_SG = "root.AlignedSeriesScanOperatorTest";
    private static final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private static final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private static final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private static final double DELTA = 1.0E-6;

    @BeforeClass
    public static void setUp() throws MetadataException, IOException, WriteProcessException {
        AlignedSeriesTestUtil.setUp(measurementSchemas, seqResources, unSeqResources, SERIES_SCAN_OPERATOR_TEST_SG);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        AlignedSeriesTestUtil.tearDown(seqResources, unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest1() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            AlignedPath alignedPath = new AlignedPath("root.AlignedSeriesScanOperatorTest.device0", measurementSchemas.stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()), measurementSchemas.stream().map(m -> m).collect(Collectors.toList()));
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId, AlignedSeriesScanOperator.class.getSimpleName());
            AlignedSeriesScanOperator seriesScanOperator = new AlignedSeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId, alignedPath, Ordering.ASC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)alignedPath), false, null, -1);
            seriesScanOperator.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            int count = 0;
            while (seriesScanOperator.hasNext()) {
                TsBlock tsBlock = seriesScanOperator.next();
                Assert.assertEquals((long)6L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof BooleanColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(1) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(2) instanceof LongColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(3) instanceof FloatColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(4) instanceof DoubleColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(5) instanceof BinaryColumn));
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    int delta = 0;
                    if ((long)count < 200L) {
                        delta = 20000;
                    } else if ((long)count < 260L || (long)count >= 300L && (long)count < 380L || (long)count >= 400L) {
                        delta = 10000;
                    }
                    Assert.assertEquals((Object)(((long)delta + (long)count) % 2L == 0L ? 1 : 0), (Object)tsBlock.getColumn(0).getBoolean(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(2).getLong(i));
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(3).getFloat(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(4).getDouble(i), (double)1.0E-6);
                    Assert.assertEquals((Object)String.valueOf((long)delta + (long)count), (Object)tsBlock.getColumn(5).getBinary(i).toString());
                    ++i;
                    ++count;
                }
            }
            Assert.assertEquals((long)500L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest2() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            AlignedPath alignedPath1 = new AlignedPath("root.AlignedSeriesScanOperatorTest.device0", measurementSchemas.stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()), measurementSchemas.stream().map(m -> m).collect(Collectors.toList()));
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, AlignedSeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, AlignedSeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId5, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId6 = new PlanNodeId("6");
            driverContext.addOperatorContext(6, planNodeId6, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId7 = new PlanNodeId("7");
            driverContext.addOperatorContext(7, planNodeId7, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId8 = new PlanNodeId("8");
            driverContext.addOperatorContext(8, planNodeId8, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(9, new PlanNodeId("9"), FullOuterTimeJoinOperator.class.getSimpleName());
            AlignedSeriesScanOperator seriesScanOperator1 = new AlignedSeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, alignedPath1, Ordering.ASC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)alignedPath1), false, null, -1);
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            AlignedPath alignedPath2 = new AlignedPath("root.AlignedSeriesScanOperatorTest.device1", measurementSchemas.stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()), measurementSchemas.stream().map(m -> m).collect(Collectors.toList()));
            AlignedSeriesScanOperator seriesScanOperator2 = new AlignedSeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, alignedPath2, Ordering.ASC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)alignedPath2), false, null, -1);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            allSensors.add("sensor2");
            allSensors.add("sensor3");
            allSensors.add("sensor4");
            allSensors.add("sensor5");
            MeasurementPath measurementPath3 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor0", TSDataType.BOOLEAN);
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors(allSensors);
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(2), planNodeId3, (PartialPath)measurementPath3, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath4 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator4 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(3), planNodeId4, (PartialPath)measurementPath4, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator4.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator4.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath5 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor2", TSDataType.INT64);
            SeriesScanOperator seriesScanOperator5 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(4), planNodeId5, (PartialPath)measurementPath5, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator5.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator5.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath6 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor3", TSDataType.FLOAT);
            SeriesScanOperator seriesScanOperator6 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(5), planNodeId6, (PartialPath)measurementPath6, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator6.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator6.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath7 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor4", TSDataType.DOUBLE);
            SeriesScanOperator seriesScanOperator7 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(6), planNodeId7, (PartialPath)measurementPath7, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator7.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator7.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath8 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor5", TSDataType.TEXT);
            SeriesScanOperator seriesScanOperator8 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(7), planNodeId8, (PartialPath)measurementPath8, Ordering.ASC, scanOptionsBuilder.build());
            seriesScanOperator8.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator8.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(8), Arrays.asList(seriesScanOperator1, seriesScanOperator2, seriesScanOperator3, seriesScanOperator4, seriesScanOperator5, seriesScanOperator6, seriesScanOperator7, seriesScanOperator8), Ordering.ASC, Arrays.asList(TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT, TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT, TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(0, 1), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(0, 2), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(0, 3), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(0, 4), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(0, 5), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 1), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 2), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 3), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 4), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 5), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(2, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(3, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(4, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(5, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(6, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(7, 0), (TimeComparator)new AscTimeComparator())), (TimeComparator)new AscTimeComparator());
            timeJoinOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            int count = 0;
            while (timeJoinOperator.isBlocked().isDone() && timeJoinOperator.hasNext()) {
                TsBlock tsBlock = timeJoinOperator.next();
                Assert.assertEquals((long)18L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof BooleanColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(1) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(2) instanceof LongColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(3) instanceof FloatColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(4) instanceof DoubleColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(5) instanceof BinaryColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(6) instanceof BooleanColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(7) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(8) instanceof LongColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(9) instanceof FloatColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(10) instanceof DoubleColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(11) instanceof BinaryColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(12) instanceof BooleanColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(13) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(14) instanceof LongColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(15) instanceof FloatColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(16) instanceof DoubleColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(17) instanceof BinaryColumn));
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    int delta = 0;
                    if ((long)count < 200L) {
                        delta = 20000;
                    } else if ((long)count < 260L || (long)count >= 300L && (long)count < 380L || (long)count >= 400L) {
                        delta = 10000;
                    }
                    Assert.assertEquals((Object)(((long)delta + (long)count) % 2L == 0L ? 1 : 0), (Object)tsBlock.getColumn(0).getBoolean(i));
                    Assert.assertEquals((Object)(((long)delta + (long)count) % 2L == 0L ? 1 : 0), (Object)tsBlock.getColumn(6).getBoolean(i));
                    Assert.assertEquals((Object)(((long)delta + (long)count) % 2L == 0L ? 1 : 0), (Object)tsBlock.getColumn(12).getBoolean(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(7).getInt(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(13).getInt(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(2).getLong(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(8).getLong(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(14).getLong(i));
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(3).getFloat(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(9).getFloat(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(15).getFloat(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(4).getDouble(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(10).getDouble(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(16).getDouble(i), (double)1.0E-6);
                    Assert.assertEquals((Object)String.valueOf((long)delta + (long)count), (Object)tsBlock.getColumn(5).getBinary(i).toString());
                    Assert.assertEquals((Object)String.valueOf((long)delta + (long)count), (Object)tsBlock.getColumn(11).getBinary(i).toString());
                    Assert.assertEquals((Object)String.valueOf((long)delta + (long)count), (Object)tsBlock.getColumn(17).getBinary(i).toString());
                    ++i;
                    ++count;
                }
            }
            Assert.assertEquals((long)500L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest3() throws Exception {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            AlignedPath alignedPath1 = new AlignedPath("root.AlignedSeriesScanOperatorTest.device0", measurementSchemas.stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()), measurementSchemas.stream().map(m -> m).collect(Collectors.toList()));
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, AlignedSeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, AlignedSeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            driverContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            driverContext.addOperatorContext(4, planNodeId4, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            driverContext.addOperatorContext(5, planNodeId5, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId6 = new PlanNodeId("6");
            driverContext.addOperatorContext(6, planNodeId6, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId7 = new PlanNodeId("7");
            driverContext.addOperatorContext(7, planNodeId7, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId8 = new PlanNodeId("8");
            driverContext.addOperatorContext(8, planNodeId8, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(9, new PlanNodeId("9"), FullOuterTimeJoinOperator.class.getSimpleName());
            AlignedSeriesScanOperator seriesScanOperator1 = new AlignedSeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, alignedPath1, Ordering.DESC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)alignedPath1), false, null, -1);
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            AlignedPath alignedPath2 = new AlignedPath("root.AlignedSeriesScanOperatorTest.device1", measurementSchemas.stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()), measurementSchemas.stream().map(m -> m).collect(Collectors.toList()));
            AlignedSeriesScanOperator seriesScanOperator2 = new AlignedSeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, alignedPath2, Ordering.DESC, SeriesScanOptions.getDefaultSeriesScanOptions((PartialPath)alignedPath2), false, null, -1);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            allSensors.add("sensor2");
            allSensors.add("sensor3");
            allSensors.add("sensor4");
            allSensors.add("sensor5");
            MeasurementPath measurementPath3 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor0", TSDataType.BOOLEAN);
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors(allSensors);
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(2), planNodeId3, (PartialPath)measurementPath3, Ordering.DESC, scanOptionsBuilder.build());
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator3.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath4 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator4 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(3), planNodeId4, (PartialPath)measurementPath4, Ordering.DESC, scanOptionsBuilder.build());
            seriesScanOperator4.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator4.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath5 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor2", TSDataType.INT64);
            SeriesScanOperator seriesScanOperator5 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(4), planNodeId5, (PartialPath)measurementPath5, Ordering.DESC, scanOptionsBuilder.build());
            seriesScanOperator5.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator5.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath6 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor3", TSDataType.FLOAT);
            SeriesScanOperator seriesScanOperator6 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(5), planNodeId6, (PartialPath)measurementPath6, Ordering.DESC, scanOptionsBuilder.build());
            seriesScanOperator6.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator6.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath7 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor4", TSDataType.DOUBLE);
            SeriesScanOperator seriesScanOperator7 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(6), planNodeId7, (PartialPath)measurementPath7, Ordering.DESC, scanOptionsBuilder.build());
            seriesScanOperator7.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator7.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath8 = new MeasurementPath("root.AlignedSeriesScanOperatorTest.device2.sensor5", TSDataType.TEXT);
            SeriesScanOperator seriesScanOperator8 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(7), planNodeId8, (PartialPath)measurementPath8, Ordering.DESC, scanOptionsBuilder.build());
            seriesScanOperator8.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
            seriesScanOperator8.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(8), Arrays.asList(seriesScanOperator1, seriesScanOperator2, seriesScanOperator3, seriesScanOperator4, seriesScanOperator5, seriesScanOperator6, seriesScanOperator7, seriesScanOperator8), Ordering.DESC, Arrays.asList(TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT, TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT, TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(0, 1), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(0, 2), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(0, 3), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(0, 4), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(0, 5), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(1, 1), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(1, 2), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(1, 3), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(1, 4), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(1, 5), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(2, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(3, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(4, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(5, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(6, 0), (TimeComparator)new DescTimeComparator()), new SingleColumnMerger(new InputLocation(7, 0), (TimeComparator)new DescTimeComparator())), (TimeComparator)new DescTimeComparator());
            timeJoinOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            int count = 499;
            while (timeJoinOperator.isBlocked().isDone() && timeJoinOperator.hasNext()) {
                TsBlock tsBlock = timeJoinOperator.next();
                Assert.assertEquals((long)18L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof BooleanColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(1) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(2) instanceof LongColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(3) instanceof FloatColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(4) instanceof DoubleColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(5) instanceof BinaryColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(6) instanceof BooleanColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(7) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(8) instanceof LongColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(9) instanceof FloatColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(10) instanceof DoubleColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(11) instanceof BinaryColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(12) instanceof BooleanColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(13) instanceof IntColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(14) instanceof LongColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(15) instanceof FloatColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(16) instanceof DoubleColumn));
                Assert.assertTrue((boolean)(tsBlock.getColumn(17) instanceof BinaryColumn));
                int i = 0;
                while (i < tsBlock.getPositionCount()) {
                    Assert.assertEquals((long)count, (long)tsBlock.getTimeByIndex(i));
                    int delta = 0;
                    if ((long)count < 200L) {
                        delta = 20000;
                    } else if ((long)count < 260L || (long)count >= 300L && (long)count < 380L || (long)count >= 400L) {
                        delta = 10000;
                    }
                    Assert.assertEquals((Object)(((long)delta + (long)count) % 2L == 0L ? 1 : 0), (Object)tsBlock.getColumn(0).getBoolean(i));
                    Assert.assertEquals((Object)(((long)delta + (long)count) % 2L == 0L ? 1 : 0), (Object)tsBlock.getColumn(6).getBoolean(i));
                    Assert.assertEquals((Object)(((long)delta + (long)count) % 2L == 0L ? 1 : 0), (Object)tsBlock.getColumn(12).getBoolean(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(1).getInt(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(7).getInt(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(13).getInt(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(2).getLong(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(8).getLong(i));
                    Assert.assertEquals((long)((long)delta + (long)count), (long)tsBlock.getColumn(14).getLong(i));
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(3).getFloat(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(9).getFloat(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(15).getFloat(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(4).getDouble(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(10).getDouble(i), (double)1.0E-6);
                    Assert.assertEquals((double)((long)delta + (long)count), (double)tsBlock.getColumn(16).getDouble(i), (double)1.0E-6);
                    Assert.assertEquals((Object)String.valueOf((long)delta + (long)count), (Object)tsBlock.getColumn(5).getBinary(i).toString());
                    Assert.assertEquals((Object)String.valueOf((long)delta + (long)count), (Object)tsBlock.getColumn(11).getBinary(i).toString());
                    Assert.assertEquals((Object)String.valueOf((long)delta + (long)count), (Object)tsBlock.getColumn(17).getBinary(i).toString());
                    ++i;
                    --count;
                }
            }
            Assert.assertEquals((long)-1L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

