/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregationOperatorTest {
    public static Duration TEST_TIME_SLICE = new Duration(50000.0, TimeUnit.MILLISECONDS);
    private static final String AGGREGATION_OPERATOR_TEST_SG = "root.AggregationOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, AGGREGATION_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void testAggregateIntermediateResult1() throws Exception {
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        aggregationTypes.add(TAggregationType.COUNT);
        aggregationTypes.add(TAggregationType.SUM);
        aggregationTypes.add(TAggregationType.MIN_TIME);
        aggregationTypes.add(TAggregationType.MAX_TIME);
        aggregationTypes.add(TAggregationType.MAX_VALUE);
        aggregationTypes.add(TAggregationType.MIN_VALUE);
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < aggregationTypes.size(); ++i) {
            ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(1, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        AggregationOperator aggregationOperator = this.initAggregationOperator(aggregationTypes, null, inputLocations);
        int count = 0;
        while (true) {
            ListenableFuture blocked = aggregationOperator.isBlocked();
            blocked.get();
            if (!aggregationOperator.hasNext()) break;
            TsBlock resultTsBlock = aggregationOperator.next();
            if (resultTsBlock == null) continue;
            Assert.assertEquals((long)500L, (long)resultTsBlock.getColumn(0).getLong(0));
            Assert.assertEquals((double)6524750.0, (double)resultTsBlock.getColumn(1).getDouble(0), (double)1.0E-4);
            Assert.assertEquals((long)0L, (long)resultTsBlock.getColumn(2).getLong(0));
            Assert.assertEquals((long)499L, (long)resultTsBlock.getColumn(3).getLong(0));
            Assert.assertEquals((long)20199L, (long)resultTsBlock.getColumn(4).getInt(0));
            Assert.assertEquals((long)260L, (long)resultTsBlock.getColumn(5).getInt(0));
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testAggregateIntermediateResult2() throws Exception {
        ArrayList<TAggregationType> aggregationTypes = new ArrayList<TAggregationType>();
        aggregationTypes.add(TAggregationType.AVG);
        aggregationTypes.add(TAggregationType.FIRST_VALUE);
        aggregationTypes.add(TAggregationType.LAST_VALUE);
        ArrayList<List<InputLocation[]>> inputLocations = new ArrayList<List<InputLocation[]>>();
        for (int i = 0; i < aggregationTypes.size(); ++i) {
            ArrayList<InputLocation[]> inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, 2 * i), new InputLocation(0, 2 * i + 1)});
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(1, 2 * i), new InputLocation(1, 2 * i + 1)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        AggregationOperator aggregationOperator = this.initAggregationOperator(aggregationTypes, null, inputLocations);
        int count = 0;
        while (true) {
            ListenableFuture blocked = aggregationOperator.isBlocked();
            blocked.get();
            if (!aggregationOperator.hasNext()) break;
            TsBlock resultTsBlock = aggregationOperator.next();
            if (resultTsBlock == null) continue;
            Assert.assertEquals((double)13049.5, (double)resultTsBlock.getColumn(0).getDouble(0), (double)0.001);
            Assert.assertEquals((long)20000L, (long)resultTsBlock.getColumn(1).getInt(0));
            Assert.assertEquals((long)10499L, (long)resultTsBlock.getColumn(2).getInt(0));
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testGroupByIntermediateResult1() throws Exception {
        result = new int[][]{{100, 100, 100, 99}, {2004950, 2014950, 624950, 834551}, {0, 100, 200, 300}, {99, 199, 299, 398}, {20099, 20199, 10259, 10379}, {20000, 20100, 260, 380}};
        groupByTimeParameter = new GroupByTimeParameter(0L, 399L, new TimeDuration(0, 100L), new TimeDuration(0, 100L), true);
        aggregationTypes = new ArrayList<TAggregationType>();
        aggregationTypes.add(TAggregationType.COUNT);
        aggregationTypes.add(TAggregationType.SUM);
        aggregationTypes.add(TAggregationType.MIN_TIME);
        aggregationTypes.add(TAggregationType.MAX_TIME);
        aggregationTypes.add(TAggregationType.MAX_VALUE);
        aggregationTypes.add(TAggregationType.MIN_VALUE);
        inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < aggregationTypes.size(); ++i) {
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, i)});
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(1, i)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        aggregationOperator = this.initAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations);
        count = 0;
        block1: while (true) {
            blocked = aggregationOperator.isBlocked();
            blocked.get();
            if (!aggregationOperator.hasNext()) break;
            resultTsBlock = aggregationOperator.next();
            if (resultTsBlock == null) continue;
            positionCount = resultTsBlock.getPositionCount();
            pos = 0;
            while (true) {
                if (pos < positionCount) ** break;
                continue block1;
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(pos));
                Assert.assertEquals((long)result[0][count], (long)resultTsBlock.getColumn(0).getLong(pos));
                Assert.assertEquals((double)result[1][count], (double)resultTsBlock.getColumn(1).getDouble(pos), (double)1.0E-4);
                Assert.assertEquals((long)result[2][count], (long)resultTsBlock.getColumn(2).getLong(pos));
                Assert.assertEquals((long)result[3][count], (long)resultTsBlock.getColumn(3).getLong(pos));
                Assert.assertEquals((long)result[4][count], (long)resultTsBlock.getColumn(4).getInt(pos));
                Assert.assertEquals((long)result[5][count], (long)resultTsBlock.getColumn(5).getInt(pos));
                ++count;
                ++pos;
            }
            break;
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testGroupByIntermediateResult2() throws Exception {
        result = new double[][]{{20049.5, 20149.5, 6249.5, 8429.808}, {20000.0, 20100.0, 10200.0, 10300.0}, {20099.0, 20199.0, 299.0, 398.0}};
        aggregationTypes = new ArrayList<TAggregationType>();
        aggregationTypes.add(TAggregationType.AVG);
        aggregationTypes.add(TAggregationType.FIRST_VALUE);
        aggregationTypes.add(TAggregationType.LAST_VALUE);
        groupByTimeParameter = new GroupByTimeParameter(0L, 399L, new TimeDuration(0, 100L), new TimeDuration(0, 100L), true);
        inputLocations = new ArrayList<List<InputLocation[]>>();
        for (i = 0; i < aggregationTypes.size(); ++i) {
            inputLocationForOneAggregator = new ArrayList<InputLocation[]>();
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(0, 2 * i), new InputLocation(0, 2 * i + 1)});
            inputLocationForOneAggregator.add(new InputLocation[]{new InputLocation(1, 2 * i), new InputLocation(1, 2 * i + 1)});
            inputLocations.add(inputLocationForOneAggregator);
        }
        aggregationOperator = this.initAggregationOperator(aggregationTypes, groupByTimeParameter, inputLocations);
        count = 0;
        block1: while (true) {
            blocked = aggregationOperator.isBlocked();
            blocked.get();
            if (!aggregationOperator.hasNext()) break;
            resultTsBlock = aggregationOperator.next();
            if (resultTsBlock == null) continue;
            positionCount = resultTsBlock.getPositionCount();
            pos = 0;
            while (true) {
                if (pos < positionCount) ** break;
                continue block1;
                Assert.assertEquals((long)(100 * count), (long)resultTsBlock.getTimeColumn().getLong(pos));
                Assert.assertEquals((double)result[0][count], (double)resultTsBlock.getColumn(0).getDouble(pos), (double)0.001);
                Assert.assertEquals((long)((int)result[1][count]), (long)resultTsBlock.getColumn(1).getInt(pos));
                Assert.assertEquals((long)((int)result[2][count]), (long)resultTsBlock.getColumn(2).getInt(pos));
                ++count;
                ++pos;
            }
            break;
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    private AggregationOperator initAggregationOperator(List<TAggregationType> aggregationTypes, GroupByTimeParameter groupByTimeParameter, List<List<InputLocation[]>> inputLocations) throws IllegalPathException {
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        DriverContext driverContext = new DriverContext(fragmentInstanceContext, 0);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        driverContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
        PlanNodeId planNodeId2 = new PlanNodeId("2");
        driverContext.addOperatorContext(2, planNodeId2, SeriesAggregationScanOperator.class.getSimpleName());
        PlanNodeId planNodeId3 = new PlanNodeId("3");
        driverContext.addOperatorContext(3, planNodeId3, AggregationOperator.class.getSimpleName());
        driverContext.getOperatorContexts().forEach(operatorContext -> OperatorContext.setMaxRunTime((Duration)TEST_TIME_SLICE));
        MeasurementPath measurementPath1 = new MeasurementPath("root.AggregationOperatorTest.device0.sensor0", TSDataType.INT32);
        ArrayList aggregators = new ArrayList();
        AccumulatorFactory.createBuiltinAccumulators(aggregationTypes, (TSDataType)TSDataType.INT32, Collections.emptyList(), Collections.emptyMap(), (boolean)true).forEach(o -> aggregators.add(new Aggregator(o, AggregationStep.PARTIAL)));
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(Collections.singleton("sensor0"));
        SeriesAggregationScanOperator seriesAggregationScanOperator1 = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath1, Ordering.ASC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true), groupByTimeParameter, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        ArrayList<TsFileResource> seqResources1 = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unSeqResources1 = new ArrayList<TsFileResource>();
        seqResources1.add(this.seqResources.get(0));
        seqResources1.add(this.seqResources.get(1));
        seqResources1.add(this.seqResources.get(3));
        unSeqResources1.add(this.unSeqResources.get(0));
        unSeqResources1.add(this.unSeqResources.get(1));
        unSeqResources1.add(this.unSeqResources.get(3));
        unSeqResources1.add(this.unSeqResources.get(5));
        seriesAggregationScanOperator1.initQueryDataSource(new QueryDataSource(seqResources1, unSeqResources1));
        SeriesAggregationScanOperator seriesAggregationScanOperator2 = new SeriesAggregationScanOperator(planNodeId2, (PartialPath)measurementPath1, Ordering.ASC, scanOptionsBuilder.build(), (OperatorContext)driverContext.getOperatorContexts().get(0), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true), groupByTimeParameter, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        ArrayList<TsFileResource> seqResources2 = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unSeqResources2 = new ArrayList<TsFileResource>();
        seqResources2.add(this.seqResources.get(2));
        seqResources2.add(this.seqResources.get(4));
        unSeqResources2.add(this.unSeqResources.get(2));
        unSeqResources2.add(this.unSeqResources.get(4));
        seriesAggregationScanOperator2.initQueryDataSource(new QueryDataSource(seqResources2, unSeqResources2));
        ArrayList<SeriesAggregationScanOperator> children = new ArrayList<SeriesAggregationScanOperator>();
        children.add(seriesAggregationScanOperator1);
        children.add(seriesAggregationScanOperator2);
        ArrayList<Aggregator> finalAggregators = new ArrayList<Aggregator>();
        List accumulators = AccumulatorFactory.createBuiltinAccumulators(aggregationTypes, (TSDataType)TSDataType.INT32, Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        for (int i = 0; i < accumulators.size(); ++i) {
            finalAggregators.add(new Aggregator((Accumulator)accumulators.get(i), AggregationStep.FINAL, inputLocations.get(i)));
        }
        return new AggregationOperator((OperatorContext)driverContext.getOperatorContexts().get(2), finalAggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true), children, false, (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
    }
}

