/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.memory;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.queryengine.execution.memory.MemoryPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryPoolTest {
    MemoryPool pool;
    private final String QUERY_ID = "q0";
    private final String FRAGMENT_INSTANCE_ID = "f0";
    private final String PLAN_NODE_ID = "p0";

    @Before
    public void before() {
        this.pool = new MemoryPool("test", 1024L, 512L);
        this.pool.registerPlanNodeIdToQueryMemoryMap("q0", "f0", "p0");
    }

    @Test
    public void testTryReserve() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 256L, Long.MAX_VALUE));
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testTryReserveZero() {
        try {
            this.pool.tryReserveForTest("q0", "f0", "p0", 0L, Long.MAX_VALUE);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTryReserveNegative() {
        try {
            this.pool.tryReserveForTest("q0", "f0", "p0", -1L, Long.MAX_VALUE);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTryReserveAll() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, Long.MAX_VALUE));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testOverTryReserve() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 256L, 512L));
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
        Assert.assertFalse((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, 511L));
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testReserve() {
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)256L, (long)Long.MAX_VALUE).left;
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void tesReserveZero() {
        try {
            this.pool.reserve("q0", "f0", "p0", 0L, Long.MAX_VALUE);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReserveNegative() {
        try {
            this.pool.reserve("q0", "f0", "p0", -1L, Long.MAX_VALUE);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReserveAll() {
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)512L, (long)Long.MAX_VALUE).left;
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testOverReserve() {
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)256L, (long)Long.MAX_VALUE).left;
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
        future = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)512L, (long)513L).left;
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testReserveAndFree() {
        Assert.assertTrue((boolean)((ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)512L, (long)Long.MAX_VALUE).left).isDone());
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)512L, (long)513L).left;
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free("q0", "f0", "p0", 512L);
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void testMultiReserveAndFree() {
        Assert.assertTrue((boolean)((ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)256L, (long)Long.MAX_VALUE).left).isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
        ListenableFuture future1 = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)512L, (long)513L).left;
        ListenableFuture future2 = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)512L, (long)513L).left;
        ListenableFuture future3 = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)512L, (long)513L).left;
        Assert.assertFalse((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertFalse((boolean)future3.isDone());
        this.pool.free("q0", "f0", "p0", 256L);
        Assert.assertTrue((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertFalse((boolean)future3.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free("q0", "f0", "p0", 512L);
        Assert.assertTrue((boolean)future2.isDone());
        Assert.assertFalse((boolean)future3.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free("q0", "f0", "p0", 512L);
        Assert.assertTrue((boolean)future3.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free("q0", "f0", "p0", 512L);
        Assert.assertEquals((long)0L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)0L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testFree() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, Long.MAX_VALUE));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free("q0", "f0", "p0", 256L);
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testFreeAll() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, Long.MAX_VALUE));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free("q0", "f0", "p0", 512L);
        Assert.assertEquals((long)0L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)0L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testFreeZero() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, Long.MAX_VALUE));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        try {
            this.pool.free("q0", "f0", "p0", 0L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFreeNegative() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, Long.MAX_VALUE));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        try {
            this.pool.free("q0", "f0", "p0", -1L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOverFree() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, Long.MAX_VALUE));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes("q0"));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        try {
            this.pool.free("q0", "f0", "p0", 513L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTryCancelBlockedReservation() {
        Assert.assertTrue((boolean)this.pool.tryReserveForTest("q0", "f0", "p0", 512L, Long.MAX_VALUE));
        ListenableFuture f = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)256L, (long)512L).left;
        Assert.assertFalse((boolean)f.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.tryCancel(f));
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertTrue((boolean)f.isCancelled());
    }

    @Test
    public void testTryCancelCompletedReservation() {
        ListenableFuture f = (ListenableFuture)this.pool.reserve((String)"q0", (String)"f0", (String)"p0", (long)256L, (long)Long.MAX_VALUE).left;
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertEquals((long)0L, (long)this.pool.tryCancel(f));
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertFalse((boolean)f.isCancelled());
    }
}

