/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceFailureListener;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FragmentInstanceStateMachineTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToFinished() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
            long time1 = System.currentTimeMillis();
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            long time2 = System.currentTimeMillis();
            Assert.assertEquals((Object)FragmentInstanceState.RUNNING, (Object)stateMachine.getState());
            Assert.assertTrue((stateMachine.getCreatedTime() >= time1 && stateMachine.getCreatedTime() <= time2 ? 1 : 0) != 0);
            Assert.assertEquals((Object)instanceId, (Object)stateMachine.getFragmentInstanceId());
            ListenableFuture future = stateMachine.getStateChange(FragmentInstanceState.RUNNING);
            stateMachine.transitionToFlushing();
            Assert.assertEquals((Object)FragmentInstanceState.FLUSHING, (Object)stateMachine.getState());
            Assert.assertEquals((Object)FragmentInstanceState.FLUSHING, (Object)future.get());
            stateMachine.addSourceTaskFailureListener((FragmentInstanceFailureListener)Mockito.mock(FragmentInstanceFailureListener.class));
            stateMachine.sourceTaskFailed(instanceId, (Throwable)new RuntimeException("Unknown"));
            stateMachine.finished();
            Assert.assertEquals((Object)FragmentInstanceState.FINISHED, (Object)stateMachine.getState());
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToCancel() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            Assert.assertEquals((Object)FragmentInstanceState.RUNNING, (Object)stateMachine.getState());
            stateMachine.cancel();
            Assert.assertEquals((Object)FragmentInstanceState.CANCELLED, (Object)stateMachine.getState());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToAbort() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            Assert.assertEquals((Object)FragmentInstanceState.RUNNING, (Object)stateMachine.getState());
            stateMachine.abort();
            Assert.assertEquals((Object)FragmentInstanceState.ABORTED, (Object)stateMachine.getState());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

