/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.exception.CpuNotEnoughException;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceExecution;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.schedule.IDriverScheduler;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FragmentInstanceExecutionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFragmentInstanceExecution() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            IDriverScheduler scheduler = (IDriverScheduler)Mockito.mock(IDriverScheduler.class);
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            DataRegion dataRegion = (DataRegion)Mockito.mock(DataRegion.class);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            fragmentInstanceContext.initializeNumOfDrivers(1);
            fragmentInstanceContext.setMayHaveTmpFile(true);
            fragmentInstanceContext.setDataRegion((IDataRegionForQuery)dataRegion);
            List drivers = Collections.emptyList();
            ISink sinkHandle = (ISink)Mockito.mock(ISink.class);
            long timeOut = -1L;
            MPPDataExchangeManager exchangeManager = (MPPDataExchangeManager)Mockito.mock(MPPDataExchangeManager.class);
            FragmentInstanceExecution execution = FragmentInstanceExecution.createFragmentInstanceExecution((IDriverScheduler)scheduler, (FragmentInstanceId)instanceId, (FragmentInstanceContext)fragmentInstanceContext, drivers, (ISink)sinkHandle, (FragmentInstanceStateMachine)stateMachine, (long)timeOut, (boolean)false, (MPPDataExchangeManager)exchangeManager);
            Assert.assertEquals((Object)FragmentInstanceState.RUNNING, (Object)execution.getInstanceState());
            FragmentInstanceInfo instanceInfo = execution.getInstanceInfo();
            Assert.assertEquals((Object)FragmentInstanceState.RUNNING, (Object)instanceInfo.getState());
            Assert.assertEquals((long)fragmentInstanceContext.getEndTime(), (long)instanceInfo.getEndTime());
            Assert.assertEquals((Object)fragmentInstanceContext.getFailedCause(), (Object)instanceInfo.getMessage());
            Assert.assertEquals((Object)fragmentInstanceContext.getFailureInfoList(), (Object)instanceInfo.getFailureInfoList());
            Assert.assertEquals((long)fragmentInstanceContext.getStartTime(), (long)execution.getStartTime());
            Assert.assertEquals((long)timeOut, (long)execution.getTimeoutInMs());
            Assert.assertEquals((Object)stateMachine, (Object)execution.getStateMachine());
            fragmentInstanceContext.decrementNumOfUnClosedDriver();
            stateMachine.failed((Throwable)new RuntimeException("Unknown"));
            Assert.assertTrue((boolean)execution.getInstanceState().isFailed());
            List failureInfoList = execution.getInstanceInfo().getFailureInfoList();
            Assert.assertEquals((long)1L, (long)failureInfoList.size());
            Assert.assertEquals((Object)"Unknown", (Object)((FragmentInstanceFailureInfo)failureInfoList.get(0)).getMessage());
            Assert.assertEquals((Object)"Unknown", (Object)((FragmentInstanceFailureInfo)failureInfoList.get(0)).toException().getMessage());
        }
        catch (CpuNotEnoughException | MemoryNotEnoughException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

