/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.executor;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.protocol.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.db.queryengine.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.queryengine.execution.executor.RegionWriteExecutor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.trigger.executor.TriggerFireResult;
import org.apache.iotdb.db.trigger.executor.TriggerFireVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RegionWriteExecutorTest {
    @Test
    public void testInsertRowNode() throws ConsensusException {
        IConsensus dataRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        IConsensus schemaRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        DataNodeRegionManager regionManager = (DataNodeRegionManager)Mockito.mock(DataNodeRegionManager.class);
        SchemaEngine schemaEngine = (SchemaEngine)Mockito.mock(SchemaEngine.class);
        ClusterTemplateManager clusterTemplateManager = (ClusterTemplateManager)Mockito.mock(ClusterTemplateManager.class);
        TriggerFireVisitor triggerFireVisitor = (TriggerFireVisitor)Mockito.mock(TriggerFireVisitor.class);
        RegionWriteExecutor executor = new RegionWriteExecutor(dataRegionConsensus, schemaRegionConsensus, regionManager, schemaEngine, clusterTemplateManager, triggerFireVisitor);
        DataRegionId dataRegionGroupId = new DataRegionId(1);
        InsertRowNode planNode = null;
        try {
            planNode = this.getInsertRowNode();
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Mockito.when((Object)regionManager.getRegionLock((ConsensusGroupId)dataRegionGroupId)).thenReturn((Object)new ReentrantReadWriteLock());
        TSStatus writeResponse = (TSStatus)Mockito.mock(TSStatus.class);
        Mockito.when((Object)writeResponse.getCode()).thenReturn((Object)TSStatusCode.SUCCESS_STATUS.getStatusCode());
        Mockito.when((Object)triggerFireVisitor.process((PlanNode)planNode, TriggerEvent.BEFORE_INSERT)).thenReturn((Object)TriggerFireResult.TERMINATION);
        RegionExecutionResult res = executor.execute((ConsensusGroupId)dataRegionGroupId, (PlanNode)planNode);
        Assert.assertFalse((boolean)res.isAccepted());
        Mockito.when((Object)triggerFireVisitor.process((PlanNode)planNode, TriggerEvent.BEFORE_INSERT)).thenReturn((Object)TriggerFireResult.SUCCESS);
        Mockito.when((Object)dataRegionConsensus.write((ConsensusGroupId)dataRegionGroupId, (IConsensusRequest)planNode)).thenReturn((Object)writeResponse);
        Mockito.when((Object)triggerFireVisitor.process((PlanNode)planNode, TriggerEvent.AFTER_INSERT)).thenReturn((Object)TriggerFireResult.TERMINATION);
        res = executor.execute((ConsensusGroupId)dataRegionGroupId, (PlanNode)planNode);
        Assert.assertFalse((boolean)res.isAccepted());
        Mockito.when((Object)triggerFireVisitor.process((PlanNode)planNode, TriggerEvent.AFTER_INSERT)).thenReturn((Object)TriggerFireResult.SUCCESS);
        res = executor.execute((ConsensusGroupId)dataRegionGroupId, (PlanNode)planNode);
        Assert.assertTrue((boolean)res.isAccepted());
        Mockito.when((Object)dataRegionConsensus.write((ConsensusGroupId)dataRegionGroupId, (IConsensusRequest)planNode)).thenThrow(new Throwable[]{new ConsensusException("Error!")});
        res = executor.execute((ConsensusGroupId)dataRegionGroupId, (PlanNode)planNode);
        Assert.assertFalse((boolean)res.isAccepted());
    }

    private InsertRowNode getInsertRowNode() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false};
        return new InsertRowNode(new PlanNodeId("1"), new PartialPath("root.isp.d1"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, time, columns, false);
    }
}

