/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.executor;

import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.queryengine.execution.executor.RegionReadExecutor;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.VirtualDataRegion;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RegionReadExecutorTest {
    @Test
    public void testSuccessfulExecute() throws ConsensusException {
        DataRegionId dataRegionGroupId = new DataRegionId(1);
        FragmentInstanceId fragmentInstanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
        FragmentInstance fragmentInstance = (FragmentInstance)Mockito.mock(FragmentInstance.class);
        Mockito.when((Object)fragmentInstance.getId()).thenReturn((Object)fragmentInstanceId);
        IConsensus dataRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        IConsensus schemaRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        FragmentInstanceManager fragmentInstanceManager = (FragmentInstanceManager)Mockito.mock(FragmentInstanceManager.class);
        RegionReadExecutor executor = new RegionReadExecutor(dataRegionConsensus, schemaRegionConsensus, fragmentInstanceManager);
        FragmentInstanceInfo fragmentInstanceInfo = (FragmentInstanceInfo)Mockito.mock(FragmentInstanceInfo.class);
        Mockito.when((Object)fragmentInstanceInfo.getState()).thenReturn((Object)FragmentInstanceState.RUNNING);
        Mockito.when((Object)fragmentInstanceInfo.getMessage()).thenReturn((Object)"data-success");
        Mockito.when((Object)dataRegionConsensus.read((ConsensusGroupId)dataRegionGroupId, (IConsensusRequest)fragmentInstance)).thenReturn((Object)fragmentInstanceInfo);
        RegionExecutionResult res = executor.execute((ConsensusGroupId)dataRegionGroupId, fragmentInstance);
        Assert.assertTrue((boolean)res.isAccepted());
        Assert.assertEquals((Object)"data-success", (Object)res.getMessage());
        SchemaRegionId schemaRegionGroupId = new SchemaRegionId(1);
        Mockito.when((Object)fragmentInstanceInfo.getState()).thenReturn((Object)FragmentInstanceState.RUNNING);
        Mockito.when((Object)fragmentInstanceInfo.getMessage()).thenReturn((Object)"schema-success");
        Mockito.when((Object)schemaRegionConsensus.read((ConsensusGroupId)schemaRegionGroupId, (IConsensusRequest)fragmentInstance)).thenReturn((Object)fragmentInstanceInfo);
        res = executor.execute((ConsensusGroupId)schemaRegionGroupId, fragmentInstance);
        Assert.assertTrue((boolean)res.isAccepted());
        Assert.assertEquals((Object)"schema-success", (Object)res.getMessage());
    }

    @Test
    public void testResponseNullExecute() throws ConsensusException {
        DataRegionId dataRegionGroupId = new DataRegionId(1);
        FragmentInstanceId fragmentInstanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
        FragmentInstance fragmentInstance = (FragmentInstance)Mockito.mock(FragmentInstance.class);
        Mockito.when((Object)fragmentInstance.getId()).thenReturn((Object)fragmentInstanceId);
        IConsensus dataRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        IConsensus schemaRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        FragmentInstanceManager fragmentInstanceManager = (FragmentInstanceManager)Mockito.mock(FragmentInstanceManager.class);
        RegionReadExecutor executor = new RegionReadExecutor(dataRegionConsensus, schemaRegionConsensus, fragmentInstanceManager);
        Mockito.when((Object)dataRegionConsensus.read((ConsensusGroupId)dataRegionGroupId, (IConsensusRequest)fragmentInstance)).thenReturn(null);
        RegionExecutionResult res = executor.execute((ConsensusGroupId)dataRegionGroupId, fragmentInstance);
        Assert.assertFalse((boolean)res.isAccepted());
        Assert.assertEquals((Object)"ReadResponse is null", (Object)res.getMessage());
        SchemaRegionId schemaRegionGroupId = new SchemaRegionId(1);
        Mockito.when((Object)schemaRegionConsensus.read((ConsensusGroupId)schemaRegionGroupId, (IConsensusRequest)fragmentInstance)).thenReturn(null);
        res = executor.execute((ConsensusGroupId)schemaRegionGroupId, fragmentInstance);
        Assert.assertFalse((boolean)res.isAccepted());
        Assert.assertEquals((Object)"ReadResponse is null", (Object)res.getMessage());
    }

    @Test
    public void testFailedExecute() throws ConsensusException {
        DataRegionId dataRegionGroupId = new DataRegionId(1);
        FragmentInstanceId fragmentInstanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
        FragmentInstance fragmentInstance = (FragmentInstance)Mockito.mock(FragmentInstance.class);
        Mockito.when((Object)fragmentInstance.getId()).thenReturn((Object)fragmentInstanceId);
        IConsensus dataRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        IConsensus schemaRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        FragmentInstanceManager fragmentInstanceManager = (FragmentInstanceManager)Mockito.mock(FragmentInstanceManager.class);
        RegionReadExecutor executor = new RegionReadExecutor(dataRegionConsensus, schemaRegionConsensus, fragmentInstanceManager);
        Mockito.when((Object)dataRegionConsensus.read((ConsensusGroupId)dataRegionGroupId, (IConsensusRequest)fragmentInstance)).thenThrow(new Throwable[]{new ConsensusException("data-exception")});
        RegionExecutionResult res = executor.execute((ConsensusGroupId)dataRegionGroupId, fragmentInstance);
        Assert.assertFalse((boolean)res.isAccepted());
        Assert.assertEquals((Object)String.format("Execute FragmentInstance failed: %s", "data-exception"), (Object)res.getMessage());
        SchemaRegionId schemaRegionGroupId = new SchemaRegionId(1);
        Mockito.when((Object)schemaRegionConsensus.read((ConsensusGroupId)schemaRegionGroupId, (IConsensusRequest)fragmentInstance)).thenThrow(new Throwable[]{new ConsensusException("schema-exception")});
        res = executor.execute((ConsensusGroupId)schemaRegionGroupId, fragmentInstance);
        Assert.assertFalse((boolean)res.isAccepted());
        Assert.assertEquals((Object)String.format("Execute FragmentInstance failed: %s", "schema-exception"), (Object)res.getMessage());
    }

    @Test
    public void testExceptionHappened() throws ConsensusException {
        DataRegionId dataRegionGroupId = new DataRegionId(1);
        FragmentInstanceId fragmentInstanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
        FragmentInstance fragmentInstance = (FragmentInstance)Mockito.mock(FragmentInstance.class);
        Mockito.when((Object)fragmentInstance.getId()).thenReturn((Object)fragmentInstanceId);
        IConsensus dataRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        IConsensus schemaRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        FragmentInstanceManager fragmentInstanceManager = (FragmentInstanceManager)Mockito.mock(FragmentInstanceManager.class);
        RegionReadExecutor executor = new RegionReadExecutor(dataRegionConsensus, schemaRegionConsensus, fragmentInstanceManager);
        Mockito.when((Object)dataRegionConsensus.read((ConsensusGroupId)dataRegionGroupId, (IConsensusRequest)fragmentInstance)).thenThrow(new Throwable[]{new RuntimeException("Unknown")});
        RegionExecutionResult res = executor.execute((ConsensusGroupId)dataRegionGroupId, fragmentInstance);
        Assert.assertFalse((boolean)res.isAccepted());
        Assert.assertEquals((Object)String.format("Execute FragmentInstance failed: %s", "Unknown"), (Object)res.getMessage());
    }

    @Test
    public void testVirtualDataRegion() {
        FragmentInstanceId fragmentInstanceId = new FragmentInstanceId(new PlanFragmentId(QueryId.MOCK_QUERY_ID, 0), "0");
        FragmentInstance fragmentInstance = (FragmentInstance)Mockito.mock(FragmentInstance.class);
        Mockito.when((Object)fragmentInstance.getId()).thenReturn((Object)fragmentInstanceId);
        IConsensus dataRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        IConsensus schemaRegionConsensus = (IConsensus)Mockito.mock(IConsensus.class);
        FragmentInstanceManager fragmentInstanceManager = (FragmentInstanceManager)Mockito.mock(FragmentInstanceManager.class);
        RegionReadExecutor executor = new RegionReadExecutor(dataRegionConsensus, schemaRegionConsensus, fragmentInstanceManager);
        FragmentInstanceInfo fragmentInstanceInfo = (FragmentInstanceInfo)Mockito.mock(FragmentInstanceInfo.class);
        Mockito.when((Object)fragmentInstanceInfo.getState()).thenReturn((Object)FragmentInstanceState.RUNNING);
        Mockito.when((Object)fragmentInstanceInfo.getMessage()).thenReturn((Object)"data-success");
        Mockito.when((Object)fragmentInstanceManager.execDataQueryFragmentInstance(fragmentInstance, (IDataRegionForQuery)VirtualDataRegion.getInstance())).thenReturn((Object)fragmentInstanceInfo);
        RegionExecutionResult res = executor.execute(fragmentInstance);
        Assert.assertTrue((boolean)res.isAccepted());
        Assert.assertEquals((Object)"data-success", (Object)res.getMessage());
        Mockito.when((Object)fragmentInstanceManager.execDataQueryFragmentInstance(fragmentInstance, (IDataRegionForQuery)VirtualDataRegion.getInstance())).thenThrow(new Throwable[]{new RuntimeException("Unknown")});
        res = executor.execute(fragmentInstance);
        Assert.assertFalse((boolean)res.isAccepted());
        Assert.assertEquals((Object)String.format("Execute FragmentInstance failed: %s", "Unknown"), (Object)res.getMessage());
    }
}

